/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.function.HgEnclosure;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.flow.HgFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.translate.HgTranslate;
import com.jxdinfo.hussar.formdesign.hg.util.HgPublicEnclosure;
import com.jxdinfo.hussar.formdesign.hg.util.HgTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HIGHGOFLOWENCLOSURE")
public class HgFlowEnclosure
implements HgEnclosure<HgFlowDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(HgFlowEnclosure.class);
    public static final String ENCLOSURE = "HIGHGOFLOWENCLOSURE";

    @Override
    public HgDataModelBaseDTO enclosure(HgFlowDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        List<HgDataModelField> dataModelFieldBases;
        HgFlowDataModelDTO dataModelBaseDTO = new HgFlowDataModelDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        HgPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isEmpty(dataModelFieldBases = dataModelBase.getFlowFields())) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new HgFlowDataModelDTO();
        }
        ArrayList<HgDataModelFieldDto> tableFields = new ArrayList<HgDataModelFieldDto>();
        for (HgDataModelField dataModelFieldBase : dataModelFieldBases) {
            HgDataModelFieldDto tableField = new HgDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        List<HgTranslate> translates = dataModelBase.getTranslate();
        if (ToolUtil.isNotEmpty(translates)) {
            List rightFields = ModelProvideAdapter.adaptor((String)dataModelBase.getId()).getFields(dataModelBase.getId());
            List<Map<String, Object>> translateAnnotations = HgTranslateUtil.translate(translates, rightFields);
            if (ToolUtil.isNotEmpty(translateAnnotations)) {
                List<HgDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                block1: for (Map map : translateAnnotations) {
                    if (!ToolUtil.isNotEmpty((Object)map) || !ToolUtil.isNotEmpty(map.get("fieldId"))) continue;
                    for (HgDataModelFieldDto field : fields) {
                        if (!field.getId().equals(map.get("fieldId").toString())) continue;
                        field.setFieldAnnotation(map.get("fieldAnnotation").toString());
                        continue block1;
                    }
                }
                dataModelBaseDTO.setFields(fields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<HgDataModelFieldDto> translateShowFields = HgTranslateUtil.getTranslateShowFields(translates);
            for (HgDataModelFieldDto hgDataModelFieldDto : translateShowFields) {
                if (null == hgDataModelFieldDto.getColumnType() || null == hgDataModelFieldDto.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(hgDataModelFieldDto.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
        return dataModelBaseDTO;
    }
}

