/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hg.function.customOption.task;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.hg.code.HgCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.hg.ctx.HgBackCtx;
import com.jxdinfo.hussar.formdesign.hg.function.HgCustomOperation;
import com.jxdinfo.hussar.formdesign.hg.function.element.base.HgBaseDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.task.HgTaskDataModel;
import com.jxdinfo.hussar.formdesign.hg.function.element.task.HgTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.HgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelField;
import com.jxdinfo.hussar.formdesign.hg.function.modelentity.field.HgDataModelFieldDto;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component(value="HIGHGOTASKCUSTOM_OPTION")
public class HgTaskCustomOption
implements HgCustomOperation<HgTaskDataModel, HgTaskDataModelDTO> {
    public static final String CUSTOM_OPTION = "HIGHGOTASKCUSTOM_OPTION";

    @Override
    public void publishCustomOption(HgBackCtx<HgTaskDataModel, HgTaskDataModelDTO> backCtx) throws LcdpException {
        this.publishTaskDataBackFill(backCtx);
    }

    private void publishTaskDataBackFill(HgBackCtx<HgTaskDataModel, HgTaskDataModelDTO> backCtx) throws LcdpException {
        if (ToolUtil.isEmpty((Object)backCtx.getParams()) || ToolUtil.isEmpty(backCtx.getParams().get("identity"))) {
            return;
        }
        HgTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        HgTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        if (ToolUtil.isEmpty(useDataModelDTO.getCustomCodeGenerateInfo())) {
            useDataModelDTO.setCustomCodeGenerateInfo(new HashMap<String, HgCodeGenerateInfo>());
        }
        useDataModelDTO.getCustomCodeGenerateInfo().put(useDataModelBase.getId(), this.genTaskDataBackFillCode(backCtx));
    }

    private HgCodeGenerateInfo genTaskDataBackFillCode(HgBackCtx<HgTaskDataModel, HgTaskDataModelDTO> backCtx) throws LcdpException {
        HgTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        HgTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        HgBaseDataModel task = useDataModelBase.getTask();
        String taskId = task.getId();
        HgDataModelBaseDTO userTaskModelDTO = useDataModelDTO.getDataModelDtoMap().get(taskId);
        HgDataModelBaseDTO userBusinessModelDTO = useDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getId());
        String modulePath = useDataModelDTO.getTablePath().toLowerCase();
        String fileName = userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl";
        String writePath = modulePath + File.separator + "Task".toLowerCase() + File.separator + fileName + ".java";
        String dataBackFillPath = "template/hg/taskbackcode/code/task_data_backfill_service_impl.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("package", userTaskModelDTO.getPackageInfo().get("Task"));
        params.put("className", fileName);
        params.put("identity", backCtx.getParams().get("identity"));
        TreeSet<String> imports = new TreeSet<String>();
        params.put("implementServiceNameImportInfo", "com.jxdinfo.hussar.workflow.task.model.service.TaskModelService");
        params.put("implementServiceName", "TaskModelService");
        params.put("ProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto");
        params.put("DeletedProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto");
        params.put("ProcessNodeInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto");
        params.put("CompleteTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto");
        params.put("UpdateTaskUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto");
        params.put("WorkflowUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto");
        params.put("TaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto");
        params.put("DeletedTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto");
        params.put("taskEntity", userTaskModelDTO.getEntityName());
        params.put("taskEntityImportInfo", userTaskModelDTO.getImportInfo().get("Entity"));
        params.put("taskServiceName", userTaskModelDTO.getServiceName());
        params.put("taskServiceImportInfo", userTaskModelDTO.getImportInfo().get("Service"));
        params.put("businessServiceName", userBusinessModelDTO.getServiceName());
        params.put("businessServiceImportInfo", userBusinessModelDTO.getImportInfo().get("Service"));
        params.put("businessEntity", userBusinessModelDTO.getEntityName());
        params.put("businessEntityImportInfo", userBusinessModelDTO.getImportInfo().get("Entity"));
        HashMap<String, String> businessColumn = new HashMap<String, String>();
        List<HgDataModelFieldDto> businessFields = userBusinessModelDTO.getFields();
        for (HgDataModelFieldDto hgDataModelFieldDto : businessFields) {
            if (!ToolUtil.isNotEmpty((Object)hgDataModelFieldDto.getFill())) continue;
            businessColumn.put(hgDataModelFieldDto.getFill(), hgDataModelFieldDto.getName());
            if (!"primary".equals(hgDataModelFieldDto.getFill())) continue;
            params.put("primaryType", hgDataModelFieldDto.getColumnType().getType());
            if (!ToolUtil.isNotEmpty((Object)hgDataModelFieldDto.getColumnType().getImportT())) continue;
            imports.add(hgDataModelFieldDto.getColumnType().getImportT());
        }
        params.put("businessColumn", businessColumn);
        List<HgDataModelField> fields = task.getFields();
        for (HgDataModelField field : fields) {
            if ("foreign".equals(field.getUsage())) {
                params.put("taskForeign", field.getSourceFieldName());
            }
            if (!"taskId".equals(field.getName())) continue;
            params.put("taskTaskId", field.getSourceFieldName());
        }
        params.put("dataSourceName", useDataModelBase.getDataSourceName());
        params.put("imports", imports);
        HgCodeGenerateInfo hgCodeGenerateInfo = new HgCodeGenerateInfo();
        hgCodeGenerateInfo.setFileWriteRelativePath(writePath);
        hgCodeGenerateInfo.setFileContent(RenderUtil.renderTemplate((String)dataBackFillPath, params));
        hgCodeGenerateInfo.setFileType("serviceImpl");
        hgCodeGenerateInfo.setFileId(useDataModelDTO.getId());
        hgCodeGenerateInfo.setFileName(userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl" + ".java");
        return hgCodeGenerateInfo;
    }
}

