/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.flow.masterslaveflow.util.GaussFlowMsUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSFLOW_MASTER_SLAVEFlowFormSaveStart")
public class GaussMsFlowFormSaveStartVisitor
implements GaussOperationVisitor<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussMsFlowFormSaveStartVisitor.class);
    public static final String OPERATION_NAME = "GAUSSFLOW_MASTER_SLAVEFlowFormSaveStart";

    @Override
    public void visit(GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        GaussFlowMsDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        GaussDataModelFieldDto keyField = useDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> params = this.initParams(dataModelOperation, useDataModelDTO, backCtx);
        String masterId = backCtx.getUseDataModelBase().getMasterTable().getId();
        GaussFlowMsDataModelDTO gaussFlowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(masterId);
        if (gaussFlowMsDataModelDTO == null) {
            useDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().ifPresent(fieldDto -> params.put("securityLevel", fieldDto.getCapitalName()));
        } else {
            gaussFlowMsDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().ifPresent(fieldDto -> params.put("securityLevel", fieldDto.getCapitalName()));
        }
        String controllerPath = "template/gauss/flowbackcode/masterslaveflowbackcode/addorupdate/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, params));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/gauss/flowbackcode/masterslaveflowbackcode/addorupdate/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, params));
        String serviceImplPath = "template/gauss/flowbackcode/masterslaveflowbackcode/addorupdate/service_impl.ftl";
        params.put("primaryField", keyField.getCapitalName());
        GaussFlowMsUtil.renderMsInsertOrUpdate(params, backCtx);
        params.put("isRemote", VfgModeTool.isRemote());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, params));
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.dto.Increment");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        this.renderImport(backCtx, modelId, useDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6d41\u7a0b\u8868\u5355\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, String modelId, GaussFlowMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.designer.vo.ResultProcessVO");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.designer.vo.ResultProcessVO");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.designer.vo.ResultProcessVO");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService");
    }

    private Map<String, Object> initParams(GaussDataModelOperation dataModelOperation, GaussFlowMsDataModelDTO gaussFlowDataModelDTO, GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx) {
        Map<String, Object> params = dataModelOperation.getParams();
        params.put("table", gaussFlowDataModelDTO);
        params.put("dataSourceAnnotation", GaussDataSourceUtil.getMethodDataSourceAnnotation());
        params.put("parameter", gaussFlowDataModelDTO.getQueryDtoMap().get(gaussFlowDataModelDTO.getName()).getEntityName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(gaussFlowDataModelDTO.getComment() + "\u4fdd\u5b58\u6d41\u7a0b\u8868\u5355");
            params.put("exegesis", dataModelOperation.getExegesis());
        }
        GaussFlowMsUtil.generateIncrementDTO(gaussFlowDataModelDTO, backCtx, dataModelOperation);
        return params;
    }
}

