/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSFLOWTableSave")
public class GaussFlowTableSaveVisitor
implements GaussOperationVisitor<GaussFlowDataModel, GaussFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussFlowTableSaveVisitor.class);
    public static final String OPERATION_NAME = "GAUSSFLOWTableSave";

    @Override
    public void visit(GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        GaussFlowDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = useDataModelBase.getId();
        GaussFlowDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        this.renderFillCode(backCtx, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/gauss/backcode/tableSave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/gauss/backcode/tableSave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        if (useDataModelBase.getLogicallyDelete()) {
            controllerParams.put("logicallyDelete", true);
            String logicallyFieldName = useDataModelBase.getDeleteFlag().getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("logicallyFlag", String.valueOf(chars));
        }
        String serviceImplPath = "template/gauss/backcode/tableSave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6570\u636e\u8868\u683c\u5bfc\u5165");
        backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO> backCtx, String modelId, GaussFlowDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
    }

    private Map<String, Object> initParams(GaussDataModelOperation dataModelOperation, GaussFlowDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void renderFillCode(GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO> backCtx, GaussBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) throws LcdpException {
        boolean hasFillField = false;
        for (GaussDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.core.util.ToolUtil");
                    if (field.getType().equals("date")) {
                        dataModelBaseDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    hasFillField = true;
                    break;
                }
            }
        }
        if (hasFillField) {
            String fillPath = "template/gauss/backcode/tableSave/fill.ftl";
            String fillCode = RenderUtil.renderTemplate((String)fillPath, controllerParams);
            controllerParams.put("fillCode", fillCode);
        }
    }
}

