/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussEnclosure;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussRender;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryCondition;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryObject;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.sortcondition.GaussSortCondition;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.sortcondition.GaussSortConditionField;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataModelUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GaussMsDataModel
extends GaussDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(GaussMsDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<GaussQueryCondition> queryConditions;
    private List<GaussQueryObject> queryObject;
    private GaussDataModelBase masterTable;
    private List<GaussDataModelBase> slaveTables;
    private List<GaussRelationshipBase> relationships;
    private boolean logicallyDelete;
    private List<GaussSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"GAUSS.MASTER_SLAVE", GaussMsDataModel.class);
    }

    @Override
    public GaussMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        GaussMsDataModel gaussMsDataModel;
        try {
            ArrayList<GaussDataModelField> fieldList = new ArrayList<GaussDataModelField>();
            gaussMsDataModel = (GaussMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), GaussMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                GaussDataModelBase master = GaussDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(gaussMsDataModel.getName() + "Master");
                gaussMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<GaussDataModelBase> slaveTables = new ArrayList<GaussDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    GaussDataModelBase slaveTable = GaussDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (GaussRelationshipBase relationship : gaussMsDataModel.getRelationships()) {
                    GaussDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(GaussBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    GaussDataModelField gaussDataModelField = new GaussDataModelField();
                    gaussDataModelField.setId(UUID.randomUUID().toString());
                    gaussDataModelField.setName(dataModelBase.getName());
                    gaussDataModelField.setComment(dataModelBase.getComment());
                    gaussDataModelField.setSourceDataModelId(dataModelBase.getId());
                    gaussDataModelField.setDataType("array");
                    fieldList.add(gaussDataModelField);
                }
                gaussMsDataModel.setSlaveTables(slaveTables);
            }
            gaussMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return gaussMsDataModel;
    }

    @Override
    public GaussEnclosure<GaussDataModelBase> enclosure() throws LcdpException {
        return GaussModelBeanUtil.getEnclosureBean("GAUSS", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public GaussRender<GaussDataModelBase, GaussDataModelBaseDTO> render() throws LcdpException {
        return GaussModelBeanUtil.getRenderBean("GAUSS", FUNCTION_TYPE, "RENDER");
    }

    public GaussDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(GaussDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<GaussDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<GaussDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<GaussRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<GaussRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<GaussQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<GaussQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<GaussQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<GaussQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<GaussSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (GaussSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (GaussSortConditionField field : condition.getFields()) {
                    Map<String, String> fieldMap;
                    String fieldName;
                    if (HussarUtils.isEmpty((Object)field.getParentModelId())) {
                        field.setParentModelId(field.getFromModelIdSort());
                    }
                    GaussDataModelBase dataModelBase = this.masterTable;
                    if (!this.masterTable.getId().equals(field.getFromModelIdSort())) {
                        for (GaussDataModelBase modelBase : this.slaveTables) {
                            if (!modelBase.getId().equals(field.getFromModelIdSort())) continue;
                            dataModelBase = modelBase;
                            break;
                        }
                    }
                    if (HussarUtils.equals((Object)(fieldName = (fieldMap = dataModelBase.getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName))).get(field.getFromModelFieldIdSort())), (Object)field.getFromModelFieldSort())) continue;
                    field.setFromModelFieldSort(fieldName);
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<GaussSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public boolean isLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public GaussQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (GaussQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public GaussSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (GaussSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return "";
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.masterTable.getId(), "T2");
        if (ToolUtil.isNotEmpty(this.relationships) && !this.relationships.isEmpty()) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                GaussRelationshipBase relationship = this.relationships.get(i);
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        return finalMap;
    }

    public DataSet getDataSetById(String dataSetId) {
        if (this.getDataSets() != null) {
            for (DataSet dataSet : this.getDataSets()) {
                if (!dataSet.getId().equals(dataSetId)) continue;
                return dataSet;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<GaussDataModelField>> findTableContrast() throws IOException, LcdpException {
        List<ContrastVO<GaussDataModelField>> tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<GaussDataModelField>> tableContrastModel(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<GaussDataModelField>> tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<GaussDataModelField>> modelContrastTable(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<GaussDataModelField>> tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            if (!HussarUtils.isEmpty(map.get(this.slaveTables.get(i).getSourceDataModelName()))) continue;
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
            map.put(this.slaveTables.get(i).getSourceDataModelName(), true);
        }
        return tableContrast;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.masterTable.checkTableContrast(modelId).getDetails().get(0));
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            details.add(this.slaveTables.get(i).checkTableContrast(modelId).getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            this.slaveTables.get(i).updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws Exception {
        String sql = this.masterTable.copyTableByModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            sql = sql + this.slaveTables.get(i).copyTableByModel(fieldsContrastParam);
        }
        return sql;
    }

    public GaussDataModelField getDeleteFlag() {
        return this.getMasterTable().getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public GaussDataModelField getUpdateTime() {
        return this.masterTable.getFields().stream().filter(field -> "updateTime".equals(field.getUsage())).findFirst().orElse(null);
    }

    public GaussDataModelField getPrimaryKey() {
        return this.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        List<GaussDataModelBase> slaveTables = this.getSlaveTables();
        for (GaussDataModelBase slaveTable : slaveTables) {
            GaussDataModelField gaussDataModelField = slaveTable.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(new GaussDataModelField());
            HashMap<String, Object> val = new HashMap<String, Object>();
            val.put("comment", slaveTable.getComment());
            val.put("primary", gaussDataModelField.getName());
            val.put("fields", slaveTable.getFields());
            boolean association = this.getRelationships().stream().anyMatch(relationship -> relationship.getRelateModelType().equals(ASSOCIATION) && relationship.getSlaveTableId().equals(slaveTable.getId()));
            val.put(ASSOCIATION, association);
            map.put(slaveTable.getId(), val);
        }
        return map;
    }
}

