/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.task.basetask;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.task.basetask.GaussTaskAsyncVerifyVisitor;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSTASKUniqueVerify")
public class GaussTaskUniqueVerifyVisitor
implements GaussOperationVisitor<GaussTaskDataModel, GaussTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussTaskAsyncVerifyVisitor.class);
    public static final String OPERATION_NAME = "GAUSSTASKUniqueVerify";

    @Override
    public void visit(GaussBackCtx<GaussTaskDataModel, GaussTaskDataModelDTO> taskBackCtx, GaussDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        GaussFlowDataModelDTO dataModelBaseDTO = (GaussFlowDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        GaussFlowDataModel gaussBaseDataModel = (GaussFlowDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO> backCtx = new GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO>();
        backCtx.setUseDataModelBase(gaussBaseDataModel);
        HashMap<String, GaussFlowDataModelDTO> map = new HashMap<String, GaussFlowDataModelDTO>();
        map.put(modelId, dataModelBaseDTO);
        backCtx.setUseDataModelDtoMap(map);
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        controllerParams.put("getPrimaryMethod", String.format("%s%s", "get", dataModelBaseDTO.getPrimaryKeyFirstToUpper()));
        controllerParams.put("name", dataModelOperation.getName());
        if (ToolUtil.isNotEmpty((Object)dataModelOperation.getExegesis())) {
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        } else {
            controllerParams.put("exegesis", dataModelBaseDTO.getComment() + "\u552f\u4e00\u6027\u6821\u9a8c");
        }
        controllerParams.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        controllerParams.put("entityName", dataModelBaseDTO.getEntityName());
        controllerParams.put("mapperEnName", dataModelBaseDTO.getMapperEnName());
        controllerParams.put("table", dataModelBaseDTO);
        String controllerPath = "template/gauss/backcode/uniqueverify/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/gauss/backcode/uniqueverify/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/gauss/backcode/uniqueverify/service_impl.ftl";
        List<GaussDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        boolean isLogicallyDelete = gaussBaseDataModel.getLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            GaussDataModelField logicallyField = gaussBaseDataModel.getDeleteFlag();
            for (GaussDataModelFieldDto field : fields) {
                if (!field.getId().equals(logicallyField.getId())) continue;
                controllerParams.put("logicallyFlag", field.getCapitalName());
                break;
            }
        }
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u552f\u4e00\u6027\u6821\u9a8c");
        backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO> backCtx, String modelId, GaussBaseDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
    }
}

