/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSMASTER_SLAVEDeleteBatch")
public class GaussMsDeleteListCodeVisitor
implements GaussOperationVisitor<GaussMsDataModel, GaussMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussMsDeleteListCodeVisitor.class);
    private static final String DELGETSTR = "::get";
    public static final String OPERATION_NAME = "GAUSSMASTER_SLAVEDeleteBatch";

    @Override
    public void visit(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, GaussDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String currentModelId = backCtx.getUseDataModelBase().getId();
        GaussMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        GaussMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        GaussDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<GaussRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            logger.error("\u5b50\u8868\u5173\u8054\u5173\u7cfb\u5bf9\u8c61\u96c6\u5408\u4e3a\u7a7a\u6216\u4e3b\u8868\u5bf9\u8c61\u4e3a\u7a7a");
            return;
        }
        GaussDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        StringBuilder relationStr = this.getDelStr(relationshipDtoList, masterDto);
        String url = baseDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, Object> params = operation.getParams();
        List<GaussDataModelFieldDto> fields = baseDataModelDTO.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i).getId().equals(operation.getParams().get("mainId"))) {
                params.put("mainId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (fields.get(i).getId().equals(operation.getParams().get("pId"))) {
                params.put("pId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (!HussarUtils.isNotEmpty((Object)fields.get(i).getFill()) || !fields.get(i).getFill().equals("primary")) continue;
            params.put("mainName", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
        }
        params.put("masterTable", masterDto);
        params.put("table", baseDataModelDTO);
        params.put("masterSlaveTable", baseDataModelDTO);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        params.put("url", url);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            params.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(baseDataModelDTO.getComment() + "\u7269\u7406\u5220\u9664\u4e3b\u5b50");
            params.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/gauss/masterslavebackcode/deletelist/controller.ftl";
        backCtx.addControllerCode(currentModelId, RenderUtil.renderTemplate((String)controllerPath, params));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "java.util.Arrays");
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(currentModelId, baseDataModelDTO.getServiceName());
        logger.debug("\u751f\u6210service\u6267\u884c\u5f00\u59cb");
        String servicePath = "template/gauss/masterslavebackcode/deletelist/service.ftl";
        backCtx.addServiceImport(currentModelId, "java.util.List");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceCode(currentModelId, RenderUtil.renderTemplate((String)servicePath, params));
        logger.debug("\u751f\u6210serviceImpl\u6267\u884c\u5f00\u59cb");
        boolean delFlag = true;
        for (GaussRelationshipDTO gaussRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            GaussDataModelBaseDTO gaussDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(gaussRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, gaussDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, gaussDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, gaussDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        String implPath = "template/gauss/masterslavebackcode/deletelist/service_impl.ftl";
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplCode(currentModelId, RenderUtil.renderTemplate((String)implPath, params));
        backCtx.addServiceImplImport(currentModelId, "org.springframework.beans.factory.annotation.Autowired");
        backCtx.addServiceImplImport(currentModelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
        backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Mapper"));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postForm", baseDataModelDTO.getApiPrefix() + "/" + operation.getName(), "\u5220\u9664");
        backCtx.addApi(currentModelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    public StringBuilder getDelStr(List<GaussRelationshipDTO> relationshipDtoList, GaussDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (GaussRelationshipDTO relationtMap : relationshipDtoList) {
            List<GaussRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            GaussRelationshipFieldDTO gaussRelationshipFieldDTO = relationShipsList.get(0);
            if (relationShipsList.size() == 1) {
                Optional<GaussDataModelFieldDto> relationTag;
                relationStr.append(GaussMsDeleteListCodeVisitor.lowercase(relationtMap.getSlaveTableName())).append("Wrapper.lambda().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(gaussRelationshipFieldDTO.getSlaveFieldCap()).append(",").append(GaussMsDeleteListCodeVisitor.lowercase(masterDto.getEntityName())).append(".get").append(gaussRelationshipFieldDTO.getMasterFieldCap()).append("())");
                List<GaussDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    GaussDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(";\n");
            } else {
                relationStr.append(GaussMsDeleteListCodeVisitor.lowercase(relationtMap.getSlaveTableName())).append("Wrapper.lambda().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(gaussRelationshipFieldDTO.getSlaveFieldCap()).append(",").append(GaussMsDeleteListCodeVisitor.lowercase(masterDto.getEntityName())).append(".get").append(gaussRelationshipFieldDTO.getMasterFieldCap()).append("())");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                Optional<GaussDataModelFieldDto> relationTag;
                GaussRelationshipFieldDTO gaussRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(gaussRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(gaussRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(gaussRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(GaussMsDeleteListCodeVisitor.lowercase(masterDto.getEntityName())).append(".get").append(gaussRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(gaussRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(GaussMsDeleteListCodeVisitor.lowercase(masterDto.getEntityName())).append(".get").append(gaussRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                List<GaussDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    GaussDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(";\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }
}

