/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.task.masterslavetask;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.gaussQueryDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.constant.GaussConstUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.masterslave.util.GaussMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSTASK_MASTER_SLAVEDataImport")
public class GaussMsTaskDataImportVisitor
implements GaussOperationVisitor<GaussTaskMsDataModel, GaussTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussMsTaskDataImportVisitor.class);
    public static final String OPERATION_NAME = "GAUSSTASK_MASTER_SLAVEDataImport";

    @Override
    public void visit(GaussBackCtx<GaussTaskMsDataModel, GaussTaskMsDataModelDTO> taskBackCtx, GaussDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        GaussFlowMsDataModelDTO flowMsDataModelDTO = (GaussFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        GaussFlowMsDataModel flowMsDataModel = (GaussFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx = new GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(flowMsDataModel);
        HashMap<String, GaussFlowMsDataModelDTO> map = new HashMap<String, GaussFlowMsDataModelDTO>();
        map.put(modelId, flowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, flowMsDataModelDTO);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        for (GaussDataModelBase gaussDataModelBase : flowMsDataModel.getSlaveTables()) {
            GaussDataModelBaseDTO gaussDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(gaussDataModelBase.getId());
            String slaveModelName = gaussDataModelBase.getName();
            for (GaussDataModelFieldDto gaussDataModelFieldDto : gaussDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(gaussDataModelFieldDto.getFill())) continue;
                relationTagKeys.put(slaveModelName, gaussDataModelFieldDto.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        HashMap<String, Boolean> slaveTablePlusSave = new HashMap<String, Boolean>();
        for (GaussRelationshipDTO relationshipDTO : flowMsDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        for (GaussDataModelBase modelBase : flowMsDataModel.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((GaussBaseDataModel)modelBase).getLogicallyDelete());
            GaussDataModelBaseDTO gaussDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, GaussMasterSlaveUtil.getCapitalName(slaveModelName));
            for (GaussDataModelField gaussDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(gaussDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, gaussDataModelField.getName());
            }
            for (GaussDataModelFieldDto gaussDataModelFieldDto : gaussDataModelBaseDTO.getFields()) {
                if ("primary".equals(gaussDataModelFieldDto.getFill())) {
                    primaryKeys.put(slaveModelName, gaussDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(gaussDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, gaussDataModelFieldDto.getCapitalName());
            }
        }
        this.addFormPlusSaveDto(flowMsDataModel, flowMsDataModelDTO, backCtx, slaveTablePlusSave);
        controllerParams.put("table", flowMsDataModelDTO);
        controllerParams.put("returnValue", flowMsDataModelDTO.getEntityName());
        GaussDataModelBaseDTO gaussDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(flowMsDataModel.getMasterTable().getId());
        controllerParams.put("masterTable", gaussDataModelBaseDTO);
        String controllerPath = "template/gauss/taskbackcode/masterslavetaskbackcode/templateImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, flowMsDataModelDTO.getServiceName());
        String servicePath = "template/gauss/taskbackcode/masterslavetaskbackcode/templateImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        this.masterSlaveCode(backCtx, controllerParams);
        GaussDataModelFieldDto keyField = flowMsDataModelDTO.getKeyField();
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        String string = "template/gauss/taskbackcode/masterslavetaskbackcode/templateImport/service_impl.ftl";
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        controllerParams.put("primaryKeys", primaryKeys);
        controllerParams.put("foreignKeys", foreignKeys);
        controllerParams.put("slaveTable", GaussMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        controllerParams.put("isLogicallyDelete", isLogicallyDelete);
        controllerParams.put("logicallyDelField", logicallyDelField);
        controllerParams.put("capitalNameList", capitalNameList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        this.renderImport(backCtx, modelId, flowMsDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", flowMsDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, String modelId, GaussFlowMsDataModelDTO flowMsDataModelDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.template.print.utils.VerifyExcelUtil");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.model.SysExcelTask");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.constants.TaskConstants");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.service.ISysExcelTaskService");
        backCtx.addServiceImplImport(modelId, "java.time.LocalDateTime");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplInversion(modelId, "ISysExcelTaskService");
        backCtx.addServiceImplInversion(modelId, "HussarThreadPoolConfiguration");
        backCtx.addServiceImplImport(modelId, "java.io.IOException");
        backCtx.addServiceImplImport(modelId, "java.io.InputStream");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.SecurityUser");
        backCtx.addServiceImplImport(modelId, "java.util.concurrent.Executor");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration");
    }

    private Map<String, Object> initParams(GaussDataModelOperation dataModelOperation, GaussMsDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6a21\u677f\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void masterSlaveCode(GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        GaussFlowMsDataModel flowMsDataModel = backCtx.getUseDataModelBase();
        String modelId = flowMsDataModel.getId();
        GaussFlowMsDataModelDTO flowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<GaussRelationshipDTO> relationshipDtoList = flowMsDataModelDTO.getRelationshipDtoList();
        GaussDataModelBase masterTable = flowMsDataModel.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, GaussDataModelBaseDTO> dataModelDtoMap = flowMsDataModelDTO.getDataModelDtoMap();
        GaussDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(backCtx, mainDataModelDto, flowMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)flowMsDataModel) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (GaussRelationshipDTO gaussRelationshipDTO : relationshipDtoList) {
                List<GaussRelationshipFieldDTO> gaussRelationshipFieldDTOS;
                String slaveTableId = gaussRelationshipDTO.getSlaveTableId();
                String relateModelType = gaussRelationshipDTO.getRelateModelType();
                GaussDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, flowMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    gaussRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(gaussRelationshipFieldDTOS = gaussRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, GaussDataModelBaseDTO dataModelBaseDTO, GaussFlowMsDataModelDTO msDataModelDTO, boolean isMs, GaussDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (GaussDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", GaussConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", GaussConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", GaussConstUtil.TRUE);
                    break;
                }
                case "primary": {
                    insertFill = true;
                    params.put("insertFill", GaussConstUtil.TRUE);
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.support.engine.core.util.EngineUtil");
                    params.put("primaryFill", GaussConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/gauss/masterslavebackcode/templateImport/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private void addFormPlusSaveDto(GaussFlowMsDataModel flowMsDataModel, GaussFlowMsDataModelDTO flowMsDataModelDTO, GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        gaussQueryDTO queryDTO = new gaussQueryDTO();
        String modelId = flowMsDataModel.getId();
        String masterId = flowMsDataModel.getMasterTable().getId();
        queryDTO.setFtlPath("template/gauss/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", flowMsDataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", GaussMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", flowMsDataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(flowMsDataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(flowMsDataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(flowMsDataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(flowMsDataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = flowMsDataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        flowMsDataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }
}

