/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.flow.masterslaveflow.util.GaussFlowMsUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSFLOW_MASTER_SLAVEPrevNodeReject")
public class GaussMsFlowPrevNodeRejectCodeVisitor
implements GaussOperationVisitor<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussMsFlowPrevNodeRejectCodeVisitor.class);
    public static final String OPERATION_NAME = "GAUSSFLOW_MASTER_SLAVEPrevNodeReject";

    @Override
    public void visit(GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        GaussFlowMsDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        GaussDataModelFieldDto keyField = useDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> params = this.initParams(dataModelOperation, useDataModelDTO, backCtx);
        params.put("primaryField", keyField.getCapitalName());
        this.renderImport(backCtx, modelId, useDataModelDTO);
        String controllerPath = "template/gauss/flowbackcode/masterslaveflowbackcode/prevnodereject/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, params));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/gauss/flowbackcode/masterslaveflowbackcode/prevnodereject/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, params));
        GaussFlowMsUtil.renderMsInsertOrUpdate(params, backCtx);
        String serviceImplPath = "template/gauss/flowbackcode/masterslaveflowbackcode/prevnodereject/service_impl.ftl";
        params.put("isRemote", VfgModeTool.isRemote());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, params));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9");
        backCtx.addApi(useDataModelDTO.getId(), GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, String modelId, GaussFlowMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "org.springframework.aop.framework.AopContext");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getImportInfo());
    }

    private Map<String, Object> initParams(GaussDataModelOperation dataModelOperation, GaussFlowMsDataModelDTO dataModelBaseDTO, GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx) {
        Map<String, Object> params = dataModelOperation.getParams();
        params.put("table", dataModelBaseDTO);
        params.put("dataSourceAnnotation", GaussDataSourceUtil.getMethodDataSourceAnnotation());
        params.put("parameter", dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getEntityName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9");
            params.put("exegesis", dataModelOperation.getExegesis());
        }
        GaussFlowMsUtil.generateIncrementDTO(dataModelBaseDTO, backCtx, dataModelOperation);
        return params;
    }
}

