/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.gaussQueryDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.constant.GaussConstUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.masterslave.util.GaussMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSFLOW_MASTER_SLAVEFormQuery")
public class GaussMsFlowFormQueryVisitor
implements GaussOperationVisitor<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussMsFlowFormQueryVisitor.class);
    public static final String OPERATION_NAME = "GAUSSFLOW_MASTER_SLAVEFormQuery";

    @Override
    public void visit(GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, GaussDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        GaussFlowMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        GaussDataModelBase masterTable = dataModelBase.getMasterTable();
        GaussFlowMsDataModelDTO gaussFlowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = gaussFlowMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, GaussDataModelBase> dataModelBaseMap = gaussFlowMsDataModelDTO.getDataModelBaseMap();
        Map<String, GaussDataModelBaseDTO> dataModelDtoMap = gaussFlowMsDataModelDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = operation.getParams();
        Map slaveTablePlusSave = (Map)operation.getParams().get("slaveTablePlusSave");
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        controllerParams.put("table", gaussFlowMsDataModelDTO);
        controllerParams.put("returnValue", gaussFlowMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("isPlusQuery", false);
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            Map<String, String> slaveQueryNames;
            for (GaussDataModelBase slaveTable : dataModelBase.getSlaveTables()) {
                capitalNameList.put(slaveTable.getName(), GaussMasterSlaveUtil.getCapitalName(slaveTable.getName()));
            }
            controllerParams.put("boolFields", gaussFlowMsDataModelDTO.getFields().stream().filter(o -> "boolean".equals(o.getType())).collect(Collectors.toList()));
            controllerParams.put("capitalNameList", capitalNameList);
            controllerParams.put("returnIncrementValue", gaussFlowMsDataModelDTO.getEntityName() + "FormVO");
            controllerParams.put("slaveTable", GaussMsFlowFormQueryVisitor.getSlaveArrayTables(gaussFlowMsDataModelDTO, dataModelBase));
            controllerParams.put("primaryField", gaussFlowMsDataModelDTO.getKeyPropertyName());
            controllerParams.put("pageDTO", gaussFlowMsDataModelDTO.getEntityName() + "PageDTO");
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                controllerParams.put("isPlusQuery", true);
                break;
            }
            if (ToolUtil.isNotEmpty(slaveQueryNames = GaussMsFlowFormQueryVisitor.getSlaveQueryName(dataModelBase))) {
                controllerParams.put("slaveQueryNames", slaveQueryNames);
            }
            GaussDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
            backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
            backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
            GaussMsFlowFormQueryVisitor.addFormVO(gaussFlowMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
            GaussMsFlowFormQueryVisitor.addFormQueryDto(gaussFlowMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(gaussFlowMsDataModelDTO.getComment() + "\u8868\u5355\u67e5\u8be2");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/gauss/masterslavebackcode/get/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, gaussFlowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, gaussFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, gaussFlowMsDataModelDTO.getServiceName());
        String servicePath = "template/gauss/masterslavebackcode/get/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, gaussFlowMsDataModelDTO.getImportInfo().get("Entity"));
        String serviceImplPath = "template/gauss/masterslavebackcode/get/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, gaussFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, gaussFlowMsDataModelDTO.getImportInfo().get("Mapper"));
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        }
        if (ToolUtil.isNotEmpty((Object)gaussFlowMsDataModelDTO.isHasTranslate()) && gaussFlowMsDataModelDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addServiceImplInversion(modelId, gaussFlowMsDataModelDTO.getMapperName());
        String mapperPath = "template/gauss/masterslavebackcode/get/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, gaussFlowMsDataModelDTO.getImportInfo().get("Entity"));
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        String finalReturn = SqlReturnUtil.renderReturn(dataModelBase, aliasMap);
        controllerParams.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(dataModelBase, dataModelBaseMap);
        controllerParams.put("relation", finalRelation);
        controllerParams.put("quoteModel", GaussConstUtil.TRUE);
        String whereTemplate = "where ${T}.${primary} = #{id}";
        String masterTableId = masterTable.getId();
        GaussDataModelBaseDTO gaussDataModelBaseDTO = dataModelDtoMap.get(masterTableId);
        if (ToolUtil.isNotEmpty((Object)gaussDataModelBaseDTO)) {
            controllerParams.put("whereSql", whereTemplate.replace("${T}", aliasMap.get(masterTableId)).replace("${primary}", gaussDataModelBaseDTO.getKeyField().getName()));
        }
        if (ToolUtil.isNotEmpty((Object)controllerParams.get("customizeSql"))) {
            backCtx.addXmlCode(modelId, (String)controllerParams.get("customizeSql"));
        } else {
            String xmlPath = "template/gauss/masterslavebackcode/get/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "get", url, "\u8868\u5355\u67e5\u8be2");
        backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        if (((Boolean)controllerParams.get("isPlusQuery")).booleanValue()) {
            ApiGenerateInfo apiGenerateInfoPlus = new ApiGenerateInfo(operation.getName() + "Plus", "data", "postJson", url + "Plus", "\u589e\u91cf\u8868\u5355\u67e5\u8be2");
            backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfoPlus));
        }
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static void addFormVO(GaussMsDataModelDTO dataModelBaseDTO, GaussMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx) {
        gaussQueryDTO queryDTO = new gaussQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/gauss/backcode/code/formVo.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        params.put("voImport", dataModelBaseDTO.getPackageInfo().get("VO"));
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("Entity"));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("masterTable", dataModelBaseDTO.getFields());
        params.put("slaveTable", GaussMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "FormVO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "FormVO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("VO"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importVOPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + queryDTO.getEntityName();
        dataModelBaseDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importVOPath);
        backCtx.addServiceImport(modelId, importVOPath);
        backCtx.addServiceImplImport(modelId, importVOPath);
    }

    private static void addFormQueryDto(GaussMsDataModelDTO dataModelBaseDTO, GaussMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx) {
        gaussQueryDTO queryDTO = new gaussQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/gauss/backcode/code/formDto.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("slaveTable", GaussMsFlowFormQueryVisitor.getSlaveArrayTables(dataModelBaseDTO, dataModelBase));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("dto"));
        params.put("queryDto", queryDTO);
        params.put("priType", dataModelBaseDTO.getKeyField().getPropertyType());
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "PageDTO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "PageDTO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
        String importDTOPath = dataModelBaseDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }

    private static List<GaussDataModelBase> getSlaveArrayTables(GaussMsDataModelDTO dataModelBaseDTO, GaussMsDataModel dataModelBase) {
        CopyOnWriteArrayList<GaussDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<GaussDataModelBase>(dataModelBase.getSlaveTables());
        for (GaussDataModelBase slaveArrayTable : slaveArrayTables) {
            for (SourcePackageInfo sourcePackageInfo : dataModelBaseDTO.getSourcePackageInfos()) {
                if (!"object".equals(sourcePackageInfo.getDataType()) || !slaveArrayTable.getName().equals(sourcePackageInfo.getObjectEnName())) continue;
                slaveArrayTables.remove(slaveArrayTable);
            }
        }
        return slaveArrayTables;
    }

    private static Map<String, String> getSlaveQueryName(GaussFlowMsDataModel dataModelBase) {
        List<GaussDataModelOperation> operations = dataModelBase.getOperations();
        HashMap<String, String> slaveQueryNameMap = new HashMap<String, String>();
        List<GaussDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        if (ToolUtil.isNotEmpty(slaveTables)) {
            block0: for (GaussDataModelOperation operation : operations) {
                if (!ToolUtil.isNotEmpty((Object)operation) || !"SlaveQuery".equals(operation.getType()) || !ToolUtil.isNotEmpty((Object)operation.getName()) || !ToolUtil.isNotEmpty(operation.getParams()) || !ToolUtil.isNotEmpty((Object)operation.getParams().get("slaveModelId"))) continue;
                String slaveModelId = operation.getParams().get("slaveModelId").toString();
                for (GaussDataModelBase slaveTable : slaveTables) {
                    if (!ToolUtil.isNotEmpty((Object)slaveTable) || !ToolUtil.isNotEmpty((Object)slaveModelId) || !slaveModelId.equals(slaveTable.getId())) continue;
                    slaveQueryNameMap.put(operation.getParams().get("slaveModelId").toString(), operation.getName());
                    continue block0;
                }
            }
        }
        return slaveQueryNameMap;
    }
}

