/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.processor;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.gauss.code.GaussCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussModelFunction;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussRender;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.result.GaussCodeResult;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataModelUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GaussModelProcessor
implements DataModelProcessor<GaussCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(GaussModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"GAUSS", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<GaussCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        GaussBackCtx<GaussDataModelBase, GaussDataModelBaseDTO> backCtx = this.getGaussBackCtx(publishCtx);
        GaussModelProcessor.init(backCtx, dataModelBase);
        GaussModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    private GaussBackCtx<GaussDataModelBase, GaussDataModelBaseDTO> getGaussBackCtx(PublishCtx<GaussCodeResult> publishCtx) {
        GaussBackCtx<GaussDataModelBase, GaussDataModelBaseDTO> backCtx = new GaussBackCtx<GaussDataModelBase, GaussDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        if (publishCtx.getPublishDTO() != null) {
            backCtx.setPublishDTO(publishCtx.getPublishDTO());
        }
        return backCtx;
    }

    public static void init(GaussBackCtx<GaussDataModelBase, GaussDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        GaussModelFunction currentFunction = GaussModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        GaussDataModelBase currentModelBase = GaussDataModelUtil.transfer(dataModelBase);
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, GaussDataModelBaseDTO> useDtoMap = new HashMap<String, GaussDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(GaussBackCtx<GaussDataModelBase, GaussDataModelBaseDTO> backCtx, PublishCtx<GaussCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        GaussModelProcessor.visit(backCtx);
        GaussModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(GaussBackCtx<GaussDataModelBase, GaussDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        GaussDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        GaussDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PageInfoNode pageInfoNode = null;
        if (backCtx.getUseDataModelBase().getIsPublishResource()) {
            pageInfoNode = DataModelUtil.getDataModelNode((String)useDataModelBase.getId());
        }
        for (GaussDataModelOperation operation : useDataModelBase.getOperations()) {
            GaussOperationVisitor<GaussDataModelBase, GaussDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("GAUSS", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            try {
                backCtx.getModelFunction().accept(visitor, backCtx, operation);
            }
            catch (Exception var) {
                logger.error("\u6a21\u578b\uff1a{}\uff0c\u65b9\u6cd5\uff1a{} \u6e32\u67d3\u5931\u8d25\uff0c\u6e32\u67d3\u8def\u5f84\uff1a{}", new Object[]{useDataModelBase.getComment(), operation.getName(), visitor.getClass().getName()});
                throw new LcdpException(var, String.format("\u6a21\u578b%s\u6e32\u67d3\u5931\u8d25\uff0c\u5f02\u5e38\uff1a%s", useDataModelBase.getComment(), var.getMessage()));
            }
            if (!backCtx.getUseDataModelBase().getIsPublishResource() || !ToolUtil.isNotEmpty((Object)pageInfoNode)) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
        useDataModelBase.customOption(backCtx);
    }

    public static void render(GaussBackCtx<GaussDataModelBase, GaussDataModelBaseDTO> backCtx, PublishCtx<GaussCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        GaussRender<GaussDataModelBase, GaussDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<GaussCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(GaussCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
        if (HussarUtils.isNotEmpty((Object)backCtx.getParams())) {
            backCtx.getParams().keySet().forEach(key -> {
                if (ToolUtil.isEmpty((Object)publishCtx.getParams())) {
                    publishCtx.addParams(new HashMap());
                }
                publishCtx.getParams().putIfAbsent(key, backCtx.getParam((String)key));
            });
        }
    }
}

