/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.gaussQueryDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.render.GaussBaseRender;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataModelUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSMASTER_SLAVETotalCalculate")
public class GaussMsTotalCalculateVisitor
implements GaussOperationVisitor<GaussMsDataModel, GaussMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussMsTotalCalculateVisitor.class);
    public static final String OPERATION_NAME = "GAUSSMASTER_SLAVETotalCalculate";

    @Override
    public void visit(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        GaussMsDataModel gaussBaseDataModel = backCtx.getUseDataModelBase();
        String modelId = gaussBaseDataModel.getId();
        GaussMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, gaussBaseDataModel);
        boolean isLogicallyDelete = gaussBaseDataModel.isLogicallyDelete();
        if (isLogicallyDelete) {
            String logicallyFlag = backCtx.getUseDataModelBase().getModelAliasName().get(backCtx.getUseDataModelBase().getMasterTable().getId()) + "." + backCtx.getUseDataModelBase().getDeleteFlag().getSourceFieldName();
            controllerParams.put("logicallyFlag", logicallyFlag);
        }
        this.renderTotalCalculate(backCtx, modelId, dataModelBaseDTO, controllerParams);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/gauss/masterslavebackcode/totalCalculate/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/gauss/masterslavebackcode/totalCalculate/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/gauss/masterslavebackcode/totalCalculate/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/gauss/masterslavebackcode/totalCalculate/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/gauss/masterslavebackcode/totalCalculate/xml.ftl";
        String finalRelation = SqlReturnUtil.renderTotalCalculateRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap(), controllerParams);
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, GaussBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, String modelId, GaussMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (backCtx.getUseDataModelBase().isLogicallyDelete()) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "java.util.Map");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
    }

    private Map<String, Object> initParams(GaussDataModelOperation dataModelOperation, GaussMsDataModelDTO dataModelBaseDTO, GaussMsDataModel gaussBaseDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("isSelectCondition", Boolean.FALSE);
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        boolean isLogicallyDelete = gaussBaseDataModel.isLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            GaussDataModelField logicallyField = gaussBaseDataModel.getDeleteFlag();
            controllerParams.put("logicallyFlag", logicallyField.getSourceFieldName());
            String logicallyFieldName = logicallyField.getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("getLogicallyFlag", String.valueOf(chars));
            controllerParams.put("deleteFlagName", logicallyField.getSourceFieldName());
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u603b\u8ba1\u6570\u636e");
            } else {
                dataModelOperation.setExegesis("\u603b\u8ba1\u6570\u636e");
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderTotalCalculate(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, String modelId, GaussMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        gaussQueryDTO totalQuery = GaussDataModelUtil.getTotalQueryDto(dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(totalQuery);
        controllerParams.put("QueryObj", totalQuery.getEntityName());
        controllerParams.put("queryObj", totalQuery.getName());
        String importInfo = totalQuery.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private void renderPageVo(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, String modelId, GaussMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        GaussDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

