/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.util;

import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussCustomOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussEnclosure;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussModelFunction;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussRender;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class GaussModelBeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(GaussModelBeanUtil.class);

    public static GaussOperationVisitor<GaussDataModelBase, GaussDataModelBaseDTO> getVisitorBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u65b9\u6cd5\u8bbf\u95ee\u8005\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u65b9\u6cd5\u8bbf\u95ee\u8005\u5931\u8d25");
        }
        return (GaussOperationVisitor)fromObj;
    }

    public static GaussModelFunction getFunctionModelVisitorBean(String functionModelName) throws LcdpException {
        Object fromObj;
        try {
            fromObj = FunctionModelFactory.obtainFunction((String)("GAUSS." + functionModelName)).newInstance();
            if (ObjectUtils.isEmpty(fromObj)) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, fromObj + "\uff1a\u529f\u80fd\u6a21\u578b\u672a\u6ce8\u518c");
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("\u83b7\u53d6\u529f\u80fd\u6a21\u578b\u5931\u8d25", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, functionModelName + "\uff1a\u83b7\u53d6\u529f\u80fd\u6a21\u578b\u5931\u8d25");
        }
        return (GaussModelFunction)fromObj;
    }

    public static GaussRender<GaussDataModelBase, GaussDataModelBaseDTO> getRenderBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (GaussRender)fromObj;
    }

    public static GaussEnclosure<GaussDataModelBase> getEnclosureBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (GaussEnclosure)fromObj;
    }

    public static GaussCustomOperation getCustomOperationBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (GaussCustomOperation)fromObj;
    }
}

