/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.view;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.view.GaussViewDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.view.GaussViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSVIEWTemplatePrint")
public class GaussViewTemplatePrintVisitor
implements GaussOperationVisitor<GaussViewDataModel, GaussViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussViewTemplatePrintVisitor.class);
    private static final String templatePrintDTO = "com.jxdinfo.hussar.common.formDesign.TemplatePrintDTO";
    private static final String templatePrintService = "com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService";
    public static final String OPERATION_NAME = "GAUSSVIEWTemplatePrint";

    @Override
    public void visit(GaussBackCtx<GaussViewDataModel, GaussViewDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        GaussViewDataModel useDataModelBase = backCtx.getUseDataModelBase();
        GaussViewDataModelDTO dataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelViewDTO);
        String controllerPath = "template/gauss/masterslavebackcode/templatePrint/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelViewDTO.getServiceName());
        String servicePath = "template/gauss/masterslavebackcode/templatePrint/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/gauss/masterslavebackcode/templatePrint/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, "ISysTemplatePrintInfoService");
        this.renderImport(backCtx, modelId, dataModelViewDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelViewDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(GaussBackCtx<GaussViewDataModel, GaussViewDataModelDTO> backCtx, String modelId, GaussViewDataModelDTO dataModelViewDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelViewDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelViewDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, templatePrintDTO);
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, templatePrintDTO);
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, templatePrintDTO);
        backCtx.addServiceImplImport(modelId, templatePrintService);
        if (ToolUtil.isNotEmpty(dataModelViewDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
    }

    private Map<String, Object> initParams(GaussDataModelOperation dataModelOperation, GaussViewDataModelDTO dataModelViewDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelViewDTO);
        controllerParams.put("returnValue", dataModelViewDTO.getEntityName());
        controllerParams.put("url", dataModelViewDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelViewDTO.getComment() + "\u6a21\u677f\u6253\u5370");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

