/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.masterslave;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSMASTER_SLAVEAsyncVerify")
public class GaussMsAsyncVerifyVisitor
implements GaussOperationVisitor<GaussMsDataModel, GaussMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussMsAsyncVerifyVisitor.class);
    public static final String OPERATION_NAME = "GAUSSMASTER_SLAVEAsyncVerify";

    @Override
    public void visit(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        GaussMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = backCtx.getUseDataModelBase().getId();
        GaussMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        controllerParams.put("name", dataModelOperation.getName());
        if (ToolUtil.isNotEmpty((Object)dataModelOperation.getExegesis())) {
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        } else {
            controllerParams.put("exegesis", dataModelBaseDTO.getComment() + "\u5f02\u6b65\u6821\u9a8c");
        }
        controllerParams.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        controllerParams.put("table", table);
        controllerParams.put("dataModelBaseDTO", dataModelBaseDTO);
        String controllerPath = "template/gauss/masterslavebackcode/asyncverify/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/gauss/masterslavebackcode/asyncverify/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/gauss/masterslavebackcode/asyncverify/service_impl.ftl";
        ArrayList<JSONObject> columnList = new ArrayList<JSONObject>();
        ArrayList<GaussBaseDataModel> allModel = new ArrayList<GaussBaseDataModel>();
        String masterTableId = useDataModelBase.getMasterTable().getId();
        allModel.add((GaussBaseDataModel)useDataModelBase.getMasterTable());
        List<GaussDataModelBase> slaveTables = useDataModelBase.getSlaveTables();
        for (GaussRelationshipBase relationship : useDataModelBase.getRelationships()) {
            if (!"association".equals(relationship.getRelateModelType())) continue;
            for (GaussDataModelBase slaveTable : slaveTables) {
                if (!slaveTable.getId().equals(relationship.getSlaveTableId())) continue;
                allModel.add((GaussBaseDataModel)slaveTable);
            }
        }
        for (GaussBaseDataModel gaussDataModelBase : allModel) {
            GaussDataModelBaseDTO gaussDataModelDTO = dataModelBaseDTO.getDataModelDtoMap().get(gaussDataModelBase.getId());
            boolean isMasterTable = gaussDataModelBase.getId().equals(masterTableId);
            List<GaussDataModelFieldDto> modelDtoFields = gaussDataModelDTO.getFields();
            String getPrimaryMethod = "";
            if (isMasterTable) {
                for (GaussDataModelFieldDto field : modelDtoFields) {
                    if (!field.isKeyFlag()) continue;
                    getPrimaryMethod = "Boolean".equals(field.getPropertyType()) ? "is" + field.getCapitalName() : "get" + field.getCapitalName();
                    break;
                }
            } else {
                for (GaussDataModelFieldDto field : modelDtoFields) {
                    if (!"foreign".equals(field.getFill())) continue;
                    getPrimaryMethod = "Boolean".equals(field.getPropertyType()) ? "is" + field.getCapitalName() : "get" + field.getCapitalName();
                    break;
                }
            }
            boolean logicallyFlag = false;
            GaussDataModelField logicallyField = gaussDataModelBase.getDeleteFlag();
            if (ToolUtil.isNotEmpty((Object)((Object)logicallyField))) {
                logicallyFlag = true;
            }
            String flagFieldName = "";
            if (logicallyFlag) {
                for (GaussDataModelFieldDto field : modelDtoFields) {
                    if (!field.getId().equals(logicallyField.getId())) continue;
                    flagFieldName = field.getCapitalName();
                    break;
                }
            }
            String serviceName = gaussDataModelDTO.getServiceEnName();
            List<GaussDataModelField> modelTableFields = gaussDataModelBase.getFields();
            boolean flag = false;
            for (GaussDataModelField modelTableField : modelTableFields) {
                if (!ToolUtil.isNotEmpty((Object)((Object)modelTableField)) || !modelTableField.isChkUnique()) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("columnName", (Object)modelTableField.getName());
                for (GaussDataModelFieldDto field : modelDtoFields) {
                    if (!field.getId().equals(modelTableField.getId())) continue;
                    jsonObject.put("javaType", (Object)field.getPropertyType());
                    break;
                }
                ArrayList<JSONObject> rulesList = new ArrayList<JSONObject>();
                if (modelTableField.isChkUnique()) {
                    flag = true;
                    JSONObject obj = new JSONObject();
                    obj.put("type", (Object)"unique");
                    obj.put("sourceFieldName", (Object)modelTableField.getSourceFieldName());
                    obj.put("errorMsg", (Object)(modelTableField.getName() + "\u5217\u552f\u4e00\u503c\u6821\u9a8c\u672a\u901a\u8fc7"));
                    obj.put("entityName", (Object)gaussDataModelDTO.getEntityName());
                    obj.put("getPrimaryMethod", (Object)getPrimaryMethod);
                    obj.put("serviceName", (Object)serviceName);
                    obj.put("logicallyDelete", (Object)logicallyFlag);
                    obj.put("logicallyFlag", (Object)flagFieldName);
                    Map<String, Object> params = dataModelOperation.getParams();
                    List asyncVerifyParams = (List)params.get("asyncVerifyParams");
                    if (ToolUtil.isNotEmpty((Object)asyncVerifyParams)) {
                        for (JSONObject asyncVerifyParam : asyncVerifyParams) {
                            if (!ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"columnId")) || !asyncVerifyParam.get((Object)"columnId").equals(modelTableField.getId()) || !ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"rules"))) continue;
                            List paramRules = (List)asyncVerifyParam.get((Object)"rules");
                            for (JSONObject paramRule : paramRules) {
                                if (!ToolUtil.isNotEmpty((Object)paramRule) || !ToolUtil.isNotEmpty((Object)paramRule.get((Object)"ruleType")) || !"unique".equals(paramRule.get((Object)"ruleType"))) continue;
                                obj.put("errorMsg", paramRule.get((Object)"errorMsg"));
                            }
                        }
                    }
                    rulesList.add(obj);
                }
                jsonObject.put("rules", rulesList);
                columnList.add(jsonObject);
            }
            if (!flag) continue;
            backCtx.addServiceImplImport(modelId, gaussDataModelDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplImport(modelId, gaussDataModelDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplInversion(modelId, gaussDataModelDTO.getServiceName());
        }
        controllerParams.put("columnList", columnList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5f02\u6b65\u6821\u9a8c");
        backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, String modelId, GaussMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
    }
}

