/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussEnclosure;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.translate.GaussTranslate;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussPublicEnclosure;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSFLOWENCLOSURE")
public class GaussFlowEnclosure
implements GaussEnclosure<GaussFlowDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(GaussFlowEnclosure.class);
    public static final String ENCLOSURE = "GAUSSFLOWENCLOSURE";

    @Override
    public GaussDataModelBaseDTO enclosure(GaussFlowDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        List<GaussDataModelField> dataModelFieldBases;
        GaussFlowDataModelDTO dataModelBaseDTO = new GaussFlowDataModelDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        GaussPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isEmpty(dataModelFieldBases = dataModelBase.getFlowFields())) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new GaussFlowDataModelDTO();
        }
        ArrayList<GaussDataModelFieldDto> tableFields = new ArrayList<GaussDataModelFieldDto>();
        for (GaussDataModelField dataModelFieldBase : dataModelFieldBases) {
            GaussDataModelFieldDto tableField = new GaussDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        List<GaussTranslate> translates = dataModelBase.getTranslate();
        if (ToolUtil.isNotEmpty(translates)) {
            List rightFields = ModelProvideAdapter.adaptor((String)dataModelBase.getId()).getFields(dataModelBase.getId());
            List<Map<String, Object>> translateAnnotations = GaussTranslateUtil.translate(translates, rightFields);
            if (ToolUtil.isNotEmpty(translateAnnotations)) {
                List<GaussDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                block1: for (Map map : translateAnnotations) {
                    if (!ToolUtil.isNotEmpty((Object)map) || !ToolUtil.isNotEmpty(map.get("fieldId"))) continue;
                    for (GaussDataModelFieldDto field : fields) {
                        if (!field.getId().equals(map.get("fieldId").toString())) continue;
                        field.setFieldAnnotation(map.get("fieldAnnotation").toString());
                        continue block1;
                    }
                }
                dataModelBaseDTO.setFields(fields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<GaussDataModelFieldDto> translateShowFields = GaussTranslateUtil.getTranslateShowFields(translates);
            for (GaussDataModelFieldDto gaussDataModelFieldDto : translateShowFields) {
                if (null == gaussDataModelFieldDto.getColumnType() || null == gaussDataModelFieldDto.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(gaussDataModelFieldDto.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
        return dataModelBaseDTO;
    }
}

