/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.gaussQueryDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryCondition;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryConditionField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.sortcondition.GaussSortCondition;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.sortcondition.GaussSortConditionField;
import com.jxdinfo.hussar.formdesign.gauss.function.render.GaussBaseRender;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.constant.GaussConstUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataModelUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSFLOWTableQuery")
public class GaussFlowTableQueryVisitor
implements GaussOperationVisitor<GaussFlowDataModel, GaussFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussFlowTableQueryVisitor.class);
    public static final String OPERATION_NAME = "GAUSSFLOWTableQuery";

    @Override
    public void visit(GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        GaussFlowDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = useDataModelBase.getLogicallyDelete();
        GaussFlowDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, useDataModelDTO, isLogicallyDelete);
        GaussDataModelFieldDto fieldDto = useDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto);
            hasSecurityLevel = true;
        }
        Boolean isPagination = Boolean.valueOf(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = true;
        controllerParams.put("isSortOverall", isSortOverall);
        if (isLogicallyDelete) {
            controllerParams.put("deleteFlag", useDataModelDTO.getFieldCapitalName(useDataModelBase.getDeleteFlag().getName()));
            controllerParams.put("deleteFlagName", useDataModelBase.getDeleteFlag().getSourceFieldName());
        }
        boolean isSelectCondition = this.renderSelectAndSort(backCtx, dataModelOperation, modelId, useDataModelBase, useDataModelDTO, controllerParams, isPagination, isSortOverall);
        this.renderPageVo(backCtx, modelId, useDataModelDTO, controllerParams);
        String controllerPath = "template/gauss/backcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/gauss/backcode/tableQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/gauss/backcode/tableQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        if (isSelectCondition) {
            backCtx.addServiceImplInversion(modelId, useDataModelDTO.getMapperName());
            String mapperPath = "template/gauss/backcode/tableQuery/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String xmlPath = "template/gauss/backcode/tableQuery/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        this.renderImport(backCtx, modelId, useDataModelDTO, isSelectCondition, isPagination, isLogicallyDelete, isSortOverall, hasSecurityLevel);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, GaussBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO> backCtx, String modelId, GaussBaseDataModelDTO dataModelBaseDTO, boolean isSelectCondition, boolean isPagination, boolean isLogicallyDelete, boolean isSortOverall, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            if (isPagination) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            } else {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            }
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isLogicallyDelete) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(GaussDataModelOperation dataModelOperation, GaussFlowDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelectAndSort(GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation, String modelId, GaussFlowDataModel useDataModelBase, GaussFlowDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams, Boolean isPagination, boolean isSortOverall) throws LcdpException {
        GaussSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{sortConditionName}) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(GaussSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<GaussSortConditionField> sortConditionFields;
            if (!isPagination.booleanValue()) {
                sortConditionFields = sortCondition.getFields();
                for (GaussSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            } else {
                sortConditionFields = sortCondition.getFields();
                for (GaussSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            if (isPagination.booleanValue()) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        boolean isSelectCondition = false;
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        GaussQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            GaussQueryConditionField oredElse;
            boolean flag = true;
            if (ToolUtil.isNotEmpty((Object)queryCondition) && ToolUtil.isNotEmpty(queryCondition.getFields()) && ToolUtil.isNotEmpty((Object)(oredElse = (GaussQueryConditionField)queryCondition.getFields().stream().filter(item -> "securityLevel".equals(item.getUsageType())).findFirst().orElse(null)))) {
                flag = false;
            }
            if (flag) {
                GaussDataModelFieldDto fieldDto = (GaussDataModelFieldDto)controllerParams.get("securityLevel");
                GaussQueryConditionField field = new GaussQueryConditionField();
                field.setConnect("and");
                field.setFromModelField(fieldDto.getId());
                field.setQueryAttrName(fieldDto.getPropertyName());
                field.setFromModelId(useDataModelBase.getId());
                field.setType("row");
                field.setSymbol("<=");
                field.setUsageType("securityLevel");
                queryCondition.getFields().add(field);
            }
        }
        ArrayList<String> likeQueryFields = new ArrayList<String>();
        for (GaussQueryConditionField queryConditionField : queryCondition.getFields()) {
            String fromModelField = queryConditionField.getFromModelField();
            List<GaussDataModelField> fields = useDataModelBase.getFields();
            boolean isStringType = true;
            for (GaussDataModelField field : fields) {
                if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                isStringType = false;
                break;
            }
            if (!isStringType) continue;
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        controllerParams.put("likeQueryFields", likeQueryFields);
        if (!Optional.ofNullable(queryCondition).map(GaussQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, useDataModelBase.getDeleteFlag().getName(), useDataModelBase.getId());
        }
        gaussQueryDTO queryDTO = GaussDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            GaussDataModelFieldDto fieldDto = (GaussDataModelFieldDto)controllerParams.get("securityLevel");
            GaussQueryFieldDTO field = new GaussQueryFieldDTO();
            field.setPropertyName(fieldDto.getPropertyName());
            field.setDbColumnType(fieldDto.getColumnType());
            field.setType(fieldDto.getType());
            field.setComment(fieldDto.getComment());
            queryDTO.getQueryFields().add(field);
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = "";
        finalWhereSql = useDataModelBase.getLogicallyDelete() ? QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>(), useDataModelBase.getDeleteFlag().getSourceFieldName()) : QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>());
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        controllerParams.put("whereSql", finalWhereSql);
        isSelectCondition = true;
        controllerParams.put("isSelectCondition", GaussConstUtil.TRUE);
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return isSelectCondition;
    }

    private void renderPageVo(GaussBackCtx<GaussFlowDataModel, GaussFlowDataModelDTO> backCtx, String modelId, GaussBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        GaussDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + GaussDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

