/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.element.task;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussEnclosure;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussRender;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class GaussTaskDataModel
extends GaussBaseDataModel {
    public static final String FUNCTION_TYPE = "TASK";
    public static final String TASK_KEY = "task";
    public static final String BUSINESS_ID = "businessId";
    private GaussBaseDataModel task;
    private List<GaussRelationshipBase> relationships;
    private List<GaussDataModelField> flowFields;

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"GAUSS.TASK", GaussTaskDataModel.class);
    }

    public GaussBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(GaussBaseDataModel task) {
        this.task = task;
    }

    public List<GaussRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<GaussRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<GaussDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<GaussDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    public GaussTaskDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        GaussTaskDataModel gaussTaskDataModel;
        try {
            gaussTaskDataModel = (GaussTaskDataModel)JSONObject.parseObject((String)jsonObject.toString(), GaussTaskDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return gaussTaskDataModel;
    }

    @Override
    public GaussEnclosure<GaussDataModelBase> enclosure() throws LcdpException {
        return GaussModelBeanUtil.getEnclosureBean("GAUSS", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public GaussRender<GaussDataModelBase, GaussDataModelBaseDTO> render() throws LcdpException {
        return GaussModelBeanUtil.getRenderBean("GAUSS", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<GaussDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<GaussDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<GaussDataModelField>> modelContrastTable(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<GaussDataModelField>> contrastVOS = this.task.modelContrastTable(fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable(fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModelIndex(fieldsContrastParam);
    }

    @Override
    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTableIndex(fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<GaussDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId).getDetails().get(0));
        details.add(super.checkTableContrast(modelId).getDetails().get(0));
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "t");
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public void customOption(GaussBackCtx<GaussDataModelBase, GaussDataModelBaseDTO> backCtx) throws LcdpException {
        GaussModelBeanUtil.getCustomOperationBean("GAUSS", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }
}

