/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.util;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlTransUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipBase;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SqlReturnUtil {
    protected static final int DEF_SB_SIZE = 128;

    public static String renderReturn(GaussMsDataModel dataModel, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<GaussDataModelField> dataModelFieldBases = dataModel.getFields();
        for (GaussDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturnNew(GaussDataModelBase dataModel, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<GaussDataModelField> dataModelFieldBases = dataModel.getFields();
        for (GaussDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId)) || "task".equals(aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturn(List<GaussDataModelField> dataModelFieldBases, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        for (GaussDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturn(GaussTaskDataModel dataModel, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<GaussDataModelField> dataModelFieldBases = dataModel.getFields();
        for (GaussDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static void renderAlias(GaussMsDataModel dataModel, Map<String, String> aliasMap, GaussDataModelBaseDTO dataModelBaseDTO) {
        String template = "${alias}.${attrReal}";
        List<GaussDataModelField> dataModelFieldBases = dataModel.getFields();
        List<GaussDataModelFieldDto> dataModelFieldDtos = dataModelBaseDTO.getFields();
        for (GaussDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            for (GaussDataModelFieldDto dataModelFieldDto : dataModelFieldDtos) {
                if (dataModelFieldDto.getName() == null || !dataModelFieldDto.getId().equals(dataModelFieldBase.getId())) continue;
                dataModelFieldDto.setAliasName(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField));
            }
        }
    }

    public static void renderAlias(GaussTaskDataModel dataModel, Map<String, String> aliasMap, GaussTaskDataModelDTO dataModelBaseDTO) {
        String template = "${alias}.${attrReal}";
        List<GaussDataModelField> dataModelFieldBases = dataModel.getFields();
        List<GaussDataModelFieldDto> dataModelFieldDtos = dataModelBaseDTO.getFields();
        for (GaussDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            for (GaussDataModelFieldDto dataModelFieldDto : dataModelFieldDtos) {
                if (dataModelFieldDto.getName() == null || !dataModelFieldDto.getId().equals(dataModelFieldBase.getId())) continue;
                dataModelFieldDto.setAliasName(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField));
            }
        }
    }

    public static String renderRelation(GaussMsDataModel dataModelBase, Map<String, GaussDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<GaussRelationshipBase> relationships = dataModelBase.getRelationships();
        GaussDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = masterTable.getSourceDataModelName();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (GaussRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                GaussDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), dataModelBase, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderRelationNew(GaussMsDataModel dataModelBase, Map<String, GaussDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        String mainModel = dataModelBase.getMasterTable().getSourceDataModelName();
        String mainTemplate = "FROM ${mainModel} ${alias} ";
        relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(dataModelBase.getMasterTable().getId())));
        return relationResult.toString();
    }

    public static String renderRelation(GaussTaskMsDataModel dataModelBase, Map<String, GaussDataModelBase> dataModelBaseMap) {
        String condition;
        String alias;
        String modelRealName;
        GaussDataModelBase slaveTable;
        GaussDataModelBase masterTable;
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<GaussRelationshipBase> relationships = dataModelBase.getRelationships();
        GaussBaseDataModel taskTable = dataModelBase.getTask();
        String taskId = taskTable.getId();
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            String mainModel = ((GaussDataModelBase)taskTable).getSourceDataModelName();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(taskId)));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (GaussRelationshipBase relationship : relationships) {
                if (!relationship.getMasterTableId().equals(dataModelBase.getTask().getId())) continue;
                masterTable = dataModelBaseMap.get(relationship.getMasterTableId());
                slaveTable = dataModelBaseMap.get(dataModelBase.getMasterTable().getId());
                modelRealName = slaveTable.getSourceDataModelName().toUpperCase();
                alias = modelAlias.get(slaveTable.getId());
                condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(taskId), slaveTable);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) break;
                relationResult.append("ON\n").append(condition);
                break;
            }
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (GaussRelationshipBase relationship : relationships) {
                if (relationship.getMasterTableId().equals(dataModelBase.getTask().getId()) || !"association".equals(relationship.getRelateModelType())) continue;
                masterTable = dataModelBaseMap.get(relationship.getMasterTableId());
                slaveTable = dataModelBaseMap.get(relationship.getSlaveTableId());
                modelRealName = slaveTable.getSourceDataModelName().toUpperCase();
                alias = modelAlias.get(relationship.getSlaveTableId());
                condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(masterTable.getId()), slaveTable);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderRelation(GaussTaskDataModel dataModelBase, Map<String, GaussDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<GaussRelationshipBase> relationships = dataModelBase.getRelationships();
        GaussBaseDataModel masterTable = dataModelBase.getTask();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = ((GaussDataModelBase)masterTable).getSourceDataModelName();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (GaussRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                GaussDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderTotalCalculateRelation(GaussMsDataModel dataModelBase, Map<String, GaussDataModelBase> dataModelBaseMap, Map<String, Object> controllerParams) {
        boolean isPaired = false;
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<GaussRelationshipBase> relationships = dataModelBase.getRelationships();
        GaussDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = masterTable.getSourceDataModelName().toUpperCase();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
            controllerParams.put("Alias", modelAlias.get(masterId));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (GaussRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                GaussDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), dataModelBase, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (ToolUtil.isNotEmpty((Object)condition)) {
                    relationResult.append("ON\n").append(condition);
                }
                isPaired = true;
            }
        }
        controllerParams.put("isPaired", isPaired);
        return relationResult.toString();
    }

    private static String renderRelationCondition(List<GaussRelationshipFieldBase> relationshipFieldBases, GaussMsDataModel dataModelBase, String alias, String lastConnect, String mainAlias, GaussDataModelBase slaveModelBase) {
        StringBuilder finalCondition = new StringBuilder(128);
        String slaveModelBaseId = slaveModelBase.getId();
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        for (int i = 0; i < relationshipFieldBases.size(); ++i) {
            GaussRelationshipFieldBase relationshipFieldBase = relationshipFieldBases.get(i);
            String connect = lastConnect;
            if (i == 0) {
                connect = "";
            }
            GaussDataModelBase masterTable = dataModelBase.getMasterTable();
            GaussDataModelBase slaveTables = null;
            List<GaussDataModelBase> slaveTableList = dataModelBase.getSlaveTables();
            String masterTableFieldId = relationshipFieldBase.getMasterTableFieldId();
            String mainField = null;
            String slaveTableFieldId = relationshipFieldBase.getSlaveTableFieldId();
            for (GaussDataModelBase gaussDataModelBase : slaveTableList) {
                if (!HussarUtils.equals((Object)slaveModelBaseId, (Object)gaussDataModelBase.getId())) continue;
                slaveTables = gaussDataModelBase;
                break;
            }
            String dependField = null;
            for (GaussDataModelField field : masterTable.getFields()) {
                if (!HussarUtils.equals((Object)masterTableFieldId, (Object)field.getId())) continue;
                mainField = field.getSourceFieldName();
                break;
            }
            for (GaussDataModelField field : slaveTables.getFields()) {
                if (!HussarUtils.equals((Object)slaveTableFieldId, (Object)field.getId())) continue;
                dependField = field.getSourceFieldName();
                break;
            }
            String string = relationshipFieldBase.getSymbol();
            String connectSym = relationshipFieldBase.getConnect();
            finalCondition.append(conditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", StringUtils.isNotBlank((CharSequence)mainField) ? mainField : "").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)string)).replace("${T_RE}", alias).replace("${RE_FIELD}", StringUtils.isNotBlank((CharSequence)dependField) ? dependField : "").replace("${RE}", mainAlias));
            lastConnect = connectSym;
        }
        return finalCondition.toString();
    }

    private static String renderRelationCondition(List<GaussRelationshipFieldBase> relationshipFieldBases, GaussDataModelBase masterModelBase, String alias, String lastConnect, String mainAlias, GaussDataModelBase slaveModelBase) {
        StringBuilder finalCondition = new StringBuilder(128);
        String slaveModelBaseId = slaveModelBase.getId();
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        for (int i = 0; i < relationshipFieldBases.size(); ++i) {
            GaussRelationshipFieldBase relationshipFieldBase = relationshipFieldBases.get(i);
            String connect = lastConnect;
            if (i == 0) {
                connect = "";
            }
            String masterTableFieldId = relationshipFieldBase.getMasterTableFieldId();
            String mainField = null;
            String slaveTableFieldId = relationshipFieldBase.getSlaveTableFieldId();
            String dependField = null;
            for (GaussDataModelField field : masterModelBase.getFields()) {
                if (!HussarUtils.equals((Object)masterTableFieldId, (Object)field.getId())) continue;
                mainField = field.getSourceFieldName();
                break;
            }
            for (GaussDataModelField field : slaveModelBase.getFields()) {
                if (!HussarUtils.equals((Object)slaveTableFieldId, (Object)field.getId())) continue;
                dependField = field.getSourceFieldName();
                break;
            }
            String symbol = relationshipFieldBase.getSymbol();
            String connectSym = relationshipFieldBase.getConnect();
            finalCondition.append(conditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", StringUtils.isNotBlank((CharSequence)mainField) ? mainField : "").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)symbol)).replace("${T_RE}", alias).replace("${RE_FIELD}", StringUtils.isNotBlank((CharSequence)dependField) ? dependField : "").replace("${RE}", mainAlias));
            lastConnect = connectSym;
        }
        return finalCondition.toString();
    }
}

