/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.provider;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussModelFunction;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.service.GaussWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GaussModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(GaussModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"GAUSS", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            String tenantCodePrefix = Optional.ofNullable(AppContextUtil.getAppInfo()).map(e -> "/" + e.getTenantId()).orElse("");
            return FileUtil.posixPath((String[])new String[]{tenantCodePrefix, apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        GaussModelFunction modelFunction = GaussModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        GaussDataModelBase lrDataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(GaussDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        GaussModelFunction modelFunction = GaussModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        GaussDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (GaussDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        return new GaussWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId, oldVersion, organId, newOrganId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        GaussModelFunction modelFunction = GaussModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        GaussDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> gaussDataModelFields = new ArrayList<DataModelFieldBase>();
        List<GaussDataModelField> fields = dataModelBase.getFields();
        if (ToolUtil.isNotEmpty(fields)) {
            gaussDataModelFields.addAll(fields);
        } else {
            List<GaussDataModelBase> slaveTables = null;
            GaussDataModelBase masterTable = new GaussBaseDataModel();
            if (modelFunction instanceof GaussFlowMsDataModel) {
                slaveTables = ((GaussFlowMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((GaussFlowMsDataModel)dataModelBase).getMasterTable();
            } else if (modelFunction instanceof GaussMsDataModel) {
                slaveTables = ((GaussMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((GaussMsDataModel)dataModelBase).getMasterTable();
            }
            gaussDataModelFields.addAll(masterTable.getFields());
            if (ToolUtil.isNotEmpty(slaveTables)) {
                for (GaussDataModelBase slaveTable : slaveTables) {
                    gaussDataModelFields.addAll(slaveTable.getFields());
                }
            }
        }
        if (modelFunction instanceof GaussTaskDataModel) {
            gaussDataModelFields.addAll(((GaussTaskDataModel)dataModelBase).getTask().getFields());
        } else if (modelFunction instanceof GaussTaskMsDataModel) {
            gaussDataModelFields.addAll(((GaussTaskMsDataModel)dataModelBase).getTask().getFields());
        }
        return gaussDataModelFields;
    }

    public void delete(String modelId) throws LcdpException {
    }

    public Map<String, Map<String, Object>> getSlaveModelInfos(String modelId) throws LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        GaussModelFunction modelFunction = GaussModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        GaussDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return model.getSlaveModelInfo();
    }
}

