/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.gaussQueryDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryCondition;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryConditionField;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.constant.GaussConstUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataModelUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSMASTER_SLAVEDataDisplay")
public class GaussMsDataDisplayVisitor
implements GaussOperationVisitor<GaussMsDataModel, GaussMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussMsDataDisplayVisitor.class);
    public static final String OPERATION_NAME = "GAUSSMASTER_SLAVEDataDisplay";

    @Override
    public void visit(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        GaussMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        String modelId = useDataModelBase.getId();
        GaussMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, String> aliasMap = useDataModelBase.getModelAliasName();
        Map<String, Object> params = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, useDataModelBase, dataModelBaseDTO, params);
        String relateFieldName = String.valueOf(params.get("relateField"));
        String relateField = dataModelBaseDTO.getFieldCapitalName(relateFieldName);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, params);
        String controllertempPath = "template/gauss/masterslavebackcode/datadisplay/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllertempPath, params));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isSelectCondition);
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        logger.debug("\u751f\u6210service\u6267\u884c\u5f00\u59cb");
        String servicePath = "template/gauss/masterslavebackcode/datadisplay/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, params));
        logger.debug("\u751f\u6210serviceImpl\u6267\u884c\u5f00\u59cb");
        String serviceImplPath = "template/gauss/masterslavebackcode/datadisplay/service_impl.ftl";
        params.put("capitalRelateField", relateField);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, params));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/gauss/masterslavebackcode/datadisplay/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, params));
        String xmlPath = "template/gauss/masterslavebackcode/datadisplay/xml.ftl";
        Map<String, GaussDataModelBase> dataModelBaseMap = dataModelBaseDTO.getDataModelBaseMap();
        String finalReturn = SqlReturnUtil.renderReturn(useDataModelBase, aliasMap);
        params.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(useDataModelBase, dataModelBaseMap);
        params.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, params));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", isSelectCondition ? "postJson" : "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6570\u636e\u5c55\u793a");
        backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderPageVo(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, String modelId, GaussMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        GaussDataModelUtil.addQueryPageMsVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + GaussDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private void renderImport(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, String modelId, GaussMsDataModelDTO dataModelBaseDTO, boolean isSelectCondition) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.support.audit.core.annotations.AuditLog");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "java.util.Arrays");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        } else {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
            backCtx.addControllerImport(modelId, "java.util.Arrays");
            backCtx.addServiceImport(modelId, "java.util.List");
        }
    }

    private Map<String, Object> initParams(GaussDataModelOperation dataModelOperation, GaussDataModelBaseDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> params = dataModelOperation.getParams();
        params.put("table", dataModelBaseDTO);
        params.put("returnValue", dataModelBaseDTO.getEntityName());
        params.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        params.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6570\u636e\u5c55\u793a");
            params.put("exegesis", dataModelOperation.getExegesis());
        }
        return params;
    }

    private boolean renderSelect(GaussBackCtx<GaussMsDataModel, GaussMsDataModelDTO> backCtx, GaussDataModelOperation dataModelOperation, String modelId, GaussMsDataModel useDataModelBase, GaussMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        Map<String, String> aliasMap = useDataModelBase.getModelAliasName();
        String inValuesSql = this.getInValuesSql(useDataModelBase, dataModelOperation, aliasMap, selectConditionName);
        boolean isSelectCondition = false;
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            GaussQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
            ArrayList<String> likeQueryFields = new ArrayList<String>();
            for (GaussQueryConditionField queryConditionField : queryCondition.getFields()) {
                String symbol = queryConditionField.getSymbol();
                if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
                likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
            }
            controllerParams.put("likeQueryFields", likeQueryFields);
            if (Optional.ofNullable(queryCondition).map(GaussQueryCondition::getFields).isPresent() && !queryCondition.getFields().isEmpty()) {
                DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
                String logicallyFlag = "";
                if (isLogicallyDelete) {
                    GaussDataModelField gaussDataModelField = useDataModelBase.getDeleteFlag();
                    QueryConditionUtil.addLogicallyFlag(queryCondition, gaussDataModelField.getName(), useDataModelBase.getMasterTable().getId());
                    logicallyFlag = gaussDataModelField.getSourceFieldName();
                }
                gaussQueryDTO queryDTO = GaussDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
                dataModelBaseDTO.addQueryDto(queryDTO);
                String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), inValuesSql, dataModelBaseDTO, aliasMap, useDataModelBase, logicallyFlag);
                if (useDataModelBase.isLogicallyDelete()) {
                    QueryConditionUtil.deleteLogicallyFlag(queryCondition);
                }
                controllerParams.put("QueryObj", queryDTO.getEntityName());
                controllerParams.put("queryObj", queryDTO.getName());
                controllerParams.put("whereSql", finalWhereSql);
                isSelectCondition = true;
                controllerParams.put("isSelectCondition", GaussConstUtil.TRUE);
                String importInfo = queryDTO.getImportInfo();
                backCtx.addControllerImport(modelId, importInfo);
                backCtx.addServiceImport(modelId, importInfo);
                backCtx.addServiceImplImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            }
        } else {
            controllerParams.put("whereSql", inValuesSql);
        }
        return isSelectCondition;
    }

    private String getInValuesSql(GaussMsDataModel useDataModelBase, GaussDataModelOperation dataModelOperation, Map<String, String> aliasMap, String selectConditionName) {
        GaussDataModelField realFieldBase;
        String template = "<if test=\"inValues != null and inValues.size > 0\">\n ${T_ALIAS}.${REAL_FIELD} in\n    <foreach collection=\"inValues\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>";
        String entityAttr = (String)dataModelOperation.getParams().get("relateField");
        if (ToolUtil.isNotEmpty((Object)entityAttr) && ToolUtil.isNotEmpty((Object)((Object)(realFieldBase = useDataModelBase.getFields().stream().filter(field -> entityAttr.equals(field.getName())).findAny().orElseGet(GaussDataModelField::new))))) {
            String alias = aliasMap.get(realFieldBase.getSourceDataModelId());
            String sourceFieldName = realFieldBase.getSourceFieldName();
            if (useDataModelBase.isLogicallyDelete() && !StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + useDataModelBase.getDeleteFlag().getSourceFieldName();
                template = template + "AND (" + logicallyFlag + " != '1' or " + logicallyFlag + " IS NULL)";
            }
            return template.replace("${T_ALIAS}", alias).replace("${REAL_FIELD}", sourceFieldName);
        }
        return "";
    }
}

