/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.element.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussEnclosure;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussRender;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataModelUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GaussFlowMsDataModel
extends GaussMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(GaussFlowMsDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW_MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<GaussDataModelField> flowFields;

    public List<GaussDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<GaussDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"GAUSS.FLOW_MASTER_SLAVE", GaussFlowMsDataModel.class);
    }

    @Override
    public GaussFlowMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        GaussFlowMsDataModel gaussFlowMsDataModel;
        try {
            ArrayList<GaussDataModelField> fieldList = new ArrayList<GaussDataModelField>();
            gaussFlowMsDataModel = (GaussFlowMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), GaussFlowMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                GaussDataModelBase master = GaussDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(gaussFlowMsDataModel.getName() + "Master");
                gaussFlowMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<GaussDataModelBase> slaveTables = new ArrayList<GaussDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    GaussDataModelBase slaveTable = GaussDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (GaussRelationshipBase relationship : gaussFlowMsDataModel.getRelationships()) {
                    GaussDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(GaussBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    GaussDataModelField gaussDataModelField = new GaussDataModelField();
                    gaussDataModelField.setId(UUID.randomUUID().toString());
                    gaussDataModelField.setName(dataModelBase.getName());
                    gaussDataModelField.setComment(dataModelBase.getComment());
                    gaussDataModelField.setSourceDataModelId(dataModelBase.getId());
                    gaussDataModelField.setDataType("array");
                    fieldList.add(gaussDataModelField);
                }
                gaussFlowMsDataModel.setSlaveTables(slaveTables);
            }
            gaussFlowMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return gaussFlowMsDataModel;
    }

    @Override
    public GaussEnclosure<GaussDataModelBase> enclosure() throws LcdpException {
        return GaussModelBeanUtil.getEnclosureBean("GAUSS", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public GaussRender<GaussDataModelBase, GaussDataModelBaseDTO> render() throws LcdpException {
        return GaussModelBeanUtil.getRenderBean("GAUSS", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<GaussDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<GaussDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<GaussDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTable((FieldsContrastParam<GaussDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<GaussDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return super.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws Exception {
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws Exception {
        return super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

