/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.element.customview;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussEnclosure;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussRender;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryCondition;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryObject;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.sortcondition.GaussSortCondition;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.sortcondition.GaussSortConditionField;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GaussCustomViewModel
extends GaussDataModelBase {
    private static final Logger logger = LoggerFactory.getLogger(GaussDataModelBase.class);
    public static final String FUNCTION_TYPE = "CUSTOM_VIEW";
    private String viewSql;
    public static final Logger LOGGER = LoggerFactory.getLogger(GaussBaseDataModel.class);
    private String sourceDataModelName;
    private List<GaussQueryCondition> queryConditions;
    private List<GaussQueryObject> queryObject;
    private List<GaussSortCondition> sortCondition;
    private List<GaussDataModelField> addFields;
    private List<GaussDataModelField> delFields;
    private List<GaussDataModelField> editFields;

    public String getViewSql() {
        return this.viewSql;
    }

    public void setViewSql(String viewSql) {
        this.viewSql = viewSql;
    }

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"GAUSS.CUSTOM_VIEW", GaussCustomViewModel.class);
    }

    @Override
    public GaussCustomViewModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        GaussCustomViewModel customSqlModel;
        try {
            customSqlModel = (GaussCustomViewModel)JSONObject.parseObject((String)jsonObject.toString(), GaussCustomViewModel.class);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return customSqlModel;
    }

    public GaussEnclosure enclosure() throws LcdpException {
        return null;
    }

    public GaussRender render() throws LcdpException {
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<GaussQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<GaussQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<GaussQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<GaussQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<GaussSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (GaussSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (GaussSortConditionField field : condition.getFields()) {
                    try {
                        Map<String, String> fieldMap = GaussDataModelUtil.transfer(DataModelUtil.getDataModelBase((String)field.getFromModelIdSort())).getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName));
                        String fieldName = fieldMap.get(field.getFromModelFieldIdSort());
                        if (HussarUtils.equals((Object)fieldName, (Object)field.getFromModelFieldSort())) continue;
                        field.setFromModelFieldSort(fieldName);
                    }
                    catch (LcdpException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<GaussSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    public List<GaussDataModelField> getAddFields() {
        return this.addFields;
    }

    public void setAddFields(List<GaussDataModelField> addFields) {
        this.addFields = addFields;
    }

    public List<GaussDataModelField> getDelFields() {
        return this.delFields;
    }

    public void setDelFields(List<GaussDataModelField> delFields) {
        this.delFields = delFields;
    }

    public List<GaussDataModelField> getEditFields() {
        return this.editFields;
    }

    public void setEditFields(List<GaussDataModelField> editFields) {
        this.editFields = editFields;
    }

    @Override
    public GaussQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (GaussQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new GaussQueryCondition();
    }

    @Override
    public GaussSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (GaussSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new GaussSortCondition();
    }
}

