/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.visitor.task.masterslavetask;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.gauss.ctx.GaussBackCtx;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussOperationVisitor;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.flow.GaussFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.GaussMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.masterslave.relationship.GaussRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.gauss.function.element.task.GaussTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.gaussQueryDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.operation.GaussDataModelOperation;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.constant.GaussConstUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.visitor.masterslave.util.GaussMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="GAUSSTASK_MASTER_SLAVEFormSave")
public class GaussMsTaskFormSaveVisitor
implements GaussOperationVisitor<GaussTaskMsDataModel, GaussTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(GaussMsTaskFormSaveVisitor.class);
    public static final String OPERATION_NAME = "GAUSSTASK_MASTER_SLAVEFormSave";

    @Override
    public void visit(GaussBackCtx<GaussTaskMsDataModel, GaussTaskMsDataModelDTO> taskBackCtx, GaussDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        GaussFlowMsDataModelDTO gaussFlowMsDataModelDTO = (GaussFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        GaussFlowMsDataModel dataModelBase = (GaussFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx = new GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(dataModelBase);
        HashMap<String, GaussFlowMsDataModelDTO> map = new HashMap<String, GaussFlowMsDataModelDTO>();
        map.put(modelId, gaussFlowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        GaussMsDataModelDTO gaussMsDataModelDTO = (GaussMsDataModelDTO)backCtx.getUseDataModelDtoMap().get(modelId);
        String url = gaussMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, Object> controllerParams = operation.getParams();
        GaussDataModelFieldDto keyField = gaussMsDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map slaveTablePlusSave = (Map)operation.getParams().get("slaveTablePlusSave");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        boolean plusFlag = false;
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        if (plusFlag) {
            for (GaussRelationshipDTO relationshipDTO : gaussMsDataModelDTO.getRelationshipDtoList()) {
                if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
                slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
            }
            for (GaussDataModelBase modelBase : dataModelBase.getSlaveTables()) {
                isLogicallyDelete.put(modelBase.getId(), ((GaussBaseDataModel)modelBase).getLogicallyDelete());
                GaussDataModelBaseDTO gaussDataModelBaseDTO = gaussMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
                String slaveModelName = modelBase.getName();
                capitalNameList.put(slaveModelName, GaussMasterSlaveUtil.getCapitalName(slaveModelName));
                for (GaussDataModelField gaussDataModelField : modelBase.getFields()) {
                    if (!"delDefFlag".equals(gaussDataModelField.getUsage())) continue;
                    logicallyDelField.put(slaveModelName, gaussDataModelField.getName());
                }
                for (GaussDataModelFieldDto gaussDataModelFieldDto : gaussDataModelBaseDTO.getFields()) {
                    if ("primary".equals(gaussDataModelFieldDto.getFill())) {
                        primaryKeys.put(slaveModelName, gaussDataModelFieldDto.getCapitalName());
                    }
                    if (!"foreign".equals(gaussDataModelFieldDto.getFill())) continue;
                    foreignKeys.put(slaveModelName, gaussDataModelFieldDto.getCapitalName());
                }
            }
            this.addFormPlusSaveDto(dataModelBase, gaussMsDataModelDTO, backCtx, slaveTablePlusSave);
        }
        controllerParams.put("table", gaussMsDataModelDTO);
        controllerParams.put("returnValue", gaussMsDataModelDTO.getEntityName());
        if (plusFlag) {
            controllerParams.put("returnValue", gaussMsDataModelDTO.getEntityName() + "IncrementDTO");
        }
        controllerParams.put("url", url);
        GaussDataModelBaseDTO masterBaseDto = gaussMsDataModelDTO.getDataModelDtoMap().get(dataModelBase.getMasterTable().getId());
        controllerParams.put("masterTable", masterBaseDto);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(masterBaseDto.getComment() + "\u65b0\u589e\u6216\u4fee\u6539");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/gauss/taskbackcode/masterslavetaskbackcode/formsave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, gaussMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, gaussMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, gaussMsDataModelDTO.getServiceName());
        String servicePath = "template/gauss/taskbackcode/masterslavetaskbackcode/formsave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        this.masterSlaveCode(backCtx, controllerParams);
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        if (plusFlag) {
            controllerParams.put("primaryKeys", primaryKeys);
            controllerParams.put("foreignKeys", foreignKeys);
            controllerParams.put("slaveTable", GaussMasterSlaveUtil.ofSlaveParam(dataModelBase, gaussMsDataModelDTO));
            controllerParams.put("isPlusSave", true);
            controllerParams.put("isLogicallyDelete", isLogicallyDelete);
            controllerParams.put("logicallyDelField", logicallyDelField);
            controllerParams.put("capitalNameList", capitalNameList);
        }
        String serviceImplPath = "template/gauss/taskbackcode/masterslavetaskbackcode/formsave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", url, "\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, GaussBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void masterSlaveCode(GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        GaussMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        GaussMsDataModelDTO gaussMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<GaussRelationshipDTO> relationshipDtoList = gaussMsDataModelDTO.getRelationshipDtoList();
        GaussDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, GaussDataModelBaseDTO> dataModelDtoMap = gaussMsDataModelDTO.getDataModelDtoMap();
        GaussDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(mainDataModelDto, gaussMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (GaussRelationshipDTO gaussRelationshipDTO : relationshipDtoList) {
                List<GaussRelationshipFieldDTO> gaussRelationshipFieldDTOS;
                String slaveTableId = gaussRelationshipDTO.getSlaveTableId();
                String relateModelType = gaussRelationshipDTO.getRelateModelType();
                GaussDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(slaveModelDto, gaussMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    gaussRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(gaussRelationshipFieldDTOS = gaussRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private void addFormPlusSaveDto(GaussMsDataModel dataModelBase, GaussMsDataModelDTO dataModelDTO, GaussBackCtx<GaussFlowMsDataModel, GaussFlowMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        gaussQueryDTO queryDTO = new gaussQueryDTO();
        String modelId = dataModelBase.getId();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/gauss/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", GaussMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", dataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(dataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(dataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = dataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        dataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }

    private String renderFillCode(GaussDataModelBaseDTO dataModelBaseDTO, GaussMsDataModelDTO msDataModelDTO, boolean isMs, GaussDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (GaussDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", GaussConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", GaussConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", GaussConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/gauss/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }
}

