/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.gauss.function.element.base;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.IndexInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.CheckTable;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.IndexCorrespond;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussEnclosure;
import com.jxdinfo.hussar.formdesign.gauss.function.GaussRender;
import com.jxdinfo.hussar.formdesign.gauss.function.element.base.GaussBaseConnector;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBase;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.GaussDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.field.GaussEditDataModelField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.index.GaussDataModelIndex;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryCondition;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.querycondition.GaussQueryObject;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.sortcondition.GaussSortCondition;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.sortcondition.GaussSortConditionField;
import com.jxdinfo.hussar.formdesign.gauss.function.modelentity.translate.GaussTranslate;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussDataModelUtil;
import com.jxdinfo.hussar.formdesign.gauss.util.GaussModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.stereotype.Component;

@Component
public class GaussBaseDataModel
extends GaussDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(GaussBaseDataModel.class);
    public static final String FUNCTION_TYPE = "BASE";
    public static final int OK = 1;
    public static final int ERROR = -1;
    public static final int UN = 0;
    private List<GaussTranslate> translate;
    private String sourceDataModelName;
    private List<GaussQueryCondition> queryConditions;
    private List<GaussQueryObject> queryObject;
    private List<GaussSortCondition> sortCondition;
    private List<GaussDataModelField> addFields;
    private List<GaussDataModelField> delFields;
    private List<GaussEditDataModelField> editFields;
    private boolean logicallyDelete;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"GAUSS.BASE", GaussBaseDataModel.class);
    }

    @Override
    public GaussBaseDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        GaussBaseDataModel gaussBaseDataModel;
        try {
            gaussBaseDataModel = (GaussBaseDataModel)JSONObject.parseObject((String)jsonObject.toString(), GaussBaseDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return gaussBaseDataModel;
    }

    @Override
    public GaussEnclosure<GaussDataModelBase> enclosure() throws LcdpException {
        return GaussModelBeanUtil.getEnclosureBean("GAUSS", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public GaussRender<GaussDataModelBase, GaussDataModelBaseDTO> render() throws LcdpException {
        return GaussModelBeanUtil.getRenderBean("GAUSS", FUNCTION_TYPE, "RENDER");
    }

    @Override
    public List<GaussTranslate> getTranslate() {
        return this.translate;
    }

    @Override
    public void setTranslate(List<GaussTranslate> translate) {
        this.translate = translate;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<GaussQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<GaussQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<GaussQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<GaussQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<GaussSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (GaussSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (GaussSortConditionField field : condition.getFields()) {
                    try {
                        Map<String, String> fieldMap = GaussDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)field.getFromModelIdSort())).getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName));
                        String fieldName = fieldMap.get(field.getFromModelFieldIdSort());
                        if (HussarUtils.equals((Object)fieldName, (Object)field.getFromModelFieldSort())) continue;
                        field.setFromModelFieldSort(fieldName);
                    }
                    catch (LcdpException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<GaussSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    public List<GaussDataModelField> getAddFields() {
        return this.addFields;
    }

    public void setAddFields(List<GaussDataModelField> addFields) {
        this.addFields = addFields;
    }

    public List<GaussDataModelField> getDelFields() {
        return this.delFields;
    }

    public void setDelFields(List<GaussDataModelField> delFields) {
        this.delFields = delFields;
    }

    public List<GaussEditDataModelField> getEditFields() {
        return this.editFields;
    }

    public void setEditFields(List<GaussEditDataModelField> editFields) {
        this.editFields = editFields;
    }

    public boolean getLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public GaussQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (GaussQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new GaussQueryCondition();
    }

    @Override
    public GaussSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (GaussSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new GaussSortCondition();
    }

    public Optional<TableInfo> findTable(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional infoOptional;
        TableInfo table = null;
        boolean findCurrentTable = false;
        List tableCorresponds = fieldsContrastParam.getTableCorresponds();
        if (tableCorresponds != null) {
            for (TableCorrespond tableCorrespond : tableCorresponds) {
                if (!this.getId().equals(tableCorrespond.getModelId())) continue;
                String changeName = tableCorrespond.getTableName();
                Optional infoOptional2 = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)changeName);
                findCurrentTable = infoOptional2.isPresent();
                if (!findCurrentTable) break;
                table = (TableInfo)infoOptional2.get();
                break;
            }
        }
        if (!findCurrentTable && (findCurrentTable = (infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName)).isPresent())) {
            table = (TableInfo)infoOptional.get();
        }
        return Optional.ofNullable(table);
    }

    @Override
    public List<ContrastVO<GaussDataModelField>> tableContrastModel(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<GaussDataModelField> contrast = new ContrastVO<GaussDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = GaussDataModelUtil.contrastWith(table.getFields(), this.getFields());
            contrast.setTableFields(GaussDataModelUtil.tabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<GaussDataModelField>> contrastVOS = new ArrayList<ContrastVO<GaussDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<GaussDataModelField>> modelContrastTable(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<GaussDataModelField> contrast = new ContrastVO<GaussDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = GaussDataModelUtil.mcontrastWith(table.getFields(), this.getFields());
            contrast.setTableFields(GaussDataModelUtil.tabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<GaussDataModelField>> contrastVOS = new ArrayList<ContrastVO<GaussDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable((FieldsContrastParam<GaussDataModelField>)fieldsContrastParam);
        ContrastIndexVO<GaussDataModelIndex> contrast = new ContrastIndexVO<GaussDataModelIndex>();
        TableCorrespond info = new TableCorrespond();
        if (HussarUtils.isNotEmpty((Object)fieldsContrastParam.getTableCorresponds())) {
            info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(0);
        }
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = GaussDataModelUtil.contrastIndexWith(table.getIndexs(), this.getIndexList(), info);
            contrast.setTableIndexs(GaussDataModelUtil.tabTransmodelIndex(table.getIndexs()));
        }
        contrast.setModelId(this.getId());
        ArrayList<ContrastIndexVO> contrastIndexVOS = new ArrayList<ContrastIndexVO>();
        contrastIndexVOS.add(contrast);
        return contrastIndexVOS;
    }

    @Override
    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable((FieldsContrastParam<GaussDataModelField>)fieldsContrastParam);
        ContrastIndexVO<GaussDataModelIndex> contrast = new ContrastIndexVO<GaussDataModelIndex>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = GaussDataModelUtil.mcontrastIndexWith(table.getIndexs(), this.getIndexList());
            contrast.setTableIndexs(GaussDataModelUtil.tabTransmodelIndex(table.getIndexs()));
        }
        contrast.setModelId(this.getId());
        ArrayList<ContrastIndexVO> contrastIndexVOS = new ArrayList<ContrastIndexVO>();
        contrastIndexVOS.add(contrast);
        return contrastIndexVOS;
    }

    @Override
    public List<ContrastVO<GaussDataModelField>> findTableContrast() throws IOException, LcdpException {
        ArrayList<ContrastVO<GaussDataModelField>> contrastVOS = new ArrayList<ContrastVO<GaussDataModelField>>();
        ContrastVO contrast = new ContrastVO();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName);
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        contrast.setModelId(this.getId());
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO contrastVOS = new PublishCheckVO();
        contrastVOS.setModelId(modelId);
        ArrayList<CheckTable> contrast = new ArrayList<CheckTable>();
        CheckTable info = new CheckTable();
        long start = System.currentTimeMillis();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName);
        if (!infoOptional.isPresent()) {
            info.setModelId(modelId);
            info.setState(Integer.valueOf(0));
            contrast.add(info);
            contrastVOS.setDetails(contrast);
            return contrastVOS;
        }
        TableInfo table = (TableInfo)infoOptional.get();
        LOGGER.info("\u53d1\u5e03\u65f6\u6821\u9a8c\u67e5\u8be2\u5355\u8868{}\u8017\u65f6\uff1a{}", (Object)this.sourceDataModelName, (Object)ToolUtil.logTime((long)start));
        if (ToolUtil.isNotEmpty((Object)table)) {
            ContrastVO<GaussDataModelField> model = GaussDataModelUtil.pushContrastWith(table.getFields(), this.getFields());
            if (model.getAddFields().size() == 0 && model.getDelFields().size() == 0 && model.getModifyFields().size() == 0) {
                info.setState(Integer.valueOf(2));
            } else {
                info.setState(Integer.valueOf(1));
            }
        } else {
            info.setState(Integer.valueOf(0));
        }
        info.setModelId(this.getId());
        contrast.add(info);
        contrastVOS.setDetails(contrast);
        return contrastVOS;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws Exception {
        int x;
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return false;
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        IndexCorrespond indexInfo = new IndexCorrespond();
        boolean findTable = false;
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        if (fieldsContrastParam.getIndexCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getIndexCorresponds().size(); ++x) {
                if (!this.getId().equals(((IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x)).getModelId())) continue;
                indexInfo = (IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        if (!findTable) {
            return true;
        }
        boolean findCurrentTable = info.getTableName() != null && ToolUtil.isNotEmpty((Object)info.getTableName()) ? DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)info.getTableName()).isPresent() : DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName).isPresent();
        if (!findCurrentTable) {
            this.creatTabs(datasourceLr);
        } else {
            this.editTabs(datasourceLr, (TableCorrespond<GaussDataModelField>)info, indexInfo);
        }
        return true;
    }

    public int creatTabs(SysDataSource datasourceLr) {
        MetadataParam metadataParam = new MetadataParam();
        TableInfoDto tableInfoDto = GaussBaseConnector.tableInfoInCreate(datasourceLr, this);
        metadataParam.setTableInfo(tableInfoDto);
        metadataParam.setColumnInfo(GaussBaseConnector.transferColumn(this.getFields(), ""));
        metadataParam.setIndexInfo(GaussBaseConnector.transferIndex(this.getIndexList()));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.createTable(metadataParam);
        ddlService.updateIndex(metadataParam);
        return 1;
    }

    public int editTabs(SysDataSource datasourceLr, TableCorrespond<GaussDataModelField> info, IndexCorrespond indexInfo) throws Exception {
        MetadataParam paramData = new MetadataParam();
        TableInfoDto tableInfoDto = GaussBaseConnector.tableInfoInEdit(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSONArray.parseArray((String)info.getDelFields(), GaussDataModelField.class);
        if (!HussarUtils.isEmpty((Object)delFields)) {
            for (int y = 0; y < delFields.size(); ++y) {
                ColumnInfoDto del = new ColumnInfoDto();
                del.setColumnName(((GaussDataModelField)((Object)delFields.get(y))).getSourceFieldName());
                deletedCols.add(del);
            }
        }
        paramData.setDeletedCols(deletedCols);
        List addFields = JSONArray.parseArray((String)info.getAddFields(), GaussDataModelField.class);
        List editFields = JSONArray.parseArray((String)info.getModifyFields(), GaussEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        String oldTableName = !HussarUtils.isEmpty((Object)info.getOldTableName()) ? info.getOldTableName() : indexInfo.getOldTableName();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)oldTableName);
        if (!infoOptional.isPresent()) {
            return 0;
        }
        TableInfo table = (TableInfo)infoOptional.get();
        List<ColumnInfoDto> oldColumn = this.transform(GaussDataModelUtil.tabTransmodel(table.getFields()));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.editTable(paramData, oldColumn, info.getOldTableName());
        if (HussarUtils.isNotEmpty((Object)indexInfo)) {
            List addIndex = JSONArray.parseArray((String)indexInfo.getAddIndexs(), GaussDataModelIndex.class);
            List delIndex = JSONArray.parseArray((String)indexInfo.getDelIndexs(), GaussDataModelIndex.class);
            if (HussarUtils.isNotEmpty((Object)delFields) && HussarUtils.isNotEmpty((Object)delIndex)) {
                Iterator iterator = delIndex.iterator();
                block4: while (iterator.hasNext()) {
                    GaussDataModelIndex index = (GaussDataModelIndex)((Object)iterator.next());
                    for (GaussDataModelField delField : delFields) {
                        if (!delField.getSourceFieldName().equals(index.getColumnName())) continue;
                        iterator.remove();
                        continue block4;
                    }
                }
            }
            if (addIndex != null) {
                List<IndexInfoDto> addIndexDtos = this.transformIndexDto(addIndex);
                paramData.setIndexInfo(addIndexDtos);
            }
            if (delIndex != null) {
                List<IndexInfoDto> delIndexDtos = this.transformIndexDto(delIndex);
                paramData.setDeleteIdxs(delIndexDtos);
            }
            try {
                ddlService.updateIndex(paramData);
            }
            catch (DuplicateKeyException e) {
                throw new DuplicateKeyException(e.getCause().getMessage());
            }
            catch (BadSqlGrammarException e) {
                throw new SQLSyntaxErrorException(e.getCause().getMessage());
            }
        }
        return 1;
    }

    public List<ColumnInfoDto> transformDto(List<GaussDataModelField> getFields, String state) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        if (HussarUtils.isNotEmpty(getFields)) {
            for (int i = 0; i < getFields.size(); ++i) {
                Optional engineColumnType;
                ColumnInfoDto columnInfo = new ColumnInfoDto();
                columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
                columnInfo.setColumnComment(getFields.get(i).getComment());
                columnInfo.setColumnAlias(getFields.get(i).getName());
                columnInfo.setRequired("0");
                if ("primary".equals(getFields.get(i).getUsage())) {
                    columnInfo.setPk("1");
                    columnInfo.setRequired("1");
                    columnInfo.setPrimarys("1");
                } else {
                    columnInfo.setPk("0");
                }
                if (getFields.get(i).getDataIsEmpty()) {
                    columnInfo.setRequired("1");
                }
                columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
                columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
                columnInfo.setDataType(getFields.get(i).getSourceDataType());
                columnInfo.setDataIsEmpty(Integer.valueOf(getFields.get(i).getDataIsEmpty() ? 1 : 0));
                if (!"all".equals(state)) {
                    columnInfo.setOperation(state);
                }
                if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)getFields.get(i).getDataType())).isPresent()) {
                    columnInfo.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                    columnInfo.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
                }
                columnInfos.add(columnInfo);
            }
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transformEdit(List<GaussEditDataModelField> getFields, String state) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        if (HussarUtils.isNotEmpty(getFields)) {
            for (int i = 0; i < getFields.size(); ++i) {
                Optional engineColumnType;
                ColumnInfoDto columnInfo = new ColumnInfoDto();
                columnInfo.setColumnName(getFields.get(i).getNewField().getSourceFieldName());
                columnInfo.setColumnComment(getFields.get(i).getNewField().getComment());
                columnInfo.setColumnAlias(getFields.get(i).getNewField().getName());
                columnInfo.setRequired("0");
                if ("primary".equals(getFields.get(i).getNewField().getUsage())) {
                    columnInfo.setPk("1");
                    columnInfo.setRequired("1");
                    columnInfo.setPrimarys("1");
                } else {
                    columnInfo.setPk("0");
                }
                if (getFields.get(i).getNewField().getDataIsEmpty()) {
                    columnInfo.setRequired("1");
                }
                columnInfo.setPurpose(getFields.get(i).getNewField().getUsage());
                columnInfo.setDataLength(Long.valueOf(getFields.get(i).getNewField().getDataLength()));
                columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getNewField().getDataDot()));
                columnInfo.setDataType(getFields.get(i).getNewField().getSourceDataType());
                columnInfo.setOldColumnName(getFields.get(i).getOldField().getSourceFieldName());
                columnInfo.setDataIsEmpty(Integer.valueOf(getFields.get(i).getNewField().getDataIsEmpty() ? 1 : 0));
                if (!"all".equals(state)) {
                    columnInfo.setOperation(state);
                }
                if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)getFields.get(i).getNewField().getDataType())).isPresent()) {
                    columnInfo.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                    columnInfo.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
                }
                columnInfos.add(columnInfo);
            }
        }
        return columnInfos;
    }

    public List<IndexInfoDto> transformIndexDto(List<GaussDataModelIndex> getIdxs) {
        ArrayList<IndexInfoDto> indexInfos = new ArrayList<IndexInfoDto>();
        if (HussarUtils.isEmpty(getIdxs)) {
            return indexInfos;
        }
        getIdxs.forEach(getIndex -> {
            IndexInfoDto indexInfo = new IndexInfoDto();
            indexInfo.setIndexColumn(getIndex.getColumnName());
            indexInfo.setIndexComment(getIndex.getRemark());
            indexInfo.setUnique(getIndex.isChkUnique());
            indexInfo.setIndexName(getIndex.getIndexName());
            indexInfo.setIndexType(getIndex.getIndexType());
            indexInfos.add(indexInfo);
        });
        return indexInfos;
    }

    public List<ColumnInfoDto> transform(List<GaussDataModelField> getFields) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        if (HussarUtils.isNotEmpty(getFields)) {
            for (int i = 0; i < getFields.size(); ++i) {
                ColumnInfoDto columnInfo = new ColumnInfoDto();
                columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
                columnInfo.setColumnComment(getFields.get(i).getComment());
                columnInfo.setRequired("0");
                if ("primary".equals(getFields.get(i).getUsage())) {
                    columnInfo.setPk("1");
                    columnInfo.setRequired("1");
                } else {
                    columnInfo.setPk("0");
                }
                if (getFields.get(i).getDataIsEmpty()) {
                    columnInfo.setRequired("1");
                }
                columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
                columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
                columnInfo.setDataType(getFields.get(i).getSourceDataType());
                columnInfos.add(columnInfo);
            }
        }
        return columnInfos;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<GaussDataModelField> fieldsContrastParam) throws Exception {
        int x;
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return "";
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        datasourceLr.setDbName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        IndexCorrespond indexInfo = new IndexCorrespond();
        boolean findTable = false;
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        if (fieldsContrastParam.getIndexCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getIndexCorresponds().size(); ++x) {
                if (!this.getId().equals(((IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x)).getModelId())) continue;
                indexInfo = (IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        boolean isCopy = true;
        if (!findTable) {
            isCopy = false;
        } else if (info.getTableName() == null || "".equals(info.getTableName())) {
            if (!("[]".equals(info.getAddFields()) && "[]".equals(info.getDelFields()) && "[]".equals(info.getModifyFields()))) {
                isCopy = true;
            } else if ("[]".equals(indexInfo.getAddIndexs()) && "[]".equals(indexInfo.getDelIndexs())) {
                boolean findCurrentTable = info.getTableName() != null && ToolUtil.isNotEmpty((Object)info.getTableName()) || indexInfo.getTableName() != null && ToolUtil.isNotEmpty((Object)indexInfo.getTableName()) ? DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)info.getTableName()).isPresent() : DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName).isPresent();
                isCopy = !findCurrentTable;
            }
        }
        String sql = "";
        if (isCopy) {
            sql = this.doCopy(datasourceLr, (TableCorrespond<GaussDataModelField>)info, indexInfo);
        }
        return sql;
    }

    private String doCopy(SysDataSource datasourceLr, TableCorrespond<GaussDataModelField> info, IndexCorrespond indexInfo) throws Exception {
        MetadataParam paramData = new MetadataParam();
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSONArray.parseArray((String)info.getDelFields(), GaussDataModelField.class);
        if (HussarUtils.isNotEmpty((Object)delFields)) {
            for (int y = 0; y < delFields.size(); ++y) {
                ColumnInfoDto del = new ColumnInfoDto();
                del.setColumnName(((GaussDataModelField)((Object)delFields.get(y))).getSourceFieldName());
                deletedCols.add(del);
            }
        }
        paramData.setDeletedCols(deletedCols);
        List delIndexs = JSONArray.parseArray((String)indexInfo.getDelIndexs(), GaussDataModelIndex.class);
        List<IndexInfoDto> deletedIdxs = this.transformIndexDto(delIndexs);
        paramData.setDeleteIdxs(deletedIdxs);
        List addFields = JSONArray.parseArray((String)info.getAddFields(), GaussDataModelField.class);
        List editFields = JSONArray.parseArray((String)info.getModifyFields(), GaussEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        String oldTableName = !HussarUtils.isEmpty((Object)info.getOldTableName()) ? info.getOldTableName() : indexInfo.getOldTableName();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)oldTableName);
        List addIndexs = JSONArray.parseArray((String)indexInfo.getAddIndexs(), GaussDataModelIndex.class);
        List<IndexInfoDto> addIdxs = !infoOptional.isPresent() ? this.transformIndexDto(this.getIndexList()) : this.transformIndexDto(addIndexs);
        paramData.setIndexInfo(addIdxs);
        TableInfo table = infoOptional.orElseGet(TableInfo::new);
        ArrayList<ColumnInfoDto> oldColumn = new ArrayList();
        TableInfoDto tableInfoDto = GaussBaseConnector.tableInfoInCreate(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        if (table.getFields() != null) {
            oldColumn = this.transform(GaussDataModelUtil.tabTransmodel(table.getFields()));
            if (StringUtil.isNotEmpty((Object)tableInfoDto.getTableDec()) && tableInfoDto.getTableDec().equals(table.getComment())) {
                tableInfoDto.setTableDec(null);
            }
        } else {
            paramData.setColumnInfo(this.transformDto(this.getFields(), "all"));
        }
        return this.getDdlSql(paramData, oldColumn, info.getOldTableName());
    }

    public GaussDataModelField getDeleteFlag() {
        return this.getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public GaussDataModelField getPrimaryKey() {
        return this.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }

    private String getDdlSql(MetadataParam paramData, List<ColumnInfoDto> oldColumn, String oldTableName) throws Exception {
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        StringBuilder ddlSql = new StringBuilder();
        if (paramData.getDeleteIdxs() != null) {
            List temp = paramData.getIndexInfo();
            paramData.setIndexInfo(null);
            ddlSql.append(ddlService.getIndexDdlSql(paramData));
            paramData.setDeleteIdxs(null);
            paramData.setIndexInfo(temp);
        }
        ddlSql.append(ddlService.getDdlSql(paramData, oldColumn, oldTableName)).append(ddlService.getIndexDdlSql(paramData));
        return ddlSql.toString();
    }
}

