/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.util;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetModelFunction;
import com.jxdinfo.hussar.formdesign.featuremodel.function.constant.DataSetSqlConnectEnum;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationDataSetParam;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationQueryCondition;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.customsql.CustomSqlDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.customsql.CustomSqlDataSetParam;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetBaseDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetParameterValue;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetBaseDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetQueryDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSetModelUtil {
    public static final String PAGE_VO = "PageVO";

    public static DataSetBaseDataModel transfer(DataModelBase dataModelBase) throws LcdpException {
        DataSetModelFunction modelFunction = DataSetModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        return modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)dataModelBase.getId()));
    }

    public static DataSetQueryDTO getFilterDto(DataSetBaseDTO dataModelDTO, CorrelationDataModel dataModelBase) {
        List<CorrelationQueryCondition> query;
        DataSetQueryDTO queryDto = new DataSetQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        CorrelationDataSetParam dataSetParam = dataModelBase.getDataSetParam();
        if (ToolUtil.isNotEmpty((Object)dataSetParam) && ToolUtil.isNotEmpty(query = dataSetParam.getQuery())) {
            ArrayList<DataSetQueryFieldDTO> queryFields = new ArrayList<DataSetQueryFieldDTO>();
            ArrayList tempParamName = new ArrayList();
            DataSetModelUtil.renderQueryFields(queryFields, query);
            dataModelDTO.setQueryField(queryFields);
            queryDto.setQueryFields(queryFields);
        }
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setFtlPath("template/correlationcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("queryDto", queryDto);
        params.put("table", table);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static DataSetQueryDTO getCustomFilterDto(DataSetBaseDTO dataModelDTO, CustomSqlDataModel dataModelBase) {
        List<DataSetParameterValue> parameterValues;
        DataSetQueryDTO queryDto = new DataSetQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        CustomSqlDataSetParam dataSetParam = dataModelBase.getDataSetParam();
        if (ToolUtil.isNotEmpty((Object)dataSetParam) && ToolUtil.isNotEmpty(parameterValues = dataSetParam.getParameterValues())) {
            queryDto.setQueryFields(dataModelDTO.getQueryField());
        }
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setFtlPath("template/correlationcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("queryDto", queryDto);
        params.put("table", table);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    private static void renderQueryFields(List<DataSetQueryFieldDTO> queryFields, CustomSqlDataSetParam dataSetParam) {
        if (ToolUtil.isNotEmpty((Object)dataSetParam)) {
            String sql = dataSetParam.getSql();
            List<DataSetParameterValue> parameterValues = dataSetParam.getParameterValues();
            if (ToolUtil.isNotEmpty((Object)sql) && ToolUtil.isNotEmpty(parameterValues)) {
                for (DataSetParameterValue parameterValue : parameterValues) {
                    DataSetQueryFieldDTO queryField = new DataSetQueryFieldDTO();
                    queryField.setPropertyName(parameterValue.getCode());
                    queryField.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)parameterValue.getType()));
                    queryField.setComment(parameterValue.getName());
                    queryFields.add(queryField);
                }
            }
        }
    }

    private static void renderQueryFields(List<DataSetQueryFieldDTO> queryFields, List<CorrelationQueryCondition> query) {
        for (CorrelationQueryCondition queryCondition : query) {
            if (ToolUtil.isNotEmpty((Object)queryCondition) && HussarUtils.equals((Object)ConnectEnum._ROW.getType(), (Object)queryCondition.getType())) {
                if (!"variable".equals(queryCondition.getParamType()) || !ToolUtil.isNotEmpty((Object)queryCondition.getQueryAttrName())) continue;
                DataSetQueryFieldDTO queryField = new DataSetQueryFieldDTO();
                queryField.setPropertyName(queryCondition.getQueryAttrName());
                queryField.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)queryCondition.getParamDataType()));
                queryField.setComment(queryCondition.getValue().toString());
                if (ToolUtil.isNotEmpty(queryFields)) {
                    boolean flag = false;
                    for (DataSetQueryFieldDTO field : queryFields) {
                        if (!HussarUtils.equals((Object)field.getPropertyName(), (Object)queryField.getPropertyName())) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    queryFields.add(queryField);
                    continue;
                }
                queryFields.add(queryField);
                continue;
            }
            if (!ToolUtil.isNotEmpty((Object)queryCondition) || !HussarUtils.equals((Object)ConnectEnum._CHILD.getType(), (Object)queryCondition.getType())) continue;
            DataSetModelUtil.renderQueryFields(queryFields, queryCondition.getChildren());
        }
    }

    public static Map<String, DataSetSqlConnectEnum> getDataSetSqlConnectEnum() {
        Field[] declaredFields;
        HashMap<String, DataSetSqlConnectEnum> enumMap = new HashMap<String, DataSetSqlConnectEnum>();
        Class<DataSetSqlConnectEnum> enumClass = DataSetSqlConnectEnum.class;
        for (Field field : declaredFields = enumClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            try {
                DataSetSqlConnectEnum enumValue = (DataSetSqlConnectEnum)((Object)field.get(null));
                enumMap.put(enumValue.getKey(), enumValue);
            }
            catch (IllegalAccessException e) {
                throw new HussarException((Throwable)e);
            }
        }
        return enumMap;
    }

    public static List<String> replacePlaceholders(String expression) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)}");
        Matcher matcher = pattern.matcher(expression);
        ArrayList<String> columnIdList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholder = matcher.group();
            String id = placeholder.substring(2, placeholder.length() - 1);
            columnIdList.add(id);
        }
        return columnIdList;
    }

    public static String replacePlaceholders(String expression, Map<String, String> map) {
        Pattern pattern = Pattern.compile("\\$\\{(.*?)}");
        Matcher matcher = pattern.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String placeholder = matcher.group();
            String id = placeholder.substring(2, placeholder.length() - 1);
            String value = map.getOrDefault(id, "");
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

