/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.function.visitor.correlation;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ExtensionOperationJudge;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.ctx.DataSetBackCtx;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetOperationVisitor;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationArchiveTable;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationDataSetParam;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationTableField;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.DataSetCorrelationDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetProjectionFieldDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetQueryDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.operation.DataSetDataModelOperation;
import com.jxdinfo.hussar.formdesign.featuremodel.function.render.CorrelationRender;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetDataModelUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DATA_SET.ASSOCIATIONConditionTableQuery")
public class CorrelationConditionTableQueryVisitor
implements DataSetOperationVisitor<CorrelationDataModel, DataSetCorrelationDTO> {
    private static final Logger logger = LoggerFactory.getLogger(CorrelationConditionTableQueryVisitor.class);
    public static final String OPERATION_NAME = "DATA_SET.ASSOCIATIONConditionTableQuery";

    @Override
    public void visit(DataSetBackCtx<CorrelationDataModel, DataSetCorrelationDTO> backCtx, DataSetDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        CorrelationDataModel useDataModelBase = backCtx.getUseDataModelBase();
        DataSetCorrelationDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String type = ExtensionOperationJudge.type(dataModelOperation.getParams());
        if (HussarUtils.equals((Object)ExtensionOperationJudge.REUSED, (Object)type)) {
            this.addApi(backCtx, dataModelOperation, dataModelBaseDTO, "${PREFIX.standardName}");
            return;
        }
        Map<String, Object> renderParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        HashMap<String, Boolean> swaggerRender = new HashMap<String, Boolean>();
        swaggerRender.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        this.renderFilter(backCtx, modelId, dataModelBaseDTO, renderParams);
        boolean isSortOverall = true;
        renderParams.put("isSortOverall", isSortOverall);
        renderParams.put("swaggerRender", swaggerRender);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, renderParams);
        String controllerPath = "template/correlationcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, renderParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/correlationcode/tableQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, renderParams));
        String serviceImplPath = "template/correlationcode/tableQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, renderParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String finalReturn = this.renderReturn(dataModelBaseDTO, useDataModelBase);
        renderParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/correlationcode/tableQuery/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, renderParams));
        String xmlPath = "template/correlationcode/tableQuery/xml.ftl";
        String finalRelation = dataModelBaseDTO.getFinalRelation();
        renderParams.put("relation", finalRelation);
        renderParams.put("where", dataModelBaseDTO.getWhereSql());
        renderParams.put("sort", dataModelBaseDTO.getSortConditionSql());
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, renderParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isSortOverall);
        this.addApi(backCtx, dataModelOperation, dataModelBaseDTO, "${PREFIX.name}");
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void addApi(DataSetBackCtx<CorrelationDataModel, DataSetCorrelationDTO> backCtx, DataSetDataModelOperation dataModelOperation, DataSetCorrelationDTO dataModelBaseDTO, String prefix) throws LcdpException {
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(prefix) + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        String modelId = backCtx.getUseDataModelBase().getId();
        backCtx.addApi(modelId, CorrelationRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private boolean renderFilter(DataSetBackCtx<CorrelationDataModel, DataSetCorrelationDTO> backCtx, String modelId, DataSetCorrelationDTO dataModelBaseDTO, Map<String, Object> renderParams) {
        DataSetQueryDTO queryDTO;
        String queryDtoName = NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelBaseDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition";
        Map<String, DataSetQueryDTO> queryDtoMap = dataModelBaseDTO.getQueryDtoMap();
        if (ToolUtil.isNotEmpty(queryDtoMap)) {
            queryDTO = queryDtoMap.get(queryDtoName);
        } else {
            queryDTO = DataSetModelUtil.getFilterDto(dataModelBaseDTO, backCtx.getUseDataModelBase());
            dataModelBaseDTO.addQueryDto(queryDTO);
        }
        renderParams.put("QueryObj", queryDTO.getEntityName());
        renderParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        return true;
    }

    private Map<String, Object> initParams(DataSetDataModelOperation dataModelOperation, DataSetCorrelationDTO dataModelBaseDTO) {
        Map<String, Object> renderParams = dataModelOperation.getParams();
        renderParams.put("table", dataModelBaseDTO);
        renderParams.put("returnValue", dataModelBaseDTO.getVoName());
        renderParams.put("selectVoName", dataModelBaseDTO.getSelectVoName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            renderParams.put("exegesis", dataModelOperation.getExegesis());
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getSortConditionFields())) {
            renderParams.put("sortConditionFields", dataModelBaseDTO.getSortConditionFields());
            renderParams.put("isSortCondition", true);
        }
        return renderParams;
    }

    private void renderImport(DataSetBackCtx<CorrelationDataModel, DataSetCorrelationDTO> backCtx, String modelId, DataSetCorrelationDTO dataModelBaseDTO, boolean isSortOverall) {
        String selectVoImport;
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.support.audit.core.enums.AuditEventType");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        }
        if (ToolUtil.isNotEmpty((Object)(selectVoImport = dataModelBaseDTO.getImportInfo().get("selectVO")))) {
            backCtx.addServiceImplImport(modelId, selectVoImport);
            backCtx.addMapperImport(modelId, selectVoImport);
        }
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
    }

    private void renderPageVo(DataSetBackCtx<CorrelationDataModel, DataSetCorrelationDTO> backCtx, String modelId, DataSetCorrelationDTO dataModelBaseDTO, Map<String, Object> renderParams) {
        DataSetDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String pageVoEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String pageVoImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + pageVoEntityName;
        renderParams.put("vo", pageVoEntityName);
        backCtx.addControllerImport(modelId, pageVoImportPath);
        backCtx.addServiceImport(modelId, pageVoImportPath);
        backCtx.addServiceImplImport(modelId, pageVoImportPath);
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("VO"));
        backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("VO"));
    }

    private String renderReturn(DataSetCorrelationDTO dataModelBaseDTO, CorrelationDataModel useDataModelBase) {
        CorrelationDataSetParam dataSetParam = useDataModelBase.getDataSetParam();
        Map<String, String> modelAliasName = useDataModelBase.getFinalMap();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (CorrelationArchiveTable dataSetTables : dataSetParam.getTables()) {
            for (CorrelationTableField dataSetTableField : dataSetTables.getFields()) {
                String fieldName = modelAliasName.get(dataSetTables.getName()) + "." + dataSetTableField.getName();
                fieldMap.put(dataSetTableField.getColumnId(), fieldName);
            }
        }
        String template = "${aliasAndAttrReal} AS ${aliasAndattrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<DataSetProjectionFieldDTO> fields = dataModelBaseDTO.getFields();
        for (DataSetProjectionFieldDTO field : fields) {
            if ("default".equals(field.getFieldType())) {
                finalReturn.append(template.replace("${aliasAndAttrReal}", field.getAliasName()).replace("${aliasAndattrName}", field.getAsAliasName()));
                continue;
            }
            if (!"calc".equals(field.getFieldType())) continue;
            String sql = DataSetModelUtil.replacePlaceholders(field.getExpression(), fieldMap);
            finalReturn.append(template.replace("${aliasAndAttrReal}", sql).replace("${aliasAndattrName}", field.getAsAliasName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }
}

