/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.function.visitor.correlation;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.ctx.DataSetBackCtx;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetOperationVisitor;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.DataSetCorrelationDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetQueryDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.operation.DataSetDataModelOperation;
import com.jxdinfo.hussar.formdesign.featuremodel.function.render.CorrelationRender;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetDataModelUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DATA_SET.ASSOCIATIONTemplatePrint")
public class CorrelationTemplatePrintVisitor
implements DataSetOperationVisitor<CorrelationDataModel, DataSetCorrelationDTO> {
    public static final String OPERATION_NAME = "DATA_SET.ASSOCIATIONTemplatePrint";
    private static final Logger logger = LoggerFactory.getLogger(CorrelationTemplatePrintVisitor.class);
    private static final String datasetTemplatePrintDTO = "com.jxdinfo.hussar.common.formDesign.DatasetTemplatePrintDTO";
    private static final String templatePrintService = "com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService";

    @Override
    public void visit(DataSetBackCtx<CorrelationDataModel, DataSetCorrelationDTO> backCtx, DataSetDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        CorrelationDataModel useDataModelBase = backCtx.getUseDataModelBase();
        DataSetCorrelationDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> renderParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        this.renderFilter(backCtx, modelId, dataModelBaseDTO, renderParams);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, renderParams);
        String controllerPath = "template/correlationcode/templatePrint/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, renderParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/correlationcode/templatePrint/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, renderParams));
        backCtx.addServiceImplInversion(modelId, "ISysTemplatePrintInfoService");
        String serviceImplPath = "template/correlationcode/templatePrint/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, renderParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, CorrelationRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private boolean renderFilter(DataSetBackCtx<CorrelationDataModel, DataSetCorrelationDTO> backCtx, String modelId, DataSetCorrelationDTO dataModelBaseDTO, Map<String, Object> renderParams) {
        DataSetQueryDTO queryDTO;
        String queryDtoName = NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelBaseDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition";
        Map<String, DataSetQueryDTO> queryDtoMap = dataModelBaseDTO.getQueryDtoMap();
        if (ToolUtil.isNotEmpty(queryDtoMap)) {
            queryDTO = queryDtoMap.get(queryDtoName);
        } else {
            queryDTO = DataSetModelUtil.getFilterDto(dataModelBaseDTO, backCtx.getUseDataModelBase());
            dataModelBaseDTO.addQueryDto(queryDTO);
        }
        renderParams.put("QueryObj", queryDTO.getEntityName());
        renderParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        return true;
    }

    private Map<String, Object> initParams(DataSetDataModelOperation dataModelOperation, DataSetCorrelationDTO dataModelBaseDTO) {
        Map<String, Object> renderParams = dataModelOperation.getParams();
        renderParams.put("table", dataModelBaseDTO);
        renderParams.put("returnValue", dataModelBaseDTO.getVoName());
        renderParams.put("selectVoName", dataModelBaseDTO.getSelectVoName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6a21\u677f\u6253\u5370" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u6a21\u677f\u6253\u5370" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            renderParams.put("exegesis", dataModelOperation.getExegesis());
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getSortConditionFields())) {
            renderParams.put("sortConditionFields", dataModelBaseDTO.getSortConditionFields());
            renderParams.put("isSortCondition", true);
        }
        return renderParams;
    }

    private void renderPageVo(DataSetBackCtx<CorrelationDataModel, DataSetCorrelationDTO> backCtx, String modelId, DataSetCorrelationDTO dataModelBaseDTO, Map<String, Object> renderParams) {
        DataSetDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String pageVoEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String pageVoImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + pageVoEntityName;
        renderParams.put("vo", pageVoEntityName);
        backCtx.addControllerImport(modelId, pageVoImportPath);
        backCtx.addServiceImport(modelId, pageVoImportPath);
        backCtx.addServiceImplImport(modelId, pageVoImportPath);
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("VO"));
        backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("VO"));
    }

    private void renderImport(DataSetBackCtx<CorrelationDataModel, DataSetCorrelationDTO> backCtx, String modelId, DataSetCorrelationDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.support.audit.core.enums.AuditEventType");
        backCtx.addControllerImport(modelId, datasetTemplatePrintDTO);
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, datasetTemplatePrintDTO);
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, datasetTemplatePrintDTO);
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, templatePrintService);
        String selectVoImport = dataModelBaseDTO.getImportInfo().get("selectVO");
        if (ToolUtil.isNotEmpty((Object)selectVoImport)) {
            backCtx.addServiceImplImport(modelId, selectVoImport);
            backCtx.addMapperImport(modelId, selectVoImport);
        }
    }
}

