/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.function.enclosure;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FormDesignStringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetEnclosure;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.customsql.CustomSqlDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.customsql.CustomSqlDataSetParam;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.customsql.DataSetCustomSqlDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetParameterValue;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetProjectionField;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetBaseDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetProjectionFieldDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DATA_SET.CUSTOM_SQLENCLOSURE")
public class CustomSqlEnclosure
implements DataSetEnclosure<CustomSqlDataModel> {
    public static final String ENCLOSURE = "DATA_SET.CUSTOM_SQLENCLOSURE";
    protected static final int DEF_SB_SIZE = 128;
    private static final String SUBQUERY_TABLENAME = "T1";
    private static final String RESULT_COLUMN = "<result column=\"${column}\" property=\"${property}\"/>\n";
    private static final String SELECT = "select";
    private static final String SELECTVO = "selectVO";
    @Autowired
    private FormDesignProperties formDesignProperties;

    @Override
    public DataSetBaseDTO enclosure(CustomSqlDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        DataSetCustomSqlDTO dataModelBaseDTO = new DataSetCustomSqlDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        boolean ignoreStrategy = false;
        dataModelBaseDTO.setDataSourceName(dataModelBase.getDataSourceName());
        dataModelBaseDTO.setId(dataModelBase.getId());
        dataModelBaseDTO.setName(dataModelBase.getName());
        dataModelBaseDTO.setComment(dataModelBase.getComment());
        dataModelBaseDTO.setSubqueryTableName(SUBQUERY_TABLENAME);
        dataModelBaseDTO.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelBaseDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setVoName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelBaseDTO.getName() + "VO"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setSelectVoName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelBaseDTO.getName() + SELECT + "VO"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setMapperName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setXmlName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setServiceName(dataModelBaseDTO.getEntityName() + "Service");
        dataModelBaseDTO.setServiceImplName(dataModelBaseDTO.getEntityName() + "ServiceImpl");
        dataModelBaseDTO.setControllerName(dataModelBaseDTO.getEntityName() + "Controller");
        dataModelBaseDTO.setModuleName(dataModelBase.getModelPath().replace("/", "."));
        dataModelBaseDTO.setDictName(dataModelBaseDTO.getEntityName() + NamingStrategy.capitalFirst((String)"dict"));
        dataModelBaseDTO.setTablePath(dataModelBase.getModelPath() + "/" + dataModelBase.getName());
        List<DataSetProjectionField> dataModelFieldBases = dataModelBase.getDataSetParam().getProjection();
        ArrayList<DataSetProjectionFieldDTO> tableFields = new ArrayList<DataSetProjectionFieldDTO>();
        String subqueryTableName = dataModelBaseDTO.getSubqueryTableName();
        StringBuilder finalResult = new StringBuilder(128);
        for (DataSetProjectionField dataModelFieldBase : dataModelFieldBases) {
            DataSetProjectionFieldDTO tableField = new DataSetProjectionFieldDTO();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getField());
            tableField.setId(dataModelFieldBase.getId());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataTypeConversion()));
            tableField.setAliasName(subqueryTableName + "." + dataModelFieldBase.getFieldAlias());
            tableField.setAsAliasName(subqueryTableName + dataModelFieldBase.getFieldAlias());
            finalResult.append(RESULT_COLUMN.replace("${column}", tableField.getAsAliasName().replace("(", "").replace(")", "")).replace("${property}", tableField.getPropertyName()));
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFields(tableFields);
        dataModelBaseDTO.setResultMapContent(finalResult.toString());
        if (dataModelBaseDTO.isUseMybatisPlus()) {
            dataModelBaseDTO.addEntityImport("com.baomidou.mybatisplus.annotation.TableName");
        }
        Map packageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
        dataModelBaseDTO.setPackageInfo(packageInfo);
        Map<String, String> importInfo = CustomSqlEnclosure.getImportInfo(packageInfo, dataModelBaseDTO);
        dataModelBaseDTO.setImportInfo(importInfo);
        ArrayList<DataSetProjectionFieldDTO> voFields = new ArrayList<DataSetProjectionFieldDTO>();
        for (DataSetProjectionFieldDTO tableField : tableFields) {
            voFields.add(tableField.clone());
        }
        VoGeneratorInfo voGeneratorInfo = new VoGeneratorInfo();
        voGeneratorInfo.setFields(voFields);
        dataModelBaseDTO.setVoGeneratorInfo(voGeneratorInfo);
        VoGeneratorInfo selectVo = new VoGeneratorInfo();
        selectVo.setFields(voFields);
        dataModelBaseDTO.setSelectVoGeneratorInfo(selectVo);
        this.renderSubquery(dataModelBaseDTO, dataModelBase);
        dataModelBaseDTO.addQueryDto(DataSetModelUtil.getCustomFilterDto(dataModelBaseDTO, dataModelBase));
        boolean enableSwaggerRender = this.formDesignProperties.isEnableSwaggerRender();
        if (enableSwaggerRender) {
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.Api");
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.ApiOperation");
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.ApiParam");
        }
        dataModelBaseDTO.setEnableSwaggerRender(enableSwaggerRender);
        return dataModelBaseDTO;
    }

    public static Map<String, String> getImportInfo(Map<String, String> packageInfo, DataSetBaseDTO dataModelDto) {
        HashMap<String, String> importInfo = new HashMap<String, String>();
        importInfo.put("Entity", packageInfo.get("Entity") + "." + dataModelDto.getEntityName());
        importInfo.put("Mapper", packageInfo.get("Mapper") + "." + dataModelDto.getMapperName());
        importInfo.put("Xml", packageInfo.get("Xml") + "." + dataModelDto.getXmlName());
        importInfo.put("Service", packageInfo.get("Service") + "." + dataModelDto.getServiceName());
        importInfo.put("ServiceImpl", packageInfo.get("ServiceImpl") + "." + dataModelDto.getServiceImplName());
        importInfo.put("Controller", packageInfo.get("Controller") + "." + dataModelDto.getControllerName());
        importInfo.put("dict", packageInfo.get("dict") + "." + dataModelDto.getDictName());
        importInfo.put("dto", packageInfo.get("dto") + "." + dataModelDto.getEntityName() + "Qo");
        importInfo.put("VO", packageInfo.get("VO") + "." + dataModelDto.getVoName());
        importInfo.put(SELECTVO, packageInfo.get("VO") + "." + dataModelDto.getSelectVoName());
        return importInfo;
    }

    public void renderSubquery(DataSetCustomSqlDTO dataModelBaseDTO, CustomSqlDataModel dataModelBase) {
        CustomSqlDataSetParam dataSetParam = dataModelBase.getDataSetParam();
        String sql = dataSetParam.getSql();
        if (ToolUtil.isNotEmpty(dataSetParam.getParameterValues())) {
            List<DataSetParameterValue> parameterValues = dataSetParam.getParameterValues();
            ArrayList<DataSetQueryFieldDTO> queryFields = new ArrayList<DataSetQueryFieldDTO>();
            for (DataSetParameterValue parameterValue : parameterValues) {
                String paramMarker;
                if (!ToolUtil.isNotEmpty((Object)parameterValue.getCode()) || !this.checkSqlHasParam(sql, paramMarker = parameterValue.getCode())) continue;
                DataSetQueryFieldDTO queryField = new DataSetQueryFieldDTO();
                queryField.setPropertyName(parameterValue.getCode());
                queryField.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)parameterValue.getType()));
                queryField.setComment(parameterValue.getName());
                queryFields.add(queryField);
            }
            dataModelBaseDTO.setQueryField(queryFields);
        }
        dataModelBaseDTO.setSubquery(sql);
    }

    private boolean checkSqlHasParam(String sql, String paramMarker) {
        Pattern pattern = Pattern.compile(FormDesignStringUtil.regTransform((String)paramMarker));
        return pattern.matcher(sql).find();
    }
}

