/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.code.DataSetCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.ctx.DataSetBackCtx;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetRender;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetBaseDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetBaseDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetQueryDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetBackRenderUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetDataSourceUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="DATA_SET.ASSOCIATIONRENDER")
public class CorrelationRender
implements DataSetRender<DataSetBaseDataModel, DataSetBaseDTO> {
    private static final Logger logger = LoggerFactory.getLogger(DataSetRender.class);
    public static final String RENDER = "DATA_SET.ASSOCIATIONRENDER";

    @Override
    public List<DataSetCodeGenerateInfo> renderCode(DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<DataSetCodeGenerateInfo> dataSetCodeGenerateInfos = new ArrayList<DataSetCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        DataSetBaseDTO dataSetBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        dataSetCodeGenerateInfos.add(this.genVoCode(dataSetBaseDTO));
        dataSetCodeGenerateInfos.add(this.genSelectVoCode(dataSetBaseDTO));
        dataSetCodeGenerateInfos.add(this.genControllerCode(dataSetBaseDTO));
        dataSetCodeGenerateInfos.add(this.genServiceCode(dataSetBaseDTO));
        dataSetCodeGenerateInfos.add(this.genServiceImplCode(dataSetBaseDTO));
        dataSetCodeGenerateInfos.add(this.genMapperCode(dataSetBaseDTO));
        dataSetCodeGenerateInfos.add(this.genXmlCode(dataSetBaseDTO));
        dataSetCodeGenerateInfos.add(this.genApiCode(dataSetBaseDTO, baseFile));
        Map<String, DataSetQueryDTO> queryDtoMap = dataSetBaseDTO.getQueryDtoMap();
        if (ToolUtil.isNotEmpty(queryDtoMap)) {
            for (Map.Entry<String, DataSetQueryDTO> queryDTOEntry : queryDtoMap.entrySet()) {
                DataSetQueryDTO queryDTO = queryDTOEntry.getValue();
                DataSetCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, dataSetBaseDTO);
                if (null == queryCodeGenerateInfo) continue;
                dataSetCodeGenerateInfos.add(queryCodeGenerateInfo);
            }
        }
        return dataSetCodeGenerateInfos;
    }

    private DataSetCodeGenerateInfo genVoCode(DataSetBaseDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dataModelBaseDTO.getVoName() + ".java";
        String filePath = "/template/correlationcode/code/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setVoGeneratorInfo(info);
        } else {
            dataModelBaseDTO.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = DataSetBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        DataSetCodeGenerateInfo codeGenerateInfo = new DataSetCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("queryEntity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private DataSetCodeGenerateInfo genSelectVoCode(DataSetBaseDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dataModelBaseDTO.getSelectVoName() + ".java";
        String filePath = "/template/correlationcode/code/selectVo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getSelectVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getSelectVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setSelectVoGeneratorInfo(info);
        } else {
            dataModelBaseDTO.getSelectVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = DataSetBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        DataSetCodeGenerateInfo codeGenerateInfo = new DataSetCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("queryEntity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getSelectVoName() + ".java");
        return codeGenerateInfo;
    }

    private DataSetCodeGenerateInfo genControllerCode(DataSetBaseDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getControllerGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(dataModelDto.getImportInfo().get("Service"));
        dataModelDto.getControllerGenerateInfo().setImports(imports);
        String filePath = "/template/correlationcode/code/controller.ftl";
        String newCode = DataSetBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DataSetCodeGenerateInfo codeGenerateInfo = new DataSetCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private DataSetCodeGenerateInfo genServiceCode(DataSetBaseDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "/template/correlationcode/code/service.ftl";
        String newCode = DataSetBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DataSetCodeGenerateInfo codeGenerateInfo = new DataSetCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private DataSetCodeGenerateInfo genServiceImplCode(DataSetBaseDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "/template/correlationcode/code/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getServiceImplGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(DataSetDataSourceUtil.getDataSourceServiceImpl(dataModelDto.getDataSourceName()));
        imports.add("java.util.List");
        imports.add("java.util.Map");
        imports.add("com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
        imports.add("com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        dataModelDto.getServiceImplGenerateInfo().setImports(imports);
        String newCode = DataSetBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DataSetCodeGenerateInfo codeGenerateInfo = new DataSetCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private DataSetCodeGenerateInfo genMapperCode(DataSetBaseDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "/template/correlationcode/code/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = DataSetBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DataSetCodeGenerateInfo codeGenerateInfo = new DataSetCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private DataSetCodeGenerateInfo genXmlCode(DataSetBaseDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "/template/correlationcode/code/xml.ftl";
        String newCode = DataSetBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DataSetCodeGenerateInfo codeGenerateInfo = new DataSetCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private DataSetCodeGenerateInfo genApiCode(DataSetBaseDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = DataSetBackRenderUtil.renderTemplate(filePath, dataModelDto);
        DataSetCodeGenerateInfo codeGenerateInfo = new DataSetCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private DataSetCodeGenerateInfo dynamicModelCode(DataSetQueryDTO queryDTO, DataSetBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            DataSetCodeGenerateInfo codeGenerateInfo = new DataSetCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }
}

