@Override
public ApiResponse<Map<String, Object>> ${name!}(${QueryObj!} ${QueryObj?uncap_first}){
    try {
        String echarsQuerySql = "${echarsQuerySql?replace('\n', '')?replace('\r', '')}";
        <#--全局排序-->
        Map<String, String[]> parameterMap = new HashMap<>();
        <#if isSortOverall?? && isSortOverall!>
        String orders = "";
        if (${QueryObj?uncap_first}.getOrders() != null) {
            orders = DataModelSqlUtil.getOrderSql(new ${selectVoName}(),${QueryObj?uncap_first}.getOrders());
        }
        </#if>
        if (ToolUtil.isNotEmpty(orders)) {
            echarsQuerySql = echarsQuerySql.replace("${r'${orders}'}", orders);
        }else {
            echarsQuerySql = echarsQuerySql.replace("${r'${orders}'}", "");
        }
        <#--    排序条件，分页排序条件加载page对象中,sortConditionObj排序对象-->
        <#if isSortCondition??>
            List<String> defaultOrderRule = new ArrayList<>();
            String defaultOrder = "";
            <#list sortConditionFields as f>
            <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                defaultOrder += "${f.fromModelFieldSort!}" + <#if f.direction == "ASC">ASC<#else>DESC</#if>;
            </#list>
            defaultOrderRule.add(defaultOrder);
            parameterMap.put(DEFAULT_ORDER_RULE, defaultOrderRule.toArray(new String[0]));
        </#if>
        //指标sql
        String targetsSql = "";
        if (${QueryObj?uncap_first}.getDims() != null && !${QueryObj?uncap_first}.getDims().isEmpty()) {
            List<String> groupRule = new ArrayList<>();
            StringBuilder group = new StringBuilder();
            for (String groupItem : ${QueryObj?uncap_first}.getDims()) {
                group.append(groupItem).append(",");
            }
            groupRule.add(group.toString());
            parameterMap.put(GROUP_RULE, groupRule.toArray(new String[0]));
        }
        if (${QueryObj?uncap_first}.getTargets() != null && !${QueryObj?uncap_first}.getTargets().isEmpty()){
            targetsSql = DataModelSqlUtil.getTargetsSql(new ${selectVoName}(),${QueryObj?uncap_first}.getTargets());
            if (${QueryObj?uncap_first}.getOrders() != null && !${QueryObj?uncap_first}.getOrders().isEmpty()) {
                targetsSql += DataModelSqlUtil.addOrderSelect(new ${selectVoName}(),${QueryObj?uncap_first}.getOrders());
            }
        }
        if (ToolUtil.isNotEmpty(targetsSql)) {
            echarsQuerySql = echarsQuerySql.replace("${r'${targets}'}", targetsSql);
        }else {
            echarsQuerySql = echarsQuerySql.replace("${r'${targets}'}", "*");
        }
        // 查询条件构造器,将排序条件封装成QueryWrapper
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper<${selectVoName}> queryWrapper = singleTableQueryGenerator.initQueryWrapper(new ${selectVoName}(), parameterMap);
        if (HussarUtils.isNotEmpty(${QueryObj?uncap_first}.getSuperQueryConditionDto())) {
            // 查询条件构造器,将查询条件封装成QueryWrapper
            List<SuperQueryConditionDto> superQueryConditionDtoList = ${QueryObj?uncap_first}.getSuperQueryConditionDto();
            SuperQueryGenerator<${selectVoName}> superQueryGenerator = new SuperQueryGenerator(${selectVoName}.class);
            superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
        }
        if (ToolUtil.isNotEmpty(queryWrapper.getCustomSqlSegment())) {
            echarsQuerySql = echarsQuerySql.replace("${r'${queryWrapper}'}", queryWrapper.getCustomSqlSegment());
        }else {
            echarsQuerySql = echarsQuerySql.replace("${r'${queryWrapper}'}", "");
        }
        <#list queryFields! as field>
            <#assign getprefix="get">
            <#if field.propertyType == "Boolean">
                <#assign getprefix="is">
            </#if>
            ${field.propertyType} ${field.propertyName} = ${QueryObj?uncap_first}.${getprefix}${field.capitalName}();
        </#list>
        if (ToolUtil.isNotEmpty(queryWrapper.getParamNameValuePairs())) {
            for (Map.Entry<String, Object> entry : queryWrapper.getParamNameValuePairs().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                echarsQuerySql = echarsQuerySql.replace(<#noparse>"#{ew.paramNameValuePairs." + key + "}"</#noparse>,
                        String.format("'%s'", value));
            }
        }
        Map<String, Object> returnMap = new HashMap<>();
        /* @begin ${name!}1 #自定义代码 */
        /* @end ${name!}1 */
        List<Map<String, String>> maps = new ArrayList<>();
        ResultSet resultSet = SpringContextHolder.getBean(DataSource.class).getConnection().prepareStatement(echarsQuerySql).executeQuery();
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            Map<String, String> rowMap = new HashMap<>();
            // 遍历每一列
            for (int i = 1; i <= columnCount; i++) {
                String columnName = resultSet.getMetaData().getColumnName(i);
                Object columnValue = resultSet.getObject(i);
                rowMap.put(columnName, String.valueOf(columnValue));
            }
            maps.add(rowMap);
        }
        /* @begin ${name!}2 #自定义代码 */
        /* @end ${name!}2 */
        returnMap.put("data", maps);
        returnMap.put("count", maps.size());
        returnMap.put("code", RETURN_CODE);
        return ApiResponse.success(returnMap);
    } catch (Exception e) {
    <#if table?? && table.transDisposition?? && table.transDisposition>
        throw new HussarException(TfModelEnum.TF_CHART_QUERY_FAILED.getMessage(),e);
    <#else>
        throw new HussarException("图表查询失败",e);
    </#if>
    }
}