<#assign dto = queryDto>
package ${dto.packageInfo!};

<#include "../../swagger/swagger_model.ftl">
<#list dto.imports! as import>
    import ${import};
</#list>
${entityimport}
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import java.util.List;
import java.util.Map;
/**
* 表格自定义查询入参结构
*/
<#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
    @ApiModel(value = "表格自定义查询入参结构")
</#if>
public class ${dto.entityName!} implements BaseEntity {

/**
* 当前页
*/
<#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
    @ApiModelProperty(value = "当前页")
</#if>
private int current;

/**
* 每页显示数
*/
<#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
    @ApiModelProperty(value = "每页显示数")
</#if>
private int size;
/**
* 排序列及类型
*/
<#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
    @ApiModelProperty(value = "排序列及类型")
</#if>
private List <OrderItem> orders;

/**
* 总计数据列
*/
<#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
    @ApiModelProperty(value = "总计数据列")
</#if>
private Map<String, Object> columnFields;

/**
* 指标信息(图表)
*/
<#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
    @ApiModelProperty(value = "指标信息(图表)")
</#if>
private List<Map<String,String>> targets;

/**
* 维度信息(图表)
*/
<#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
    @ApiModelProperty(value = "维度信息(图表)")
</#if>
private List<String> dims;
/**
* 筛选条件
*/
<#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
    @ApiModelProperty(value = "筛选条件")
</#if>
private List<SuperQueryConditionDto> superQueryConditionDto;

<#list dto.queryFields! as field>
    /**
    * ${field.comment}
    */
    <#if table?? && table.enableSwaggerRender?? && table.enableSwaggerRender!>
            <#if field.comment?? && field.comment!=''>
                @ApiModelProperty(value = "${field.comment!}")
            <#else>
                @ApiModelProperty(value = "${field.propertyName}")
            </#if>
        </#if>
    private ${field.propertyType} ${field.propertyName};
</#list>
/* @begin property #自定义属性 */
/* @end property */
<#list dto.queryFields! as field>
    <#assign getprefix="get">
    <#if field.propertyType == "Boolean">
        <#assign getprefix="is">
    </#if>
    public ${field.propertyType} ${getprefix}${field.capitalName}() {
        return ${field.propertyName};
    }

    public void set${field.capitalName}(${field.propertyType} ${field.propertyName}) {
        this.${field.propertyName} = ${field.propertyName};
    }
</#list>

public int getCurrent() {
return current;
}

public void setCurrent(int current) {
this.current = current;
}

public int getSize() {
return size;
}

public void setSize(int size) {
this.size = size;
}

public List<OrderItem> getOrders() {
return orders;
}

public void setOrders(List<OrderItem> orders) {
this.orders = orders;
}

public List<Map<String, String>> getTargets() {
return targets;
}

public void setTargets(List<Map<String, String>> targets) {
this.targets = targets;
}

public List<String> getDims() {
return dims;
}

public void setDims(List<String> dims) {
this.dims = dims;
}

public List<SuperQueryConditionDto> getSuperQueryConditionDto() {
return superQueryConditionDto;
}

public void setSuperQueryConditionDto(List<SuperQueryConditionDto> superQueryConditionDto) {
this.superQueryConditionDto = superQueryConditionDto;
}
public Map<String, Object> getColumnFields() {
return columnFields;
}

public void setColumnFields(Map<String, Object> columnFields) {
this.columnFields = columnFields;
}
/* @begin getAndSet #自定义get、set */
/* @end getAndSet */
}
