/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.function.enclosure;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlTransUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetEnclosure;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.AssociationSubset;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.AssociationTable;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationArchiveTable;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationDataSetParam;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationQueryCondition;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationSortCondition;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationSortConditionDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationTableField;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.DataSetCorrelationDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetProjectionField;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetBaseDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetProjectionFieldDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetQueryDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="DATA_SET.ASSOCIATIONENCLOSURE")
public class CorrelationEnclosure
implements DataSetEnclosure<CorrelationDataModel> {
    public static final String ENCLOSURE = "DATA_SET.ASSOCIATIONENCLOSURE";
    protected static final int DEF_SB_SIZE = 128;
    private static final String RESULT_COLUMN = "<result column=\"${column}\" property=\"${property}\"/>\n";
    private static final String SELECT = "select";
    private static final String SELECTVO = "selectVO";
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);

    @Override
    public DataSetBaseDTO enclosure(CorrelationDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        DataSetCorrelationDTO dataModelBaseDTO = new DataSetCorrelationDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        boolean ignoreStrategy = false;
        dataModelBaseDTO.setDataSourceName(dataModelBase.getDataSourceName());
        dataModelBaseDTO.setId(dataModelBase.getId());
        dataModelBaseDTO.setName(dataModelBase.getName());
        dataModelBaseDTO.setComment(dataModelBase.getComment());
        dataModelBaseDTO.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelBaseDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setVoName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelBaseDTO.getName() + "VO"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setSelectVoName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelBaseDTO.getName() + SELECT + "VO"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setMapperName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setXmlName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setServiceName(dataModelBaseDTO.getEntityName() + "Service");
        dataModelBaseDTO.setServiceImplName(dataModelBaseDTO.getEntityName() + "ServiceImpl");
        dataModelBaseDTO.setControllerName(dataModelBaseDTO.getEntityName() + "Controller");
        dataModelBaseDTO.setModuleName(dataModelBase.getModelPath().replace("/", "."));
        dataModelBaseDTO.setDictName(dataModelBaseDTO.getEntityName() + NamingStrategy.capitalFirst((String)"dict"));
        dataModelBaseDTO.setTablePath(dataModelBase.getModelPath() + "/" + dataModelBase.getName());
        if (dataModelBaseDTO.isUseMybatisPlus()) {
            dataModelBaseDTO.addEntityImport("com.baomidou.mybatisplus.annotation.TableName");
        }
        this.renderResultMapContent(dataModelBase, dataModelBaseDTO);
        Map packageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
        dataModelBaseDTO.setPackageInfo(packageInfo);
        Map<String, String> importInfo = CorrelationEnclosure.getImportInfo(packageInfo, dataModelBaseDTO);
        dataModelBaseDTO.setImportInfo(importInfo);
        DataSetQueryDTO queryDTO = DataSetModelUtil.getFilterDto(dataModelBaseDTO, dataModelBase);
        dataModelBaseDTO.addQueryDto(queryDTO);
        this.renderWhereSql(dataModelBase, dataModelBaseDTO);
        this.renderSortConditionToSql(dataModelBase, dataModelBaseDTO);
        boolean enableSwaggerRender = this.formDesignProperties.isEnableSwaggerRender();
        if (enableSwaggerRender) {
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.Api");
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.ApiOperation");
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.ApiParam");
        }
        dataModelBaseDTO.setEnableSwaggerRender(enableSwaggerRender);
        return dataModelBaseDTO;
    }

    public static Map<String, String> getImportInfo(Map<String, String> packageInfo, DataSetBaseDTO dataModelDto) {
        HashMap<String, String> importInfo = new HashMap<String, String>();
        importInfo.put("Mapper", packageInfo.get("Mapper") + "." + dataModelDto.getMapperName());
        importInfo.put("Xml", packageInfo.get("Xml") + "." + dataModelDto.getXmlName());
        importInfo.put("Service", packageInfo.get("Service") + "." + dataModelDto.getServiceName());
        importInfo.put("ServiceImpl", packageInfo.get("ServiceImpl") + "." + dataModelDto.getServiceImplName());
        importInfo.put("Controller", packageInfo.get("Controller") + "." + dataModelDto.getControllerName());
        importInfo.put("dict", packageInfo.get("dict") + "." + dataModelDto.getDictName());
        importInfo.put("dto", packageInfo.get("dto") + "." + dataModelDto.getEntityName() + "Qo");
        importInfo.put("VO", packageInfo.get("VO") + "." + dataModelDto.getVoName());
        importInfo.put(SELECTVO, packageInfo.get("VO") + "." + dataModelDto.getSelectVoName());
        return importInfo;
    }

    public void renderSortCondition(CorrelationDataModel dataModelBase, DataSetCorrelationDTO dataModelBaseDTO) {
        CorrelationDataSetParam dataSetParam;
        if (ToolUtil.isNotEmpty((Object)dataModelBase.getDataSetParam()) && ToolUtil.isNotEmpty((dataSetParam = dataModelBase.getDataSetParam()).getSort()) && ToolUtil.isNotEmpty(dataSetParam.getTables())) {
            List<CorrelationSortCondition> sortConditions = dataSetParam.getSort();
            List<CorrelationArchiveTable> tables = dataSetParam.getTables();
            ArrayList<CorrelationSortConditionDTO> sortConditionFields = new ArrayList<CorrelationSortConditionDTO>();
            for (CorrelationSortCondition sortCondition : sortConditions) {
                CorrelationArchiveTable correlationArchiveTable;
                if (!ToolUtil.isNotEmpty((Object)sortCondition.getTable()) || !ToolUtil.isNotEmpty((Object)sortCondition.getField()) || !ToolUtil.isNotEmpty((Object)sortCondition.getDirection()) || !ToolUtil.isNotEmpty((Object)(correlationArchiveTable = tables.stream().filter(table -> HussarUtils.equals((Object)table.getName(), (Object)sortCondition.getTable())).findFirst().orElseGet(CorrelationArchiveTable::new))) || !ToolUtil.isNotEmpty(correlationArchiveTable.getFields())) continue;
                List<CorrelationTableField> tableFields = correlationArchiveTable.getFields();
                CorrelationTableField correlationTableField = tableFields.stream().filter(tableField -> HussarUtils.equals((Object)tableField.getName(), (Object)sortCondition.getField())).findFirst().orElseGet(CorrelationTableField::new);
                CorrelationSortConditionDTO sortConditionDTO = new CorrelationSortConditionDTO();
                sortConditionDTO.setDirection(sortCondition.getDirection());
                sortConditionDTO.setFromModelFieldSort(correlationTableField.getConvertField());
                sortConditionFields.add(sortConditionDTO);
            }
            if (ToolUtil.isNotEmpty(sortConditionFields)) {
                dataModelBaseDTO.setSortConditionFields(sortConditionFields);
            }
        }
    }

    public void renderSortConditionToSql(CorrelationDataModel dataModelBase, DataSetCorrelationDTO dataModelBaseDTO) {
        if (ToolUtil.isNotEmpty((Object)dataModelBase.getDataSetParam())) {
            StringBuilder finalReturn = new StringBuilder(128);
            String sortSql = "ORDER BY \n";
            String sortTemplate = "  ${rAttr} ${sortCondition},\n";
            CorrelationDataSetParam dataSetParam = dataModelBase.getDataSetParam();
            if (ToolUtil.isNotEmpty(dataSetParam.getSort()) && ToolUtil.isNotEmpty(dataSetParam.getTables())) {
                List<CorrelationSortCondition> sortConditions = dataSetParam.getSort();
                List<CorrelationArchiveTable> tables = dataSetParam.getTables();
                Map<String, String> finalMap = dataModelBase.getFinalMap();
                finalReturn.append(sortSql);
                ArrayList sortConditionFields = new ArrayList();
                for (CorrelationSortCondition sortCondition : sortConditions) {
                    CorrelationArchiveTable correlationArchiveTable;
                    if (!ToolUtil.isNotEmpty((Object)sortCondition.getTable()) || !ToolUtil.isNotEmpty((Object)sortCondition.getField()) || !ToolUtil.isNotEmpty((Object)sortCondition.getDirection()) || !ToolUtil.isNotEmpty((Object)(correlationArchiveTable = tables.stream().filter(table -> HussarUtils.equals((Object)table.getName(), (Object)sortCondition.getTable())).findFirst().orElseGet(CorrelationArchiveTable::new))) || !ToolUtil.isNotEmpty(correlationArchiveTable.getFields())) continue;
                    List<CorrelationTableField> tableFields = correlationArchiveTable.getFields();
                    CorrelationTableField correlationTableField = tableFields.stream().filter(tableField -> HussarUtils.equals((Object)tableField.getName(), (Object)sortCondition.getField())).findFirst().orElseGet(CorrelationTableField::new);
                    String tableAttr = finalMap.get(correlationArchiveTable.getName());
                    finalReturn.append(sortTemplate.replace("${rAttr}", tableAttr + "." + correlationTableField.getName()).replace("${sortCondition}", sortCondition.getDirection()));
                }
                if (finalReturn.length() > 0) {
                    dataModelBaseDTO.setSortConditionSql(finalReturn.substring(0, finalReturn.length() - 2));
                }
            }
        }
    }

    private void renderWhereSql(CorrelationDataModel dataModelBase, DataSetCorrelationDTO dataModelBaseDTO) throws CloneNotSupportedException {
        String whereSql;
        CorrelationDataSetParam dataSetParam = dataModelBase.getDataSetParam();
        Map<String, String> modelAliasName = dataModelBase.getFinalMap();
        List<CorrelationQueryCondition> query = dataSetParam.getQuery();
        if (ToolUtil.isNotEmpty(query) && ToolUtil.isNotEmpty((Object)(whereSql = this.renderQueryCon(query, dataModelBase, dataModelBaseDTO, false, ConnectEnum._AND.getType(), modelAliasName, new DataSetQueryDTO())))) {
            dataModelBaseDTO.setWhereSql(whereSql);
        }
    }

    private String renderQueryCon(List<CorrelationQueryCondition> query, CorrelationDataModel dataModelBase, DataSetCorrelationDTO dataModelBaseDTO, boolean loopMark, String lastConnect, Map<String, String> modelAliasName, DataSetQueryDTO dataSetQueryDTO) {
        StringBuilder whereResult = new StringBuilder(128);
        if (!loopMark) {
            whereResult.append("<where>\n");
        } else {
            whereResult.append("\n<trim prefix=\"").append(lastConnect).append(" (\" suffix=\")\" prefixOverrides=\"and|or\">\n");
        }
        List<DataSetQueryFieldDTO> queryFields = dataModelBaseDTO.getQueryField();
        for (int i = 0; i < query.size(); ++i) {
            CorrelationQueryCondition correlationQueryCondition = query.get(i);
            String symbol = correlationQueryCondition.getCondition();
            if (ToolUtil.isNotEmpty((Object)correlationQueryCondition) && HussarUtils.equals((Object)ConnectEnum._ROW.getType(), (Object)correlationQueryCondition.getType())) {
                if (ToolUtil.isNotEmpty((Object)symbol) && (HussarUtils.equals((Object)SqlConnectEnum._IS_NULL.getKey(), (Object)symbol) || HussarUtils.equals((Object)SqlConnectEnum._IS_NOT_NULL.getKey(), (Object)symbol))) {
                    String templateIsNullOrIsNotNull = "  ${connect} ${T}.${rAttr} ${symbol}\n";
                    whereResult.append(templateIsNullOrIsNotNull.replace("${connect}", correlationQueryCondition.getPreCondition()).replace("${T}", modelAliasName.get(correlationQueryCondition.getTable())).replace("${rAttr}", correlationQueryCondition.getField()).replace("${symbol}", SqlTransUtil.transSqlSymbol((String)symbol)));
                    continue;
                }
                if (!ToolUtil.isNotEmpty((Object)symbol)) continue;
                String paramType = correlationQueryCondition.getParamType();
                if ("constant".equals(paramType)) {
                    Object value = correlationQueryCondition.getValue();
                    String constantTemplate = "  ${connect} ${T}.${rAttr} ${symbol} ${objAttr}\n";
                    whereResult.append(constantTemplate.replace("${connect}", correlationQueryCondition.getPreCondition()).replace("${T}", modelAliasName.get(correlationQueryCondition.getTable())).replace("${rAttr}", correlationQueryCondition.getField()).replace("${symbol}", SqlTransUtil.transSqlSymbol((String)symbol)).replace("${objAttr}", value.toString()));
                    continue;
                }
                if (!"variable".equals(paramType) || !ToolUtil.isNotEmpty((Object)correlationQueryCondition.getValue()) || !ToolUtil.isNotEmpty(queryFields)) continue;
                String paramDataType = correlationQueryCondition.getParamDataType();
                String template = "<if test=\"${obj}.${attr} != '' and ${obj}.${attr} != null\">\n${likeBind}  ${connect} ${T}.${rAttr} ${symbol} ${objAttr}\n</if>\n";
                String templateNoEmpty = "<if test=\"${obj}.${attr} != null\">\n${likeBind}  ${connect} ${T}.${rAttr} ${symbol} ${objAttr}\n</if>\n";
                String templateForEach = "<if test=\"${obj}.${attr} != null and ${obj}.${attr}.size > 0\">\n ${connect} ${T}.${rAttr} ${symbol}\n    <foreach collection=\"${obj}.${attr}\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>";
                String templateForEachStr = "<if test=\"${obj}.${attr} != null and ${obj}.${attr} != ''\">\n ${connect} ${T}.${rAttr} ${symbol}\n    <foreach collection=\"${obj}.${attr}.split(',')\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>";
                String objParam = "dataSetParam";
                String queryAttrName = correlationQueryCondition.getQueryAttrName();
                String objAttr = "#{" + objParam + "." + queryAttrName + "}";
                String splitStr = "";
                String linkBind = "";
                String linkBindTemplate = "<bind name=\"${name}\" value=\"${value}\" />\n";
                String bindName = objParam + StringUtils.capitalize((String)queryAttrName);
                if (HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) || HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) || HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) {
                    String value = HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) ? objParam + "." + queryAttrName + " + '%'" : (HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) ? "'%' + " + objParam + "." + queryAttrName : "'%' + " + objParam + "." + queryAttrName + " + '%'");
                    objAttr = "#{" + bindName + "}";
                    linkBind = linkBindTemplate.replace("${name}", bindName).replace("${value}", value);
                } else if (HussarUtils.equals((Object)SqlConnectEnum._REGEXP.getKey(), (Object)symbol)) {
                    linkBind = linkBindTemplate.replace("${name}", bindName).replace("${value}", objParam + "." + queryAttrName);
                    objAttr = "REPLACE(#{" + bindName + "},'" + splitStr + "','|')";
                }
                String checkTemplate = template;
                if (ToolUtil.isNotEmpty((Object)correlationQueryCondition.getParamDataType()) && ("date".equals(correlationQueryCondition.getParamDataType()) || "boolean".equals(correlationQueryCondition.getParamDataType()) || "int".equals(correlationQueryCondition.getParamDataType()) || "long".equals(correlationQueryCondition.getParamDataType()))) {
                    checkTemplate = templateNoEmpty;
                }
                if ((HussarUtils.equals((Object)SqlConnectEnum._IN.getKey(), (Object)symbol) || HussarUtils.equals((Object)SqlConnectEnum._NOT_IN.getKey(), (Object)symbol)) && ToolUtil.isNotEmpty((Object)correlationQueryCondition.getParamDataType())) {
                    checkTemplate = HussarUtils.equals((Object)"arrayprimary", (Object)correlationQueryCondition.getParamDataType().toLowerCase()) ? templateForEach : templateForEachStr;
                }
                if (HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) || HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) || HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) {
                    checkTemplate = checkTemplate.replace("${objAttr}", "${objAttr} escape '/'");
                }
                whereResult.append(checkTemplate.replace("${connect}", correlationQueryCondition.getPreCondition()).replace("${T}", modelAliasName.get(correlationQueryCondition.getTable())).replace("${rAttr}", correlationQueryCondition.getField()).replace("${symbol}", SqlTransUtil.transSqlSymbol((String)symbol)).replace("${obj}", objParam).replace("${attr}", queryAttrName).replace("${likeBind}", linkBind).replace("${objAttr}", objAttr));
                continue;
            }
            if (!ToolUtil.isNotEmpty((Object)correlationQueryCondition) || !HussarUtils.equals((Object)ConnectEnum._CHILD.getType(), (Object)correlationQueryCondition.getType()) || !ToolUtil.isNotEmpty(correlationQueryCondition.getChildren())) continue;
            whereResult.append(this.renderQueryCon(correlationQueryCondition.getChildren(), dataModelBase, dataModelBaseDTO, true, correlationQueryCondition.getCondition(), modelAliasName, new DataSetQueryDTO()));
        }
        if (!loopMark) {
            whereResult.append("</where>\n");
        } else {
            whereResult.append("</trim>\n");
        }
        return whereResult.toString();
    }

    private void renderResultMapContent(CorrelationDataModel dataModelBase, DataSetCorrelationDTO dataModelBaseDTO) throws CloneNotSupportedException {
        CorrelationDataSetParam dataSetParam = dataModelBase.getDataSetParam();
        List<AssociationTable> relationship = dataSetParam.getRelationship();
        Map<String, String> modelAliasName = dataModelBase.getFinalMap();
        List<DataSetProjectionField> projection = dataSetParam.getProjection();
        ArrayList<DataSetProjectionFieldDTO> tableFields = new ArrayList<DataSetProjectionFieldDTO>();
        StringBuilder finalResult = new StringBuilder(128);
        for (DataSetProjectionField dataSetProjectionField : projection) {
            DataSetProjectionFieldDTO tableField = new DataSetProjectionFieldDTO();
            tableField.setConvert(true);
            tableField.setName(dataSetProjectionField.getField());
            tableField.setId(dataSetProjectionField.getColumnId());
            tableField.setPropertyName(dataSetProjectionField.getConvertField());
            tableField.setComment(dataSetProjectionField.getRename());
            tableField.setType(dataSetProjectionField.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataSetProjectionField.getFieldDataType()));
            tableField.setFieldType(dataSetProjectionField.getType());
            if ("default".equals(dataSetProjectionField.getType()) && ToolUtil.isNotEmpty((Object)dataSetProjectionField.getTable())) {
                String table = dataSetProjectionField.getTable();
                String tableAlias = modelAliasName.get(table);
                if (ToolUtil.isNotEmpty((Object)tableAlias)) {
                    tableField.setAliasName(tableAlias + "." + dataSetProjectionField.getField());
                    tableField.setAsAliasName(tableAlias + dataSetProjectionField.getField());
                }
                finalResult.append(RESULT_COLUMN.replace("${column}", tableField.getAsAliasName()).replace("${property}", tableField.getPropertyName()));
            } else if ("calc".equals(dataSetProjectionField.getType())) {
                tableField.setExpression(dataSetProjectionField.getExpression());
                tableField.setAsAliasName(dataSetProjectionField.getConvertField());
                finalResult.append(RESULT_COLUMN.replace("${column}", tableField.getPropertyName()).replace("${property}", tableField.getPropertyName()));
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFields(tableFields);
        dataModelBaseDTO.setResultMapContent(finalResult.toString());
        ArrayList<DataSetProjectionFieldDTO> voFields = new ArrayList<DataSetProjectionFieldDTO>();
        for (DataSetProjectionFieldDTO tableField : tableFields) {
            voFields.add(tableField.clone());
        }
        VoGeneratorInfo voGeneratorInfo = new VoGeneratorInfo();
        voGeneratorInfo.setFields(voFields);
        dataModelBaseDTO.setVoGeneratorInfo(voGeneratorInfo);
        VoGeneratorInfo selectVo = new VoGeneratorInfo();
        selectVo.setFields(voFields);
        dataModelBaseDTO.setSelectVoGeneratorInfo(selectVo);
        this.renderRelationship(dataModelBase, dataModelBaseDTO, modelAliasName);
    }

    private void renderRelationship(CorrelationDataModel dataModelBase, DataSetCorrelationDTO dataModelBaseDTO, Map<String, String> modelAliasName) {
        StringBuilder relationResult = new StringBuilder(128);
        String mainTemplate = "FROM ${MAIN_MODEL} ${ALIAS} ";
        String relationTemplate = "\n${JOIN_TYPE} ${RE_MODEL} ${ALIAS} \n";
        String masterTableName = dataModelBase.getMasterTableName();
        if (ToolUtil.isNotEmpty((Object)masterTableName)) {
            relationResult.append(mainTemplate.replace("${MAIN_MODEL}", masterTableName).replace("${ALIAS}", modelAliasName.get(masterTableName)));
        }
        List<AssociationTable> relationship = dataModelBase.getDataSetParam().getRelationship();
        List<CorrelationArchiveTable> tables = dataModelBase.getDataSetParam().getTables();
        if (ToolUtil.isNotEmpty(relationship)) {
            HashMap<String, CorrelationArchiveTable> tableMap = new HashMap<String, CorrelationArchiveTable>();
            ArrayList<CorrelationTableField> allTableField = new ArrayList<CorrelationTableField>();
            for (CorrelationArchiveTable table2 : tables) {
                tableMap.put(table2.getTableId(), table2);
                if (!ToolUtil.isNotEmpty((Object)table2) || !ToolUtil.isNotEmpty(table2.getFields())) continue;
                for (CorrelationTableField field : table2.getFields()) {
                    field.setFromTableId(table2.getTableId());
                    allTableField.add(field);
                }
            }
            HashMap<String, String> joinTypeMatchup = new HashMap<String, String>();
            joinTypeMatchup.put("left", "LEFT JOIN");
            joinTypeMatchup.put("right", "RIGHT JOIN");
            joinTypeMatchup.put("inner", "INNER JOIN");
            CorrelationArchiveTable masterTable = tables.stream().filter(table -> HussarUtils.equals((Object)table.getName(), (Object)masterTableName)).findFirst().orElseGet(CorrelationArchiveTable::new);
            for (AssociationTable associationTable : relationship) {
                if (!ToolUtil.isNotEmpty((Object)associationTable)) continue;
                String rightTableId = associationTable.getRightTableId();
                CorrelationArchiveTable rightTable = (CorrelationArchiveTable)tableMap.get(rightTableId);
                relationResult.append(relationTemplate.replace("${JOIN_TYPE}", (CharSequence)joinTypeMatchup.get(associationTable.getJoinType())).replace("${RE_MODEL}", rightTable.getName()).replace("${ALIAS}", modelAliasName.get(rightTable.getName())));
                String condition = this.renderRelationCondition(associationTable.getChildren(), tableMap, "AND", associationTable, masterTable, modelAliasName, allTableField);
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        dataModelBaseDTO.setFinalRelation(relationResult.toString());
    }

    private String renderRelationCondition(List<AssociationSubset> associationSubsets, Map<String, CorrelationArchiveTable> tableMap, String lastConnect, AssociationTable associationTable, CorrelationArchiveTable masterTable, Map<String, String> modelAliasName, List<CorrelationTableField> allTableField) {
        StringBuilder finalCondition = new StringBuilder(128);
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        List<CorrelationTableField> masterTableFields = masterTable.getFields();
        if (ToolUtil.isNotEmpty(associationSubsets)) {
            for (int i = 0; i < associationSubsets.size(); ++i) {
                String connectSym;
                String connect = lastConnect;
                if (i == 0) {
                    connect = "";
                }
                AssociationSubset associationSubset = associationSubsets.get(i);
                CorrelationTableField leftField = allTableField.stream().filter(field -> HussarUtils.equals((Object)field.getColumnId(), (Object)associationSubset.getLeftFieldId())).findFirst().orElseGet(CorrelationTableField::new);
                CorrelationArchiveTable leftTable = tableMap.get(leftField.getFromTableId());
                CorrelationTableField rightField = allTableField.stream().filter(field -> HussarUtils.equals((Object)field.getColumnId(), (Object)associationSubset.getRightFieldId())).findFirst().orElseGet(CorrelationTableField::new);
                CorrelationArchiveTable rightTable = tableMap.get(rightField.getFromTableId());
                finalCondition.append(conditionTemplate.replace("${CONNECT}", connect).replace("${RE}", modelAliasName.get(leftTable.getName())).replace("${FIELD}", leftField.getName()).replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)associationSubset.getCondition())).replace("${T_RE}", modelAliasName.get(rightTable.getName())).replace("${RE_FIELD}", rightField.getName()));
                lastConnect = connectSym = associationSubset.getPreCondition();
            }
        }
        return finalCondition.toString();
    }
}

