/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.util;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;

public class DataSetFieldTypeConvert {
    public static String convertDataType(String fieldType, String modelId) throws LcdpException {
        String dataType = "string";
        String dataSourceType = "MYSQL";
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            dataSourceType = DataModelUtil.getDataSourceType((String)modelId);
        }
        if (ToolUtil.isNotEmpty((Object)fieldType) && ToolUtil.isNotEmpty((Object)dataSourceType)) {
            switch (dataSourceType) {
                case "MYSQL": {
                    dataType = DataSetFieldTypeConvert.mysqlConvertDataType(fieldType);
                    break;
                }
                case "ORACLE": {
                    dataType = DataSetFieldTypeConvert.oracleConvertDataType(fieldType);
                    break;
                }
                case "DM": {
                    dataType = DataSetFieldTypeConvert.dmConvertDataType(fieldType);
                    break;
                }
                case "SQL_SERVER": {
                    dataType = DataSetFieldTypeConvert.sqlserverConvertDataType(fieldType);
                    break;
                }
                case "POSTGRE_SQL": {
                    dataType = DataSetFieldTypeConvert.pgConvertDataType(fieldType);
                    break;
                }
                case "OSCAR": {
                    dataType = DataSetFieldTypeConvert.oscarConvertDataType(fieldType);
                    break;
                }
                case "KINGBASE": {
                    dataType = DataSetFieldTypeConvert.kbConvertDataType(fieldType);
                    break;
                }
                case "HIGHGO": {
                    dataType = DataSetFieldTypeConvert.hgConvertDataType(fieldType);
                    break;
                }
                default: {
                    dataType = DataSetFieldTypeConvert.mysqlConvertDataType(fieldType);
                }
            }
        }
        return dataType;
    }

    private static String mysqlConvertDataType(String fieldType) {
        if (ToolUtil.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("char") || fieldType.contains("text")) {
                return "string";
            }
            if (fieldType.contains("bigint")) {
                return "long";
            }
            if (fieldType.contains("int")) {
                return "int";
            }
            if (fieldType.contains("timestamp") || fieldType.contains("date") || fieldType.contains("year")) {
                return "date";
            }
            if (fieldType.contains("bit")) {
                return "boolean";
            }
            if (fieldType.contains("float") || fieldType.contains("double") || fieldType.contains("decimal")) {
                return "double";
            }
        }
        return "string";
    }

    private static String oracleConvertDataType(String fieldType) {
        if (ToolUtil.isNotEmpty((Object)fieldType)) {
            String type = fieldType.toLowerCase();
            if (type.toLowerCase().contains("char")) {
                return "string";
            }
            if (type.toLowerCase().contains("date") || type.contains("timestamp")) {
                return "date";
            }
            if (type.toLowerCase().contains("number")) {
                return "long";
            }
            if (type.contains("float")) {
                return "double";
            }
        }
        return "string";
    }

    private static String dmConvertDataType(String fieldType) {
        if (ToolUtil.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("char")) {
                return "string";
            }
            if (fieldType.contains("timestamp") || fieldType.contains("date")) {
                return "date";
            }
            if (fieldType.contains("decimal")) {
                return "long";
            }
            if (fieldType.contains("float")) {
                return "double";
            }
        }
        return "string";
    }

    private static String sqlserverConvertDataType(String fieldType) {
        if (ToolUtil.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("char") || fieldType.contains("nvarchar")) {
                return "string";
            }
            if (fieldType.contains("numeric")) {
                return "long";
            }
            if (fieldType.contains("date") || fieldType.contains("datetime") || fieldType.contains("datetime2")) {
                return "date";
            }
            if (fieldType.contains("float") || fieldType.contains("decimal")) {
                return "double";
            }
        }
        return "string";
    }

    private static String kbConvertDataType(String fieldType) {
        if (ToolUtil.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("char") || fieldType.contains("text")) {
                return "string";
            }
            if (fieldType.contains("numeric")) {
                return "long";
            }
            if (fieldType.contains("time") || fieldType.contains("date") || fieldType.contains("timestamp")) {
                return "date";
            }
            if (fieldType.contains("bool")) {
                return "boolean";
            }
            if (fieldType.contains("float")) {
                return "double";
            }
        }
        return "string";
    }

    private static String oscarConvertDataType(String fieldType) {
        if (ToolUtil.isNotEmpty((Object)fieldType)) {
            if ("char".equals(fieldType.toLowerCase()) || "varchar".equals(fieldType.toLowerCase())) {
                return "string";
            }
            if ("date".equals(fieldType.toLowerCase()) || "time".equals(fieldType.toLowerCase()) || "timestamp".equals(fieldType.toLowerCase())) {
                return "date";
            }
            if ("numeric".equals(fieldType.toLowerCase())) {
                return "long";
            }
            if ("float".equals(fieldType.toLowerCase())) {
                return "double";
            }
        }
        return "string";
    }

    private static String hgConvertDataType(String fieldType) {
        if (ToolUtil.isNotEmpty((Object)fieldType)) {
            if (fieldType.contains("bpchar") || fieldType.contains("text") || fieldType.contains("varchar")) {
                return "string";
            }
            if (fieldType.contains("numeric")) {
                return "long";
            }
            if (fieldType.contains("date") || fieldType.contains("timestamp")) {
                return "date";
            }
            if (fieldType.contains("float4") || fieldType.contains("float8")) {
                return "double";
            }
            if (fieldType.contains("boolean") || fieldType.contains("float8")) {
                return "boolean";
            }
        }
        return "string";
    }

    private static String pgConvertDataType(String fieldType) {
        if (ToolUtil.isNotEmpty((Object)fieldType)) {
            if ("bpchar".equals(fieldType.toLowerCase()) || "varchar".equals(fieldType.toLowerCase()) || "text".equals(fieldType.toLowerCase())) {
                return "string";
            }
            if ("numeric".equals(fieldType.toLowerCase())) {
                return "long";
            }
            if ("date".equals(fieldType.toLowerCase()) || "timestamp".equals(fieldType.toLowerCase())) {
                return "date";
            }
            if ("float4".equals(fieldType.toLowerCase()) || "float8".equals(fieldType.toLowerCase())) {
                return "double";
            }
            if ("boolean".equals(fieldType.toLowerCase())) {
                return "boolean";
            }
        }
        return "string";
    }
}

