/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.JavaCodeFormatUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.XMLCodeParserUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.code.DataSetCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.ctx.DataSetBackCtx;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetBaseDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetBaseDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.result.DataSetCodeResult;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class DataSetCodeMergeUtil {
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static VersionManageService versionManageService = (VersionManageService)SpringContextUtil.getBean(VersionManageService.class);
    private static CodeMergeService codeMergeService = (CodeMergeService)SpringContextUtil.getBean(CodeMergeService.class);
    private static final String CLIENT_TYPE = "publishIds";

    public static List<DataSetCodeResult> mergeBack(List<DataSetCodeGenerateInfo> codeGenerateInfos, DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> backCtx) throws IOException, LcdpException {
        ArrayList<DataSetCodeResult> results = new ArrayList<DataSetCodeResult>();
        if (ToolUtil.isNotEmpty(codeGenerateInfos)) {
            List<Object> publishIds = new ArrayList();
            if (null != Optional.ofNullable(backCtx.getParams()).orElseGet(HashMap::new).get(CLIENT_TYPE)) {
                publishIds = Arrays.asList(backCtx.getParams().get(CLIENT_TYPE).toString().split(","));
            }
            for (DataSetCodeGenerateInfo codeGenerateInfo : codeGenerateInfos) {
                if ("js".equals(codeGenerateInfo.getFileType()) && ToolUtil.isNotEmpty(publishIds)) {
                    for (String string : publishIds) {
                        results.add(DataSetCodeMergeUtil.mergeBackCode(codeGenerateInfo, string, backCtx));
                    }
                    continue;
                }
                results.add(DataSetCodeMergeUtil.mergeBackCode(codeGenerateInfo, "", backCtx));
            }
        }
        return results;
    }

    private static DataSetCodeResult mergeBackCode(DataSetCodeGenerateInfo codeGenerateInfo, String publishId, DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> backCtx) throws IOException, LcdpException {
        BaseFile baseFile = HussarUtils.isNotEmpty((Object)backCtx.getBaseFile()) ? backCtx.getBaseFile() : new BaseFile();
        String absolutePath = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
        DataSetCodeResult genCodeResult = new DataSetCodeResult();
        genCodeResult.setResultType(ResultBeanEnum.MYSQL_RESULT);
        DataSetCodeMergeUtil.formatCode(codeGenerateInfo);
        String mergeCode = "";
        if (!codeGenerateInfo.isCodeFormatSucceed()) {
            genCodeResult.setId(baseFile.getId());
            genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
            genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
            genCodeResult.setCodeFormatMessages(codeGenerateInfo.getCodeFormatMessages());
            genCodeResult.setMsg(codeGenerateInfo.getCodeFormatMsg());
            genCodeResult.setCodeFormatSucceed(codeGenerateInfo.isCodeFormatSucceed());
            return genCodeResult;
        }
        if (!(baseFile instanceof PageInfo)) {
            baseFile.setId(backCtx.getUseDataModelBase().getId());
        }
        String dataId = DataSetCodeMergeUtil.getVersionFileKey(codeGenerateInfo);
        String jsPath = FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage")).projectApiFullPath(codeGenerateInfo.getFileWriteRelativePath()).getLocalPath();
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            String writeFile;
            Optional<String> currentCode;
            if ("js".equals(codeGenerateInfo.getFileType())) {
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(jsPath));
            } else {
                String currentPath = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath();
                currentCode = Optional.ofNullable(filePublishService.readCurrentPublishedFile(currentPath));
            }
            Optional<String> versionCode = Optional.ofNullable(versionManageService.getAncestorCodeById(dataId));
            String lastFileCode = versionManageService.getLastFileCode(dataId);
            if (currentCode.isPresent() && versionCode.isPresent()) {
                MergeResult mergeResult;
                String currentFile = currentCode.get();
                String lastPublish = versionCode.get();
                if (codeGenerateInfo.getFileType().equals("xml")) {
                    currentFile = CodeSplitUtil.setEndOnlyLine((String)currentFile);
                    lastPublish = CodeSplitUtil.setEndOnlyLine((String)lastPublish);
                }
                if ((mergeResult = codeMergeService.structuralMerge(jsPath, ExtractFileType.byExtension((String)codeGenerateInfo.getFileName()), lastPublish, currentFile, codeGenerateInfo.getFileContent(), lastFileCode, false)).isConflict()) {
                    genCodeResult.setExistConflict(true);
                    genCodeResult.setMergeCode(mergeResult.getMergedCode());
                    genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                    genCodeResult.setOriginCode(currentCode.get());
                    genCodeResult.setNewCode(codeGenerateInfo.getFileContent());
                    genCodeResult.setLastPublish(mergeResult.getLastPublish());
                    genCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                    genCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                    genCodeResult.setMergeInfo(mergeResult.getMergeInfo());
                } else {
                    mergeCode = mergeResult.getMergedCode();
                }
                switch (codeGenerateInfo.getFileType()) {
                    case "controller": 
                    case "entity": 
                    case "service": 
                    case "serviceImpl": 
                    case "mapper": {
                        genCodeResult.setType("java");
                        break;
                    }
                    case "xml": {
                        genCodeResult.setType("xml");
                        break;
                    }
                    case "js": {
                        genCodeResult.setType("js");
                        break;
                    }
                }
            }
            String string = writeFile = ToolUtil.isEmpty((Object)mergeCode) ? codeGenerateInfo.getFileContent() : mergeCode;
            absolutePath = !genCodeResult.isExistConflict() ? DataSetCodeMergeUtil.writeNoConflictCode(codeGenerateInfo, baseFile, dataId, writeFile) : ("js".equals(codeGenerateInfo.getFileType()) ? FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage")).projectApiFullPath(codeGenerateInfo.getFileWriteRelativePath()).getLocalPath() : ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().backProjectJava(new String[]{codeGenerateInfo.getFileWriteRelativePath()}).getLocalPath());
        }
        genCodeResult.setFilePath(ToolUtil.pathFomatterByOS((String)absolutePath));
        genCodeResult.setDataId(dataId);
        genCodeResult.setId(baseFile.getId());
        if (genCodeResult.isExistConflict()) {
            filePublishService.writePublishResult((CodeResult)genCodeResult);
            genCodeResult = genCodeResult.reduceCodeResult();
        }
        return genCodeResult;
    }

    private static void formatCode(DataSetCodeGenerateInfo codeGenerateInfo) {
        String fileType = codeGenerateInfo.getFileType();
        if (ToolUtil.isNotEmpty((Object)fileType) && ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileContent())) {
            CodeFormatResult codeFormatResult;
            if (fileType.equals("controller") || fileType.equals("entity") || fileType.equals("mapper") || fileType.equals("service") || fileType.equals("serviceImpl") || fileType.equals("queryEntity") || fileType.equals("vo")) {
                codeFormatResult = JavaCodeFormatUtil.format((String)codeGenerateInfo.getFileContent());
                codeGenerateInfo.setFileContent(codeFormatResult.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult.isSucceed());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult.getMessages());
            }
            if (fileType.equals("js")) {
                codeFormatResult = CodeFormatter.formatterHtml((String)codeGenerateInfo.getFileContent(), (String)"typescript");
                codeGenerateInfo.setFileContent(codeFormatResult.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult.isSucceed());
                codeGenerateInfo.setCodeFormatMsg(codeFormatResult.getMsg());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult.getMessages());
            }
            if (fileType.equals("xml")) {
                codeGenerateInfo.setFileContent(CodeSplitUtil.setEndOnlyLine((String)codeGenerateInfo.getFileContent()));
            }
            FormDesignProperties formDesignProperties = (FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class);
            if (fileType.equals("xml") && formDesignProperties.isCheckedCode()) {
                CodeFormatResult codeFormatResult2 = XMLCodeParserUtil.parser((String)codeGenerateInfo.getFileContent());
                codeGenerateInfo.setFileContent(codeFormatResult2.getCodeFormatCode());
                codeGenerateInfo.setCodeFormatSucceed(codeFormatResult2.isSucceed());
                codeGenerateInfo.setCodeFormatMessages(codeFormatResult2.getMessages());
            }
        }
    }

    public static String writeNoConflictCode(DataSetCodeGenerateInfo codeGenerateInfo, BaseFile baseFile, String dataId, String writeFile) throws LcdpException, IOException {
        String absolutePath = "js".equals(codeGenerateInfo.getFileType()) ? filePublishService.writeApiCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), baseFile.getId()) : filePublishService.writeMVCCode(writeFile, codeGenerateInfo.getFileWriteRelativePath(), baseFile.getId());
        versionManageService.saveCacheLastPublishCode(dataId, codeGenerateInfo.getFileContent(), baseFile.getId());
        versionManageService.saveCacheLastFileCode(dataId, writeFile, baseFile.getId());
        return absolutePath;
    }

    private static String getVersionFileKey(DataSetCodeGenerateInfo codeGenerateInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(codeGenerateInfo.getFileId());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getPageType()) && !"WebPage".equals(codeGenerateInfo.getPageType()) && !"MobilePage".equals(codeGenerateInfo.getPageType())) {
            stringBuilder.append(codeGenerateInfo.getPageType());
        }
        stringBuilder.append(codeGenerateInfo.getFileType());
        if (ToolUtil.isNotEmpty((Object)codeGenerateInfo.getFileName())) {
            stringBuilder.append(codeGenerateInfo.getFileName());
        }
        return stringBuilder.toString();
    }
}

