/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.processor;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.code.DataSetCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.featuremodel.ctx.DataSetBackCtx;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetModelFunction;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetOperationVisitor;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetRender;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetBaseDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetBaseDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.operation.DataSetDataModelOperation;
import com.jxdinfo.hussar.formdesign.featuremodel.result.DataSetCodeResult;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetModelBeanUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetModelUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataSetModelProcessor
implements DataModelProcessor<DataSetCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(DataSetModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"DATA_SET", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<DataSetCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> backCtx = this.getDataSetBackCtx(publishCtx);
        DataSetModelProcessor.init(backCtx, dataModelBase);
        DataSetModelProcessor.generateDataSetModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    private DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> getDataSetBackCtx(PublishCtx<DataSetCodeResult> publishCtx) {
        DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> backCtx = new DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        if (publishCtx.getPublishDTO() != null) {
            backCtx.setPublishDTO(publishCtx.getPublishDTO());
        }
        return backCtx;
    }

    public static void init(DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        DataSetModelFunction currentFunction = DataSetModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        DataSetBaseDataModel currentModelBase = DataSetModelUtil.transfer(dataModelBase);
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, DataSetBaseDTO> useDtoMap = new HashMap<String, DataSetBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateDataSetModel(DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> backCtx, PublishCtx<DataSetCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        DataSetModelProcessor.visit(backCtx);
        DataSetModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        DataSetBaseDataModel useDataModelBase = backCtx.getUseDataModelBase();
        DataSetBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PageInfoNode pageInfoNode = DataModelUtil.getDataModelNode((String)useDataModelBase.getId());
        for (DataSetDataModelOperation operation : useDataModelBase.getOperations()) {
            DataSetOperationVisitor<DataSetBaseDataModel, DataSetBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("DATA_SET.", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            try {
                backCtx.getModelFunction().accept(visitor, backCtx, operation);
            }
            catch (Exception var) {
                logger.error("\u6a21\u578b\uff1a{}\uff0c\u65b9\u6cd5\uff1a{} \u6e32\u67d3\u5931\u8d25\uff0c\u6e32\u67d3\u8def\u5f84\uff1a{}", new Object[]{useDataModelBase.getComment(), operation.getName(), visitor.getClass().getName()});
                throw new LcdpException(var, String.format("\u6a21\u578b%s\u6e32\u67d3\u5931\u8d25\uff0c\u5f02\u5e38\uff1a%s", useDataModelBase.getComment(), var.getMessage()));
            }
            if (!backCtx.getUseDataModelBase().isPublishResource()) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
    }

    public static void render(DataSetBackCtx<DataSetBaseDataModel, DataSetBaseDTO> backCtx, PublishCtx<DataSetCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        DataSetRender<DataSetBaseDataModel, DataSetBaseDTO> render = backCtx.getModelFunction().render();
        List<DataSetCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(DataSetCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
    }
}

