/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetEnclosure;
import com.jxdinfo.hussar.formdesign.featuremodel.function.DataSetRender;
import com.jxdinfo.hussar.formdesign.featuremodel.function.constant.DataSetSqlConnectEnum;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.AssociationTable;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationDataSetParam;
import com.jxdinfo.hussar.formdesign.featuremodel.function.element.correlation.CorrelationQueryCondition;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetBaseDataModel;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetParameterValue;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.DataSetProjectionField;
import com.jxdinfo.hussar.formdesign.featuremodel.function.model.dto.DataSetBaseDTO;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetModelBeanUtil;
import com.jxdinfo.hussar.formdesign.featuremodel.util.DataSetModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CorrelationDataModel
extends DataSetBaseDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(CorrelationDataModel.class);
    public static final String FUNCTION_TYPE = "ASSOCIATION";
    public static final String DEFAULT = "default";
    public static final String CALC = "calc";
    public static final String VARIABLE = "variable";
    public static final String CONSTANT = "constant";
    private CorrelationDataSetParam dataSetParam;
    private String masterTableName;
    private Map<String, String> finalMap;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"DATA_SET.ASSOCIATION", CorrelationDataModel.class);
    }

    @Override
    public CorrelationDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        CorrelationDataModel dataSetBaseDataModel;
        try {
            dataSetBaseDataModel = (CorrelationDataModel)JSONObject.parseObject((String)jsonObject.toString(), CorrelationDataModel.class);
            this.getModelAliasName(dataSetBaseDataModel.getDataSetParam(), dataSetBaseDataModel);
            if (ToolUtil.isNotEmpty((Object)dataSetBaseDataModel.getDataSetParam())) {
                List<DataSetProjectionField> projection = dataSetBaseDataModel.getDataSetParam().getProjection();
                for (DataSetProjectionField dataSetProjectionField : projection) {
                    if (!ToolUtil.isNotEmpty((Object)dataSetProjectionField.getFieldType())) continue;
                    dataSetProjectionField.setFieldDataType(DataSetFieldTypeConvert.convertDataType(dataSetProjectionField.getFieldType(), dataSetBaseDataModel.getId()));
                }
                List<CorrelationQueryCondition> query = dataSetBaseDataModel.getDataSetParam().getQuery();
                if (ToolUtil.isNotEmpty(query)) {
                    List<DataSetParameterValue> parameterValues = dataSetBaseDataModel.getDataSetParam().getParameterValues();
                    this.ergodicCondition(query, parameterValues);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u5173\u8054\u5173\u7cfb\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u5173\u8054\u5173\u7cfb\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return dataSetBaseDataModel;
    }

    @Override
    public DataSetEnclosure<DataSetBaseDataModel> enclosure() throws LcdpException {
        return DataSetModelBeanUtil.getEnclosureBean("DATA_SET.", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public DataSetRender<DataSetBaseDataModel, DataSetBaseDTO> render() throws LcdpException {
        return DataSetModelBeanUtil.getRenderBean("DATA_SET.", FUNCTION_TYPE, "RENDER");
    }

    public Map<String, String> getFinalMap() {
        return this.finalMap;
    }

    public void setFinalMap(Map<String, String> finalMap) {
        this.finalMap = finalMap;
    }

    public String getMasterTableName() {
        return this.masterTableName;
    }

    public void setMasterTableName(String masterTableName) {
        this.masterTableName = masterTableName;
    }

    public CorrelationDataSetParam getDataSetParam() {
        return this.dataSetParam;
    }

    public void setDataSetParam(CorrelationDataSetParam dataSetParam) {
        this.dataSetParam = dataSetParam;
    }

    private void getModelAliasName(CorrelationDataSetParam dataSetParam, CorrelationDataModel dataSetBaseDataModel) {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)dataSetParam)) {
            if (ToolUtil.isNotEmpty(dataSetParam.getRelationship())) {
                for (AssociationTable associationTable : dataSetParam.getRelationship()) {
                    if (!ToolUtil.isNotEmpty((Object)associationTable) || !ToolUtil.isNotEmpty((Object)associationTable.getLeftTable())) continue;
                    finalMap.put(associationTable.getLeftTable(), "T2");
                    dataSetBaseDataModel.setMasterTableName(associationTable.getLeftTable());
                    break;
                }
                for (int i = 0; i < dataSetParam.getRelationship().size(); ++i) {
                    AssociationTable associationTable;
                    associationTable = dataSetParam.getRelationship().get(i);
                    finalMap.putIfAbsent(associationTable.getRightTable(), "T" + (i + 3));
                }
            } else {
                List<DataSetProjectionField> projection = dataSetParam.getProjection();
                if (ToolUtil.isNotEmpty(projection)) {
                    for (DataSetProjectionField dataSetProjectionField : projection) {
                        if (!DEFAULT.equals(dataSetProjectionField.getType())) continue;
                        finalMap.put(dataSetProjectionField.getTable(), "T2");
                        dataSetBaseDataModel.setMasterTableName(dataSetProjectionField.getTable());
                        break;
                    }
                }
            }
        }
        dataSetBaseDataModel.setFinalMap(finalMap);
    }

    private void ergodicCondition(List<CorrelationQueryCondition> query, List<DataSetParameterValue> parameterValues) {
        if (ToolUtil.isNotEmpty(query)) {
            Map<String, DataSetSqlConnectEnum> enumMap = DataSetModelUtil.getDataSetSqlConnectEnum();
            ArrayList tempConditionAttr = new ArrayList();
            for (int i = 0; i < query.size(); ++i) {
                CorrelationQueryCondition correlationQueryCondition = query.get(i);
                if (ToolUtil.isNotEmpty((Object)correlationQueryCondition) && HussarUtils.equals((Object)ConnectEnum._ROW.getType(), (Object)correlationQueryCondition.getType())) {
                    DataSetParameterValue dataSetParameterValue;
                    if (!ToolUtil.isNotEmpty((Object)correlationQueryCondition.getParamType()) || !HussarUtils.equals((Object)VARIABLE, (Object)correlationQueryCondition.getParamType()) || !ToolUtil.isNotEmpty((Object)correlationQueryCondition.getTable()) || !ToolUtil.isNotEmpty((Object)correlationQueryCondition.getField()) || !ToolUtil.isNotEmpty((Object)correlationQueryCondition.getValue()) || !ToolUtil.isNotEmpty((Object)correlationQueryCondition.getCondition()) || !ToolUtil.isNotEmpty((Object)(dataSetParameterValue = parameterValues.stream().filter(parameterValue -> HussarUtils.equals((Object)parameterValue.getCode(), (Object)correlationQueryCondition.getValue())).findFirst().orElseGet(DataSetParameterValue::new))) || !ToolUtil.isNotEmpty((Object)dataSetParameterValue.getCode())) continue;
                    correlationQueryCondition.setQueryAttrName(dataSetParameterValue.getCode());
                    correlationQueryCondition.setParamDataType(dataSetParameterValue.getType());
                    continue;
                }
                if (!HussarUtils.equals((Object)ConnectEnum._CHILD.getType(), (Object)correlationQueryCondition.getType()) || !ToolUtil.isNotEmpty(correlationQueryCondition.getChildren())) continue;
                this.ergodicCondition(correlationQueryCondition.getChildren(), parameterValues);
            }
        }
    }

    private int getNumber(String queryAttr, int number, List<String> tempConditionAttr) {
        if (ToolUtil.isNotEmpty(tempConditionAttr) && tempConditionAttr.contains(queryAttr)) {
            queryAttr = queryAttr + ++number;
            return this.getNumber(queryAttr, number, tempConditionAttr);
        }
        return number;
    }
}

