/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.element.base.HeBaseDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.HeMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryConditionField;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortConditionField;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.enums.EngineMethodEnum;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.constant.ModelTypeRelationHolder;
import com.jxdinfo.hussar.support.choreo.api.dto.ApiNamingDto;
import com.jxdinfo.hussar.support.choreo.api.dto.MsTableDto;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.ConditionType;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.OrderByType;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeEnginePushUtil {
    private static EngineBussnessdataConfigService configService = (EngineBussnessdataConfigService)SpringContextUtil.getBean(EngineBussnessdataConfigService.class);
    private static ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);
    private static Logger logger = LoggerFactory.getLogger(HeEnginePushUtil.class);
    private static final String ECHART_QUERY = "echartQuery";

    private HeEnginePushUtil() {
    }

    public static SingleTableDto getPushDto(List<HeDataModelFieldDto> fieldDtoList, PushBackCtx ctx, String businessId, String methodName, String methodDesc, int type) {
        SingleTableDto dto = HeEnginePushUtil.getSingleTableDto(ctx, businessId, methodName, methodDesc);
        if (type != 3 && type != 4) {
            dto.setPmList(new ArrayList());
            for (HeDataModelFieldDto field : fieldDtoList) {
                MetadataColumn column;
                if (field.getName() == null || (column = HeEnginePushUtil.getRelationShipField(ctx, field)) == null) continue;
                HeEnginePushUtil.getPm(dto.getPmList(), field, column, type);
            }
        }
        if (type != 1 && type != 6) {
            ArrayList<NodeBusinessPm> whereList = new ArrayList<NodeBusinessPm>();
            for (HeDataModelFieldDto field : fieldDtoList) {
                MetadataColumn column;
                if (!field.isKeyFlag() || (column = HeEnginePushUtil.getRelationShipField(ctx, field)) == null) continue;
                String parameterAlias = type == 4 ? "ids" : "id";
                parameterAlias = type == 2 ? field.getPropertyName() : parameterAlias;
                NodeBusinessPm id = HeEnginePushUtil.getNodeBusinessPm(parameterAlias, column);
                id.setOperatorType(type == 4 ? OperatorType.IN : OperatorType.EQ);
                id.setMatchType(MatchTypeEnum.AND);
                whereList.add(id);
                if (type == 2) continue;
                break;
            }
            dto.setWhere(whereList);
        }
        return dto;
    }

    public static MetadataColumn getRelationShipField(PushBackCtx ctx, HeDataModelFieldDto field) {
        String[] possibleFieldNames;
        Map columnMap = ctx.getColumnMap();
        String tableName = field.getTableName();
        String fieldName = field.getName();
        for (String possibleFieldName : possibleFieldNames = new String[]{tableName + "-" + fieldName, tableName.toLowerCase() + "-" + fieldName, tableName.toUpperCase() + "-" + fieldName}) {
            MetadataColumn column = (MetadataColumn)columnMap.get(possibleFieldName);
            if (column == null) continue;
            return column;
        }
        logger.error("\u5217{}\u672a\u627e\u5230\u5f15\u64ce\u5143\u6570\u636e\u5bf9\u5e94\u5217", (Object)field.getName());
        return null;
    }

    private static SingleTableDto getSingleTableDto(PushBackCtx ctx, String businessId, String methodName, String methodDesc) {
        HussarException.throwByNull((Object)methodName, (String)"\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        MsTableDto dto = ctx.isMs ? new MsTableDto() : new SingleTableDto();
        dto.setBusinessId(businessId);
        dto.setMethodName(methodName);
        dto.setMethodDesc(methodDesc);
        return dto;
    }

    public static MetadataColumn getMetadataColumn(Map<String, MetadataColumn> columnMap, String name) {
        MetadataColumn column = columnMap.get(name);
        if (column != null) {
            return column;
        }
        if (name.contains("-")) {
            String[] Names;
            String[] parts = name.split("-");
            String part1 = parts[0];
            String part2 = parts[1];
            for (String names : Names = new String[]{part1 + "-" + part2, part1.toLowerCase() + "-" + part2, part1.toUpperCase() + "-" + part2}) {
                column = columnMap.get(names);
                if (column == null) continue;
                return column;
            }
            logger.error("\u5217{}\u672a\u627e\u5230\u5f15\u64ce\u5143\u6570\u636e\u5bf9\u5e94\u5217", (Object)name);
        } else {
            logger.error("\u5217{}\u672a\u627e\u5230\u5f15\u64ce\u5143\u6570\u636e\u5bf9\u5e94\u5217", (Object)name);
        }
        return null;
    }

    private static void getPm(List<NodeBusinessPm> pmList, HeDataModelFieldDto field, MetadataColumn column, int type) {
        NodeBusinessPm pm = HeEnginePushUtil.getNodeBusinessPm(field.getPropertyName(), column);
        switch (type) {
            case 1: {
                pm.setParameterType(ParameterType.values);
                break;
            }
            case 2: {
                pm.setParameterType(ParameterType.set);
                pm.setOperatorType(OperatorType.EQ);
                break;
            }
            case 5: 
            case 6: {
                pm.setParameterType(ParameterType.column);
                break;
            }
        }
        pmList.add(pm);
    }

    public static NodeBusinessPm getNodeBusinessPm(String parameterAlias, MetadataColumn column) {
        NodeBusinessPm pm = new NodeBusinessPm();
        pm.setColumnId(column.getColumnId());
        pm.setParameterAlias(parameterAlias);
        return pm;
    }

    public static <T extends SingleTableDto> void push(PushBackCtx ctx, List<String> flowColumns, T dto, int type) {
        switch (type) {
            case 1: {
                configService.saveSingleTableService(dto, ctx);
                break;
            }
            case 2: {
                configService.saveMasterSlaveService((MsTableDto)dto, ctx);
                break;
            }
            case 3: {
                configService.saveFlowSingleTableService(flowColumns, dto, ctx);
                break;
            }
            case 4: {
                configService.saveFlowMasterSlaveService(flowColumns, (MsTableDto)dto, ctx);
                break;
            }
        }
    }

    public static void pushFlowVisitSelect(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        boolean isMs = engineCtx.isMs;
        EngineMethodEnum engineMethodEnum = engineCtx.isMs ? EngineMethodEnum.MS_TABLE_BPM_SELECT : EngineMethodEnum.SINGLE_TABLE_SELECT_ONE;
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, name, engineMethodEnum.value.getName(), engineMethodEnum.value.getDesc(), 5);
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static void pushFormQuery(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        boolean isMs = engineCtx.isMs;
        EngineMethodEnum engineMethod = isMs ? EngineMethodEnum.MS_TABLE_SELECT_ONE : EngineMethodEnum.SINGLE_TABLE_SELECT_ONE;
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, HeEnginePushUtil.getUrl("GET", name, dataModelBaseDTO), engineMethod.value.getName(), engineMethod.value.getDesc(), 5);
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static void getWhere(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> heBackCtx, Map<String, String> tableNameFiledName2ColumnName, List<NodeBusinessPm> whereList, Map<String, MetadataColumn> columnMap, List<HeQueryConditionField> fields, Long pId) {
        for (HeQueryConditionField field : fields) {
            NodeBusinessPm nodeBusinessPm;
            if ("row".equals(field.getType())) {
                if (ToolUtil.isEmpty(heBackCtx.getUseDataModelDtoMap())) {
                    logger.error("\u672a\u521d\u59cb\u5316\u53d1\u5e03\u4e0a\u4e0b\u6587\uff0c\u6a21\u578bmap\u4e3a\u7a7a");
                    continue;
                }
                HeDataModelBaseDTO heDataModelBaseDTO = heBackCtx.getUseDataModelDtoMap().get(field.getFromModelId());
                if (heDataModelBaseDTO == null) {
                    logger.error("\u6a21\u578bid\u672a\u627e\u5230");
                    continue;
                }
                List<HeDataModelFieldDto> heDataModelBaseFields = heDataModelBaseDTO.getFields();
                if (ToolUtil.isEmpty(heDataModelBaseFields)) {
                    logger.error("\u6a21\u578b\u672a\u627e\u5230\u5217");
                    continue;
                }
                String fromModelFieldName = field.getFromModelField();
                for (HeDataModelFieldDto heDataModelBaseField : heDataModelBaseFields) {
                    if (!heDataModelBaseField.getId().equals(field.getFromModelField()) && !heDataModelBaseField.getPropertyName().equals(field.getFromModelField())) continue;
                    fromModelFieldName = heDataModelBaseField.getName();
                }
                MetadataColumn column = HeEnginePushUtil.getMetadataColumn(columnMap, heDataModelBaseDTO.getSourceDataModelName() + "-" + fromModelFieldName);
                if (column == null) continue;
                nodeBusinessPm = HeEnginePushUtil.getNodeBusinessPm(field.getQueryAttrName(), column);
                nodeBusinessPm.setMatchType("and".equals(field.getConnect()) ? MatchTypeEnum.AND : MatchTypeEnum.OR);
                nodeBusinessPm.setOperatorType(HeExternalApiUtil.getOperatorType(field.getSymbol()));
                nodeBusinessPm.setParameterType(ParameterType.where);
                nodeBusinessPm.setParentId(pId);
                nodeBusinessPm.setDefaultValue(field.getVal());
                nodeBusinessPm.setConditionType(ConditionType.PRE);
                whereList.add(nodeBusinessPm);
                continue;
            }
            if (!"child".equals(field.getType()) || !HussarUtils.isNotEmpty(field.getChildren())) continue;
            nodeBusinessPm = new NodeBusinessPm();
            nodeBusinessPm.setMatchType("and".equals(field.getConnect()) ? MatchTypeEnum.AND : MatchTypeEnum.OR);
            Long id = LrEngineUtil.nextId();
            nodeBusinessPm.setParameterId(id);
            nodeBusinessPm.setParameterType(ParameterType.where);
            nodeBusinessPm.setParentId(pId);
            whereList.add(nodeBusinessPm);
            HeEnginePushUtil.getWhere(heBackCtx, tableNameFiledName2ColumnName, whereList, columnMap, field.getChildren(), id);
        }
    }

    public static void pushTableQuery(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getTableQueryDto(heBackCtx, operation, dataModelBase, engineCtx, dataModelBaseDTO, isMs);
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static void pushTotalCalculate(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getTotalCalculate(heBackCtx, operation, dataModelBase, engineCtx, dataModelBaseDTO, isMs);
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static SingleTableDto getTableQueryDto(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, boolean isMs) {
        String selectConditionStr = Optional.ofNullable(operation.getParams()).map(o -> o.get("selectCondition")).orElse(null);
        HeQueryCondition selectCondition = HussarUtils.isNotBlank((CharSequence)selectConditionStr) ? (HeQueryCondition)Optional.ofNullable(dataModelBase.getQuConBaseByName(selectConditionStr)).orElse(null) : null;
        String sortConditionStr = Optional.ofNullable(operation.getParams()).map(o -> o.get("sortCondition")).orElse(null);
        HeSortCondition sortCondition = HussarUtils.isNotBlank((CharSequence)sortConditionStr) ? (HeSortCondition)Optional.ofNullable(dataModelBase.getSortConBaseByName(sortConditionStr)).orElse(null) : null;
        boolean pagination = Optional.ofNullable((Boolean)operation.getParams().get("isPagination")).orElse(false);
        boolean msPage = Optional.ofNullable((Boolean)operation.getParams().get("isMsPage")).orElse(false);
        EngineMethodEnum engineMethod = isMs ? (pagination ? (msPage ? EngineMethodEnum.MS_TABLE_SELECT_MS_PAGE : EngineMethodEnum.MS_TABLE_SELECT_PAGE) : (operation.getName().equals(ECHART_QUERY) ? EngineMethodEnum.MS_TABLE_SELECT_EXPRESSION_LIST : EngineMethodEnum.MS_TABLE_SELECT_LIST)) : (pagination ? EngineMethodEnum.SINGLE_TABLE_SELECT_PAGE : (operation.getName().equals(ECHART_QUERY) ? EngineMethodEnum.SINGLE_TABLE_SELECT_EXPRESSION_LIST : EngineMethodEnum.SINGLE_TABLE_SELECT_LIST));
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, HeEnginePushUtil.getUrl("POST", operation.getName(), dataModelBaseDTO), engineMethod.value.getName(), engineMethod.value.getDesc(), 6);
        dto.setPagination(pagination);
        dto.setResultTypeList(true);
        Map columnMap = engineCtx.getColumnMap();
        dto.setWhere(new ArrayList());
        if (Optional.ofNullable(selectCondition).map(HeQueryCondition::getFields).isPresent()) {
            Map<String, String> tableNameFiledName2ColumnName = dataModelBaseDTO.getFields().stream().collect(Collectors.toMap(x -> x.getTableName() + "." + x.getPropertyName(), HeDataModelFieldDto::getName));
            HeEnginePushUtil.getWhere(heBackCtx, tableNameFiledName2ColumnName, dto.getWhereList(), columnMap, selectCondition.getFields(), null);
        }
        if (Optional.ofNullable(sortCondition).map(HeSortCondition::getFields).isPresent()) {
            for (HeSortConditionField sortField : sortCondition.getFields()) {
                String fromModelId = sortField.getFromModelIdSort();
                HeDataModelBaseDTO heDataModelBaseDTO = (HeDataModelBaseDTO)heBackCtx.getUseDataModelDtoMap().get(fromModelId);
                MetadataColumn column = HeEnginePushUtil.getMetadataColumn(columnMap, heDataModelBaseDTO.getSourceDataModelName() + "-" + sortField.getFromModelFieldSort());
                if (column == null) continue;
                dto.addSort(column.getColumnId(), sortField.getSortCondition().equals("asc") ? OrderByType.ASC : OrderByType.DESC);
            }
        }
        return dto;
    }

    private static SingleTableDto getTotalCalculate(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, boolean isMs) {
        String selectConditionStr = Optional.ofNullable(operation.getParams()).map(o -> o.get("selectCondition")).orElse(null);
        HeQueryCondition selectCondition = HussarUtils.isNotBlank((CharSequence)selectConditionStr) ? (HeQueryCondition)Optional.ofNullable(dataModelBase.getQuConBaseByName(selectConditionStr)).orElse(null) : null;
        EngineMethodEnum engineMethod = isMs ? EngineMethodEnum.MS_TABLE_SELECT_OBJ : EngineMethodEnum.SINGLE_TABLE_SELECT_OBJ;
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, HeEnginePushUtil.getUrl("POST", operation.getName(), dataModelBaseDTO), engineMethod.value.getName(), engineMethod.value.getDesc(), 6);
        Map columnMap = engineCtx.getColumnMap();
        dto.setWhere(new ArrayList());
        Optional.ofNullable(selectCondition).map(HeQueryCondition::getFields).ifPresent(fields -> {
            Map<String, String> tableNameFieldName2ColumnName = dataModelBaseDTO.getFields().stream().collect(Collectors.toMap(x -> x.getTableName() + "." + x.getPropertyName(), HeDataModelFieldDto::getName));
            HeEnginePushUtil.getWhere(heBackCtx, tableNameFieldName2ColumnName, dto.getWhereList(), columnMap, fields, null);
        });
        return dto;
    }

    public static void pushFormSave(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        EngineMethodEnum engineMethod = engineCtx.isMs ? EngineMethodEnum.MS_TABLE_SAVE_OR_UPDATE : EngineMethodEnum.SINGLE_TABLE_SAVE_OR_UPDATE;
        HeEnginePushUtil.pushFormSave(name, engineCtx, dataModelBaseDTO, engineMethod.value.getName(), engineMethod.value.getDesc(), null);
    }

    public static void pushFormIncrementSave(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        EngineMethodEnum engineMethod = EngineMethodEnum.MS_TABLE_INCREMENT_SAVE_OR_UPDATE;
        HeEnginePushUtil.pushFormIncrementSave(name, engineCtx, dataModelBaseDTO, engineMethod.value.getName(), engineMethod.value.getDesc(), null);
    }

    public static void pushEchartQuery(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        EngineMethodEnum engineMethod = engineCtx.isMs ? EngineMethodEnum.MS_TABLE_SELECT_EXPRESSION_LIST : EngineMethodEnum.SINGLE_TABLE_SELECT_EXPRESSION_LIST;
        HeEnginePushUtil.pushFormSave(name, engineCtx, dataModelBaseDTO, engineMethod.value.getName(), engineMethod.value.getDesc(), null);
    }

    public static void pushFormSave(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushPostMethod(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, 2);
    }

    public static void pushFormIncrementSave(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushPostMethod(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, 2);
    }

    public static void pushEchartQuery(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushPostMethod(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, 2);
    }

    public static void pushInsertSave(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushPostMethod(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, 1);
    }

    public static void pushDeleteIds(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        EngineMethodEnum engineMethod = engineCtx.isMs ? EngineMethodEnum.MS_TABLE_REMOVE : EngineMethodEnum.SINGLE_TABLE_REMOVE;
        HeEnginePushUtil.pushDeleteIds(name, engineCtx, dataModelBaseDTO, engineMethod.value.getName(), engineMethod.value.getDesc(), null);
    }

    public static void pushDeleteIds(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushPostMethod(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, 4);
    }

    public static void pushPostMethod(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns, int type) {
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getPushDto(dataModelBaseDTO.getFields(), engineCtx, HeEnginePushUtil.getUrl("POST", name, dataModelBaseDTO), methodName, methodDesc, type);
        if (flowColumns == null) {
            HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
        } else {
            HeEnginePushUtil.push(engineCtx, flowColumns, dto, !isMs ? 3 : 4);
        }
    }

    public static void pushDeleteId(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushPostMethod(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, 3);
    }

    public static void pushFlagDeleteIds(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        EngineMethodEnum engineMethod = engineCtx.isMs ? EngineMethodEnum.MS_TABLE_FLAG_REMOVE : EngineMethodEnum.SINGLE_TABLE_FLAG_REMOVE;
        HeEnginePushUtil.pushFlagDeleteIds(name, engineCtx, dataModelBaseDTO, engineMethod.value.getName(), engineMethod.value.getDesc(), null);
    }

    public static void pushFlagDeleteIds(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushFlagDel(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, "ids", OperatorType.IN);
    }

    public static void pushFlagDeleteId(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns) {
        HeEnginePushUtil.pushFlagDel(name, engineCtx, dataModelBaseDTO, methodName, methodDesc, flowColumns, "id", OperatorType.EQ);
    }

    private static void pushFlagDel(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO, String methodName, String methodDesc, List<String> flowColumns, String id, OperatorType eq) {
        boolean isMs = engineCtx.isMs;
        HeDataModelFieldDto keyField = null;
        HeDataModelFieldDto flgField = null;
        for (HeDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.isKeyFlag() && keyField == null) {
                keyField = field;
            }
            if (!field.isDelFlag() || flgField != null) continue;
            flgField = field;
        }
        HussarException.throwByNull(keyField, (String)"\u4e3b\u952e\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<HeDataModelFieldDto> fieldDtoList = new ArrayList<HeDataModelFieldDto>();
        fieldDtoList.add(keyField);
        if (HussarUtils.isNotEmpty(flgField)) {
            fieldDtoList.add(flgField);
        }
        SingleTableDto dto = HeEnginePushUtil.getPushDto(fieldDtoList, engineCtx, HeEnginePushUtil.getUrl("POST", name, dataModelBaseDTO), methodName, methodDesc, 2);
        dto.getPmList().remove(0);
        NodeBusinessPm where = (NodeBusinessPm)dto.getWhereList().get(0);
        where.setParameterAlias(id);
        where.setOperatorType(eq);
        if (flowColumns == null) {
            HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
        } else {
            HeEnginePushUtil.push(engineCtx, flowColumns, dto, !isMs ? 3 : 4);
        }
    }

    public static void pushDataDisplay(HeBackCtx heBackCtx, HeDataModelOperation operation, HeDataModelBase dataModelBase, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelBaseDTO) {
        MetadataColumn column;
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getTableQueryDto(heBackCtx, operation, dataModelBase, engineCtx, dataModelBaseDTO, isMs);
        dto.setMethodDesc(!isMs ? "\u5355\u8868\u6570\u636e\u5c55\u793a" : "\u4e3b\u5b50\u6a21\u578b\u6570\u636e\u5c55\u793a");
        String relateField = (String)operation.getParams().get("relateField");
        for (HeDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (!field.getPropertyName().equals(relateField)) continue;
            relateField = dataModelBaseDTO.getSourceDataModelName() + "-" + field.getName();
            break;
        }
        if ((column = HeEnginePushUtil.getMetadataColumn(engineCtx.getColumnMap(), relateField)) != null) {
            NodeBusinessPm nodeBusinessPm = HeEnginePushUtil.getNodeBusinessPm("inValues", column);
            nodeBusinessPm.setMatchType(MatchTypeEnum.AND);
            nodeBusinessPm.setOperatorType(OperatorType.IN);
            nodeBusinessPm.setParameterType(ParameterType.where);
            dto.getWhereList().add(nodeBusinessPm);
        }
        HeEnginePushUtil.push(engineCtx, null, dto, !isMs ? 1 : 2);
    }

    public static void pushFlowNoBusiness(String name, PushBackCtx engineCtx, HeDataModelBaseDTO dataModelDto, String methodName, String methodDesc, List<String> flowColumns) {
        boolean isMs = engineCtx.isMs;
        SingleTableDto dto = HeEnginePushUtil.getSingleTableDto(engineCtx, HeEnginePushUtil.getUrl("POST", name, dataModelDto), methodName, methodDesc);
        HeEnginePushUtil.push(engineCtx, flowColumns, dto, !isMs ? 3 : 4);
    }

    public static String getUrl(String getOrPost, String name, HeDataModelBaseDTO dataModelBaseDTO) {
        return String.format("%s %s", getOrPost, FileUtil.posixPath((String[])new String[]{File.separator, AppContextUtil.getServiceID(), dataModelBaseDTO.getTablePath(), name}));
    }

    public static String getNoConcatServiceIDUrl(String getOrPost, String name, HeDataModelBaseDTO dataModelBaseDTO) {
        return String.format("%s %s", getOrPost, ((PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class)).javaPathService().getNoConcatServiceID(File.separator, new String[]{dataModelBaseDTO.getTablePath(), name}));
    }

    public static void pushApi(PushBackCtx ctx) {
        configService.pushApi(ctx);
    }

    public static PushBackCtx getEngineCtx(HeDataModelBase dataModelBase) {
        return dataModelBase.getPushBackCtx();
    }

    public static PushBackCtx getEngineCtxById(HeDataModelBase dataModelBase) {
        return dataModelBase.getPushBackCtxById();
    }

    private static TableInfoDto getTableByName(String tableName) {
        return HeExternalApiUtil.getTableByName(tableName, true);
    }

    private static ModelTableMappingDTO getTableById(String id) {
        return modelRelateService.getModelTableMapping(id);
    }

    private static ModelTableMappingDTO getRelationById(String id) {
        return modelRelateService.getModelTableMapping(id);
    }

    public static ApiNamingDto initApiNaming(String businessId) {
        ApiNamingDto apiNamingDto = new ApiNamingDto();
        apiNamingDto.setBusinessId(businessId);
        apiNamingDto.setBusinessType("HTTP");
        String nodeName = businessId.replace(" ", "").replace("/", ".").replace(":", "").replace("-", ".");
        apiNamingDto.setServiceName(nodeName);
        return apiNamingDto;
    }

    public static NodeBusiness initNodeBusiness(ModelTableMappingDTO tableMappingDTO, String businessId, String unique, ApiNamingDto apiNamingDto, List<JSONObject> columnList, NodeTypeEnum nodeType) {
        NodeBusiness nodeBusiness = new NodeBusiness();
        nodeBusiness.setNodeId(EngineUtil.getId());
        nodeBusiness.setModelId(tableMappingDTO.getRelatedId());
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)businessId), (String)"URL\u4e0d\u80fd\u4e3a\u7a7a");
        String methodName = "asyncverify";
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)methodName), (String)"\u65b9\u6cd5\u672a\u627e\u5230");
        String uniqueCode = unique + methodName;
        nodeBusiness.setNodeName(apiNamingDto.getServiceName());
        nodeBusiness.setNodeType(nodeType.getValue());
        nodeBusiness.setNodeDec("\u5f02\u6b65\u6821\u9a8c");
        nodeBusiness.setDataServiceCode(uniqueCode);
        nodeBusiness.setNodeClass(tableMappingDTO.getParamName());
        nodeBusiness.setActionName(methodName);
        nodeBusiness.setJsonParams(JSONObject.toJSONString(columnList));
        nodeBusiness.setDataServiceActionName(ModelTypeRelationHolder.getInstance().getProviderByType(nodeType));
        return nodeBusiness;
    }

    public static List<JSONObject> initSingleTableColumnList(HeBaseDataModel useDataModelBase, HeDataModelOperation dataModelOperation, PushBackCtx engineCtx) {
        ArrayList<JSONObject> columnList = new ArrayList<JSONObject>();
        List<HeDataModelField> fieldList = useDataModelBase.getFields();
        for (HeDataModelField field : fieldList) {
            if (!ToolUtil.isNotEmpty((Object)((Object)field)) || !field.isChkUnique()) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("columnName", (Object)field.getName());
            ArrayList<JSONObject> rulesList = new ArrayList<JSONObject>();
            JSONObject obj = new JSONObject();
            obj.put("type", (Object)"unique");
            HeDataModelFieldDto dto = new HeDataModelFieldDto();
            dto.setTableName(useDataModelBase.getSourceDataModelName());
            dto.setName(field.getSourceFieldName());
            MetadataColumn relationShipField = HeEnginePushUtil.getRelationShipField(engineCtx, dto);
            if (relationShipField != null) {
                obj.put("columnId", (Object)relationShipField.getColumnId());
                obj.put("errorMsg", (Object)(field.getName() + "\u5217\u552f\u4e00\u503c\u6821\u9a8c\u672a\u901a\u8fc7"));
            }
            Map<String, Object> params = dataModelOperation.getParams();
            List asyncVerifyParams = (List)params.get("asyncVerifyParams");
            for (JSONObject asyncVerifyParam : asyncVerifyParams) {
                if (!ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"columnId")) || !asyncVerifyParam.get((Object)"columnId").equals(field.getId()) || !ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"rules"))) continue;
                List paramRules = (List)asyncVerifyParam.get((Object)"rules");
                for (JSONObject paramRule : paramRules) {
                    if (!ToolUtil.isNotEmpty((Object)paramRule) || !ToolUtil.isNotEmpty((Object)paramRule.get((Object)"ruleType")) || !"unique".equals(paramRule.get((Object)"ruleType"))) continue;
                    obj.put("errorMsg", paramRule.get((Object)"errorMsg"));
                }
            }
            rulesList.add(obj);
            jsonObject.put("rules", rulesList);
            columnList.add(jsonObject);
        }
        return columnList;
    }

    public static List<JSONObject> initMsTableColumnList(HeMSDataModel useDataModelBase, HeDataModelOperation dataModelOperation, PushBackCtx engineCtx) {
        ArrayList<JSONObject> columnList = new ArrayList<JSONObject>();
        ArrayList<HeBaseDataModel> allModel = new ArrayList<HeBaseDataModel>();
        allModel.add((HeBaseDataModel)useDataModelBase.getMasterTable());
        List<HeDataModelBase> slaveTables = useDataModelBase.getSlaveTables();
        for (HeRelationshipBase relationship : useDataModelBase.getRelationships()) {
            if (!"association".equals(relationship.getRelateModelType())) continue;
            for (HeDataModelBase slaveTable : slaveTables) {
                if (!slaveTable.getId().equals(relationship.getSlaveTableId())) continue;
                allModel.add((HeBaseDataModel)slaveTable);
            }
        }
        for (HeBaseDataModel heDataModelBase : allModel) {
            List<HeDataModelField> modelTableFields = heDataModelBase.getFields();
            for (HeDataModelField modelTableField : modelTableFields) {
                if (!ToolUtil.isNotEmpty((Object)((Object)modelTableField)) || !modelTableField.isChkUnique()) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("columnName", (Object)modelTableField.getName());
                ArrayList<JSONObject> rulesList = new ArrayList<JSONObject>();
                if (modelTableField.isChkUnique()) {
                    JSONObject obj = new JSONObject();
                    obj.put("type", (Object)"unique");
                    HeDataModelFieldDto dto = new HeDataModelFieldDto();
                    dto.setTableName(heDataModelBase.getSourceDataModelName());
                    dto.setName(modelTableField.getSourceFieldName());
                    MetadataColumn relationShipField = HeEnginePushUtil.getRelationShipField(engineCtx, dto);
                    if (relationShipField != null) {
                        obj.put("columnId", (Object)relationShipField.getColumnId());
                        obj.put("errorMsg", (Object)(modelTableField.getName() + "\u5217\u552f\u4e00\u503c\u6821\u9a8c\u672a\u901a\u8fc7"));
                    }
                    ModelTableMappingDTO s = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(heDataModelBase.getId());
                    obj.put("modelId", (Object)s.getRelatedId());
                    Map<String, Object> params = dataModelOperation.getParams();
                    List asyncVerifyParams = (List)params.get("asyncVerifyParams");
                    for (JSONObject asyncVerifyParam : asyncVerifyParams) {
                        if (!ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"columnId")) || !asyncVerifyParam.get((Object)"columnId").equals(modelTableField.getId()) || !ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"rules"))) continue;
                        List paramRules = (List)asyncVerifyParam.get((Object)"rules");
                        for (JSONObject paramRule : paramRules) {
                            if (!ToolUtil.isNotEmpty((Object)paramRule) || !ToolUtil.isNotEmpty((Object)paramRule.get((Object)"ruleType")) || !"unique".equals(paramRule.get((Object)"ruleType"))) continue;
                            obj.put("errorMsg", paramRule.get((Object)"errorMsg"));
                        }
                    }
                    rulesList.add(obj);
                }
                jsonObject.put("rules", rulesList);
                columnList.add(jsonObject);
            }
        }
        return columnList;
    }
}

