/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.util;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.utils.LrEngineUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.dto.ModelSyncDto;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HEOperationUtil {
    private HEOperationUtil() {
    }

    public static ModelPublishDTO ModelToEngine(HeDataModelBase dataModelBase) {
        TableInfoDto tableInfo = dataModelBase.getTableInfo();
        if (HussarUtils.isEmpty((Object)tableInfo)) {
            tableInfo = HeExternalApiUtil.getTableByTableId(dataModelBase.getTableId(), false);
            dataModelBase.setTableInfo(tableInfo);
        }
        ModelPublishDTO mpdto = new ModelPublishDTO();
        mpdto.setRelatedId(Long.valueOf(LrEngineUtil.nextId()));
        mpdto.setTfmodelId(dataModelBase.getId());
        mpdto.setTfmodelName(dataModelBase.getName());
        mpdto.setParamName(dataModelBase.getName());
        mpdto.setTableId(tableInfo.getTableId());
        mpdto.setParentPath("0");
        ArrayList modelColumnsList = new ArrayList();
        List metaColumnList = tableInfo.getColumnList();
        Map<String, Long> columnName2Id = metaColumnList.stream().collect(Collectors.toMap(MetadataColumn::getColumnName, MetadataColumn::getColumnId));
        List<HeDataModelField> fields = dataModelBase.getFields();
        fields.forEach(field -> {
            ModelColumns modelColumns = new ModelColumns();
            modelColumnsList.add(modelColumns);
            modelColumns.setColumnId((Long)columnName2Id.get(field.getSourceFieldName()));
            modelColumns.setColumnName(field.getSourceFieldName());
            modelColumns.setColumnAlias(field.getName());
            modelColumns.setTfmodelColumnId(field.getId());
            modelColumns.setTfmodelId(dataModelBase.getId());
        });
        mpdto.setModelColumns(modelColumnsList);
        return mpdto;
    }

    public static ModelPublishDTO ModelToEngineById(HeDataModelBase dataModelBase) {
        TableInfoDto tableInfo = HeExternalApiUtil.getTableByTableId(dataModelBase.getTableId(), false);
        ModelPublishDTO mpdto = new ModelPublishDTO();
        mpdto.setRelatedId(Long.valueOf(LrEngineUtil.nextId()));
        mpdto.setTfmodelId(dataModelBase.getId());
        mpdto.setTfmodelName(dataModelBase.getName());
        mpdto.setParamName(dataModelBase.getName());
        mpdto.setTableId(tableInfo.getTableId());
        mpdto.setParentPath("0");
        ArrayList modelColumnsList = new ArrayList();
        List metaColumnList = tableInfo.getColumnList();
        Map<String, Long> columnName2Id = metaColumnList.stream().collect(Collectors.toMap(MetadataColumn::getColumnName, MetadataColumn::getColumnId));
        List<HeDataModelField> fields = dataModelBase.getFields();
        fields.forEach(field -> {
            ModelColumns modelColumns = new ModelColumns();
            modelColumnsList.add(modelColumns);
            modelColumns.setColumnId((Long)columnName2Id.get(field.getSourceFieldName()));
            modelColumns.setColumnName(field.getSourceFieldName());
            modelColumns.setColumnAlias(field.getName());
            modelColumns.setTfmodelColumnId(field.getId());
            modelColumns.setTfmodelId(dataModelBase.getId());
        });
        mpdto.setModelColumns(modelColumnsList);
        return mpdto;
    }

    public static ModelSyncDto conversionFunction(HeDataModelBase dataModel, String path, String type) {
        ModelSyncDto modelSyncDto = new ModelSyncDto();
        modelSyncDto.setModelPath(path);
        modelSyncDto.setTfModelId(dataModel.getId());
        modelSyncDto.setNodeType(TypeConversionEnum.getValueByKey(type));
        modelSyncDto.setTableName(dataModel.getSourceDataModelName());
        modelSyncDto.setParamName(dataModel.getName());
        ArrayList<ModelSyncDto.ModelSyncColumn> columnList = new ArrayList<ModelSyncDto.ModelSyncColumn>();
        List<HeDataModelField> fields = dataModel.getFields();
        for (HeDataModelField field : fields) {
            ModelSyncDto.ModelSyncColumn modelSyncColumn = new ModelSyncDto.ModelSyncColumn();
            modelSyncColumn.setTfColumnId(field.getId());
            modelSyncColumn.setColumnAlias(field.getName());
            columnList.add(modelSyncColumn);
        }
        modelSyncDto.setColumns(columnList);
        return modelSyncDto;
    }

    public static String getRealPath(String path) {
        StringBuffer pathBuffer = new StringBuffer(path);
        pathBuffer.insert(0, '/');
        pathBuffer.append(".dbd");
        int index = pathBuffer.indexOf(".");
        pathBuffer.setCharAt(index, '/');
        return pathBuffer.toString();
    }
}

