/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.FormDesignEngineExceptionEnum;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.element.base.HeBaseDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationDTO;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.service.HeModelPublishService;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HETaskDataModel
extends HeBaseDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(HETaskDataModel.class);
    public static final String FUNCTION_TYPE = "TASK";
    public static final String FUNCTION_TYPE_KEY = "functionType";
    private HeBaseDataModel task;
    private HeDataModelBase businessTable;
    private HeRelationshipBase relationship;

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)String.format("%s%s", "HE.", FUNCTION_TYPE), HETaskDataModel.class);
    }

    @Override
    public HETaskDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HETaskDataModel dataModel;
        try {
            dataModel = (HETaskDataModel)JSON.parseObject((String)jsonObject.toString(), HETaskDataModel.class);
            JSONArray relationships = (JSONArray)jsonObject.get((Object)"relationships");
            dataModel.setRelationship((HeRelationshipBase)JSON.parseObject((String)relationships.get(0).toString(), HeRelationshipBase.class));
            HeBaseDataModel businessModel = new HeBaseDataModel().parseDataModel(jsonObject);
            businessModel.setModelPath(dataModel.getModelPath());
            businessModel.setFunctionType("BASE");
            dataModel.setBusinessTable(businessModel);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, FormDesignEngineExceptionEnum.PARSING_OBJECT_FAILED.getMessage());
        }
        return dataModel;
    }

    public HeBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(HeBaseDataModel task) {
        this.task = task;
    }

    public HeRelationshipBase getRelationship() {
        return this.relationship;
    }

    public void setRelationship(HeRelationshipBase relationship) {
        this.relationship = relationship;
    }

    @Override
    public void sync() throws IOException, LcdpException {
        this.taskMetaDataSync();
        this.metaDataSync();
        this.syncModel(FUNCTION_TYPE);
    }

    @Override
    public void syncById() throws IOException, LcdpException {
        this.taskMetaDataSyncById();
        this.metaDataSyncById();
        this.syncModelById(FUNCTION_TYPE);
    }

    @Override
    public void syncModel(String functionType) {
        ModelPublishDTO masterTableInfo = HEOperationUtil.ModelToEngine(this.task);
        masterTableInfo.setType(TypeConversionEnum.getValueByKey(functionType).getValue());
        HeRelationDTO relationDTO = HEDataModelUtil.slaveRelationSync(masterTableInfo, this.task, Collections.singletonList(this), Collections.singletonList(this.relationship), functionType);
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        resultList.add(relationDTO.getMasterPublishDTO());
        resultList.addAll(relationDTO.getSlavePublishDTO());
        ((ModelRelateService)SpringUtil.getBean(ModelRelateService.class)).save(resultList);
    }

    @Override
    public void syncModelById(String functionType) {
        ModelPublishDTO masterTableInfo = HEOperationUtil.ModelToEngineById(this.task);
        masterTableInfo.setType(TypeConversionEnum.getValueByKey(functionType).getValue());
        HeRelationDTO relationDTO = HEDataModelUtil.slaveRelationSyncById(masterTableInfo, this.task, Collections.singletonList(this), Collections.singletonList(this.relationship), functionType);
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        resultList.add(relationDTO.getMasterPublishDTO());
        resultList.addAll(relationDTO.getSlavePublishDTO());
        ((ModelRelateService)SpringUtil.getBean(ModelRelateService.class)).save(resultList);
    }

    @Override
    public void delete(String modelId) throws LcdpException {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(this.task.getId());
        super.delete(modelId);
    }

    @Override
    public void delete() {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(this.task.getId());
        super.delete();
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        return super.updateTable(fieldsContrastParam) != false && this.task.updateTable(fieldsContrastParam) != false;
    }

    public Long getMasterId() {
        ModelTableMappingDTO tableInfo = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(this.task.getId());
        return tableInfo.getRelatedId();
    }

    public Long getBusinessId() {
        ModelTableMappingDTO tableInfo = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(this.getId());
        return tableInfo.getRelatedId();
    }

    @Override
    public List<String> getSourceDataModelNames() {
        ArrayList<String> tableName = new ArrayList<String>();
        tableName.add(this.task.getSourceDataModelName());
        tableName.add(this.getSourceDataModelName());
        return tableName;
    }

    @Override
    public List<Long> getTableIds() {
        ArrayList<Long> tableIds = new ArrayList<Long>();
        tableIds.add(this.task.getTableId());
        tableIds.add(this.getTableId());
        return tableIds;
    }

    @Override
    public List<String> getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.task.getId());
        ids.add(this.getId());
        return ids;
    }

    @Override
    public Map<String, MetadataColumn> getColumnMap() {
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        for (String name : this.getSourceDataModelNames()) {
            TableInfoDto tableInfo = HeExternalApiUtil.getTableByName(name, true);
            if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
            for (MetadataColumn column : tableInfo.getColumnList()) {
                if (ToolUtil.isNotEmpty((Object)name) && name.equals(this.task.getSourceDataModelName())) {
                    column = this.handleTaskColumnUsage(column);
                }
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    public HeDataModelBase getBusinessTable() {
        return this.businessTable;
    }

    public void setBusinessTable(HeDataModelBase businessTable) {
        this.businessTable = businessTable;
    }

    private MetadataColumn handleTaskColumnUsage(MetadataColumn column) {
        if (ToolUtil.isNotEmpty((Object)column) && ToolUtil.isNotEmpty((Object)column.getColumnAlias())) {
            switch (column.getColumnAlias()) {
                case "assignee": {
                    column.setPurpose("assignee");
                    break;
                }
                case "taskId": {
                    column.setPurpose("taskId");
                    break;
                }
                case "taskCreateTime": {
                    column.setPurpose("taskCreateTime");
                    break;
                }
                case "endTime": {
                    column.setPurpose("endTime");
                    break;
                }
                case "taskType": {
                    column.setPurpose("taskType");
                    break;
                }
                case "taskState": {
                    column.setPurpose("taskState");
                    break;
                }
                case "taskDefKey": {
                    column.setPurpose("taskDefinitionKey");
                    break;
                }
                case "taskDefName": {
                    column.setPurpose("taskDefinitionName");
                    break;
                }
                case "formKey": {
                    column.setPurpose("formKey");
                    break;
                }
                case "formDetailKey": {
                    column.setPurpose("formDetailKey");
                    break;
                }
                case "dueTime": {
                    column.setPurpose("dueTime");
                    break;
                }
                default: {
                    return column;
                }
            }
        }
        return column;
    }

    @Override
    public PushBackCtx getPushBackCtx() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ModelTableMappingDTO modelTableMapping = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(this.getId());
        ctx.setModelId(modelTableMapping.getRelatedId());
        ctx.setModelName(modelName);
        ctx.setColumnMap(this.getColumnMap());
        ctx.isMs = false;
        ctx.build();
        return ctx;
    }

    @Override
    public String strategy() {
        return "HUSSAR_ENGINE";
    }

    @Override
    public void initMasterSlave(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx) {
        HeModelPublishService publishService = (HeModelPublishService)SpringUtil.getBean(HeModelPublishService.class);
        HashMap<String, HeDataModelBase> baseMap = new HashMap<String, HeDataModelBase>(2);
        HashMap<String, HeDataModelBaseDTO> useDtoMap = new HashMap<String, HeDataModelBaseDTO>(2);
        HashMap<String, HeDataModelBaseDTO> dtoMap = new HashMap<String, HeDataModelBaseDTO>(2);
        HeBaseDataModel masterTable = this.task;
        HeDataModelBaseDTO taskMasterDto = publishService.enclosure(masterTable);
        baseMap.put(masterTable.getId(), masterTable);
        useDtoMap.put(masterTable.getId(), taskMasterDto);
        HeDataModelBaseDTO businessDto = publishService.enclosure(this);
        baseMap.put(this.getId(), this);
        useDtoMap.put(this.getId(), businessDto);
        HeDataModelBaseDTO taskDto = publishService.enclosure(this);
        taskDto.getFields().addAll(taskMasterDto.getFields());
        dtoMap.put(this.getId(), taskDto);
        backCtx.setDataModelBaseMap(baseMap);
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setTaskDtoMap(dtoMap);
    }

    public void taskMetaDataSync() throws IOException, LcdpException {
        MetadataParam param = HETaskDataModel.dealInfo(this.task);
        TableInfoDto tableInfoByTableName = HeExternalApiUtil.getTableByName(this.task.getSourceDataModelName(), false);
        if (tableInfoByTableName == null) {
            HeExternalApiUtil.insertTableInfo(param);
        } else {
            Long tableId = tableInfoByTableName.getTableId();
            param.getTableInfo().setTableId(tableId);
            HeExternalApiUtil.updateTableInfo(param);
        }
    }

    public void taskMetaDataSyncById() {
        MetadataParam param = HETaskDataModel.dealInfo(this.task);
        TableInfoDto tableInfo = HeExternalApiUtil.getTableInfoById(this.task.getId(), false);
        if (tableInfo == null) {
            HeExternalApiUtil.insertTableInfo(param);
        } else {
            Long tableId = tableInfo.getTableId();
            param.getTableInfo().setTableId(tableId);
            HeExternalApiUtil.updateTableInfo(param);
        }
        this.task.setTableId(param.getTableInfo().getTableId());
    }

    public static MetadataParam dealInfo(HeBaseDataModel dataModel) {
        MetadataParam param = new MetadataParam();
        TableInfoDto tableInfo = new TableInfoDto();
        tableInfo.setTableName(dataModel.getSourceDataModelName());
        tableInfo.setTableAlias(dataModel.getName());
        tableInfo.setTableDec(dataModel.getTableDesc());
        tableInfo.setPollName(dataModel.getDataSourceName());
        SysDataSource datasource = HeExternalApiUtil.getDataSourceName(dataModel.getDataSourceName());
        tableInfo.setDatasourceId(datasource.getId());
        param.setTableInfo(tableInfo);
        ArrayList<ColumnInfoDto> columnInfo = new ArrayList<ColumnInfoDto>();
        HETaskDataModel.dealColumn(columnInfo, dataModel.getFields());
        param.setColumnInfo(columnInfo);
        param.setTfModelId(dataModel.getId());
        return param;
    }

    private static void dealColumn(List<ColumnInfoDto> columnInfo, List<HeDataModelField> fields) {
        if (HussarUtils.isEmpty(fields)) {
            return;
        }
        for (HeDataModelField field : fields) {
            ColumnInfoDto column = new ColumnInfoDto();
            column.setColumnName(field.getSourceFieldName());
            column.setColumnAlias(field.getName());
            column.setColumnComment(field.getComment());
            column.setDataType(field.getSourceDataType());
            column.setDataDot(field.getDataDot());
            column.setDataLength(Long.valueOf(field.getDataLength()));
            column.setDataIsEmpty(Integer.valueOf(field.getDataIsEmpty() ? 1 : 0));
            column.setTfModelColumnId(field.getId());
            if (ToolUtil.isNotEmpty((Object)field.getUsage())) {
                if ("primary".equals(field.getUsage())) {
                    column.setPrimarys("1");
                }
                column.setPurpose(field.getUsage());
            } else {
                String s = HETaskDataModel.taskUsageField(field);
                if (ToolUtil.isNotEmpty((Object)s)) {
                    column.setPurpose(s);
                }
            }
            Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType());
            if (engineColumnType.isPresent()) {
                column.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                column.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
            }
            columnInfo.add(column);
        }
    }

    private static String taskUsageField(HeDataModelField field) {
        String name = field.getUsage();
        if (ToolUtil.isNotEmpty((Object)((Object)field)) && ToolUtil.isNotEmpty((Object)field.getName())) {
            switch (field.getName()) {
                case "assignee": 
                case "taskId": 
                case "endTime": 
                case "taskType": 
                case "taskState": 
                case "formKey": 
                case "formDetailKey": 
                case "dueTime": 
                case "taskCreateTime": {
                    name = field.getName();
                    break;
                }
                case "taskDefKey": {
                    name = "taskDefinitionKey";
                    break;
                }
                case "taskDefName": {
                    name = "taskDefinitionName";
                    break;
                }
            }
        }
        return name;
    }

    @Override
    public void customOption(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HEModelBeanUtil.getCustomOperationBean("HUSSAR_ENGINE", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx, engineCtx);
    }
}

