/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.flow;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.FormDesignEngineExceptionEnum;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.element.flow.HeFlowDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.HeMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HeFlowMSDataModel
extends HeFlowDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(HeFlowMSDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW_MASTER_SLAVE";

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HE.FLOW_MASTER_SLAVE", HeFlowMSDataModel.class);
    }

    @Override
    public HeFlowMSDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HeFlowMSDataModel dataModel;
        try {
            dataModel = (HeFlowMSDataModel)JSONObject.parseObject((String)jsonObject.toString(), HeFlowMSDataModel.class);
            jsonObject.put("functionType", (Object)"MASTER_SLAVE");
            HeMSDataModel businessModel = new HeMSDataModel().parseDataModel(jsonObject);
            dataModel.setFields(businessModel.getFields());
            businessModel.setModelPath(dataModel.getModelPath());
            for (HeDataModelOperation operation : dataModel.getOperations()) {
                if (!list.contains(operation.getType())) continue;
                operation.setFlowBusiness(true);
            }
            dataModel.setBusinessTable(businessModel);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, FormDesignEngineExceptionEnum.PARSING_OBJECT_FAILED.getMessage());
        }
        return dataModel;
    }

    @Override
    public String getFunctionType() {
        return "FLOW";
    }

    public String getRealFunctionType() {
        return FUNCTION_TYPE;
    }

    @Override
    public void syncModel(String functionType) throws IOException, LcdpException {
        functionType = FUNCTION_TYPE;
        super.syncModel(functionType);
    }

    @Override
    public void delete(String modelId) throws LcdpException {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        JSONObject modelJson = DataModelUtil.getDataModelJson((String)modelId);
        HeFlowMSDataModel heFlowMSDataModel = this.parseDataModel(modelJson);
        modelId = ((HeMSDataModel)heFlowMSDataModel.getBusinessTable()).getMasterTable().getId();
        super.delete(modelId);
    }

    @Override
    public void delete() {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        String modelId = ((HeMSDataModel)this.getBusinessTable()).getMasterTable().getId();
        modelRelateService.delete(modelId);
    }

    public ModelTableMappingDTO getRelationById(String id) {
        HeMSDataModel businessTable = (HeMSDataModel)this.getBusinessTable();
        return ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(ToolUtil.isNotEmpty((Object)id) ? id : businessTable.getMasterTable().getId());
    }

    @Override
    public List<String> getSourceDataModelNames() {
        ArrayList<String> tableName = new ArrayList<String>();
        HeMSDataModel businessTable = (HeMSDataModel)this.getBusinessTable();
        List slaveTableNames = businessTable.getSlaveTables().stream().map(HeDataModelBase::getSourceDataModelName).collect(Collectors.toList());
        tableName.add(businessTable.getMasterTable().getSourceDataModelName());
        tableName.addAll(slaveTableNames);
        return tableName;
    }

    @Override
    public List<Long> getTableIds() {
        ArrayList<Long> tableIds = new ArrayList<Long>();
        HeMSDataModel businessTable = (HeMSDataModel)this.getBusinessTable();
        List slaveTableIds = businessTable.getSlaveTables().stream().map(DataModelBase::getTableId).collect(Collectors.toList());
        tableIds.add(businessTable.getMasterTable().getTableId());
        tableIds.addAll(slaveTableIds);
        return tableIds;
    }

    @Override
    public List<String> getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        HeMSDataModel businessTable = (HeMSDataModel)this.getBusinessTable();
        List slaveIds = businessTable.getSlaveTables().stream().map(DataModelBase::getId).collect(Collectors.toList());
        ids.add(businessTable.getMasterTable().getId());
        ids.addAll(slaveIds);
        return ids;
    }

    @Override
    public Map<String, MetadataColumn> getColumnMap() {
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        for (String name : this.getSourceDataModelNames()) {
            TableInfoDto tableInfo = HeExternalApiUtil.getTableByName(name, true);
            if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
            for (MetadataColumn column : tableInfo.getColumnList()) {
                columnMap.putIfAbsent(column.getColumnName(), column);
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    @Override
    public PushBackCtx getPushBackCtx() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ctx.setModelName(modelName);
        ctx.setModelId(this.getRelationById("").getRelatedId());
        ctx.setColumnMap(this.getColumnMap());
        ctx.isMs = true;
        ctx.build();
        return ctx;
    }

    @Override
    public String strategy() {
        return "HUSSAR_ENGINE";
    }

    @Override
    public void initMasterSlave(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx) {
        HeMSDataModel useDataModelBase = (HeMSDataModel)this.getBusinessTable();
        useDataModelBase.initMasterSlave(backCtx);
    }
}

