/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.customOption.task;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeCustomOperation;
import com.jxdinfo.hussar.formdesign.engine.function.element.base.HeBaseDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.task.HETaskDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.enums.EngineMethodEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusinessPm;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HUSSAR_ENGINETASKCUSTOM_OPTION")
public class HeTaskCustomOption
implements HeCustomOperation<HETaskDataModel, HeDataModelBaseDTO> {
    public static final String CUSTOM_OPTION = "HUSSAR_ENGINETASKCUSTOM_OPTION";
    private static Logger logger = LoggerFactory.getLogger(HeEnginePushUtil.class);

    @Override
    public void publishCustomOption(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        this.publishTaskDataBackFill(backCtx, engineCtx);
    }

    private void publishTaskDataBackFill(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        if (ToolUtil.isEmpty((Object)backCtx.getParams()) || ToolUtil.isEmpty(backCtx.getParams().get("identity"))) {
            return;
        }
        this.publishBusinessMethods(backCtx, engineCtx);
        this.publishTaskMethods(backCtx, engineCtx);
    }

    private void publishBusinessMethods(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HETaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        PushBackCtx businessCtx = new PushBackCtx();
        ModelTableMappingDTO modelTableMapping = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(useDataModelBase.getId());
        businessCtx.setModelId(modelTableMapping.getRelatedId());
        businessCtx.setModelName(useDataModelBase.getName());
        businessCtx.setColumnMap(engineCtx.getColumnMap());
        businessCtx.isMs = false;
        businessCtx.build();
        this.publishBusinessUpdate(backCtx, businessCtx);
        if (HussarUtils.isNotEmpty((Object)businessCtx)) {
            HeEnginePushUtil.pushApi(businessCtx);
        }
    }

    private void publishBusinessUpdate(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HETaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        HeDataModelBaseDTO businessDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        SingleTableDto singleTableDto = new SingleTableDto();
        singleTableDto.setBusinessCode(backCtx.getParams().get("identity").toString());
        singleTableDto.setBusinessId(String.format("%s %s", "POST", FileUtil.posixPath((String[])new String[]{singleTableDto.getBusinessCode(), businessDTO.getTablePath(), "update"})));
        EngineMethodEnum engineMethod = EngineMethodEnum.SINGLE_TABLE_UPDATE;
        singleTableDto.setMethodDesc(engineMethod.value.getDesc());
        singleTableDto.setMethodName(engineMethod.value.getName());
        singleTableDto.setPmList(new ArrayList());
        ArrayList<NodeBusinessPm> whereList = new ArrayList<NodeBusinessPm>();
        List<HeDataModelFieldDto> fields = businessDTO.getFields();
        for (HeDataModelFieldDto field : fields) {
            MetadataColumn column = HeTaskCustomOption.getRelationShipField(engineCtx, field);
            if (field.getName() == null || column == null) continue;
            if (!field.isKeyFlag()) {
                NodeBusinessPm pm = HeTaskCustomOption.getNodeBusinessPm(field.getPropertyName(), column);
                pm.setParameterType(ParameterType.set);
                pm.setOperatorType(OperatorType.EQ);
                singleTableDto.getPmList().add(pm);
            }
            if (!field.isKeyFlag()) continue;
            String parameterAlias = field.getPropertyName();
            NodeBusinessPm wherePm = HeTaskCustomOption.getNodeBusinessPm(parameterAlias, column);
            wherePm.setOperatorType(OperatorType.IN);
            wherePm.setMatchType(MatchTypeEnum.AND);
            whereList.add(wherePm);
        }
        singleTableDto.setWhere(whereList);
        HeEnginePushUtil.push(engineCtx, null, singleTableDto, 1);
    }

    private void publishTaskMethods(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HETaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        HeBaseDataModel taskModel = useDataModelBase.getTask();
        String modelName = taskModel.getName();
        PushBackCtx taskCtx = new PushBackCtx();
        ModelTableMappingDTO modelTableMapping = ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(taskModel.getId());
        taskCtx.setModelId(modelTableMapping.getRelatedId());
        taskCtx.setModelName(modelName);
        taskCtx.setColumnMap(engineCtx.getColumnMap());
        taskCtx.isMs = false;
        taskCtx.build();
        this.pushTaskSave(backCtx, taskCtx);
        this.pushTaskSelectList(backCtx, taskCtx);
        this.pushTaskDelete(backCtx, taskCtx);
        this.pushTaskSaveOrUpdate(backCtx, taskCtx);
        if (HussarUtils.isNotEmpty((Object)taskCtx)) {
            HeEnginePushUtil.pushApi(taskCtx);
        }
    }

    private void pushTaskSave(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HETaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        HeBaseDataModel taskModel = useDataModelBase.getTask();
        HeDataModelBaseDTO taskDataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(taskModel.getId());
        SingleTableDto singleTableDto = new SingleTableDto();
        singleTableDto.setBusinessCode(backCtx.getParams().get("identity").toString());
        singleTableDto.setBusinessId(String.format("%s %s", "POST", FileUtil.posixPath((String[])new String[]{singleTableDto.getBusinessCode(), useDataModelBase.getModelPath() + File.separator + taskDataModelBaseDTO.getName(), "save"})));
        EngineMethodEnum engineMethod = EngineMethodEnum.SINGLE_TABLE_SAVE;
        singleTableDto.setMethodDesc(engineMethod.value.getDesc());
        singleTableDto.setMethodName(engineMethod.value.getName());
        singleTableDto.setPmList(new ArrayList());
        List<HeDataModelFieldDto> fields = taskDataModelBaseDTO.getFields();
        for (HeDataModelFieldDto field : fields) {
            MetadataColumn column = HeTaskCustomOption.getRelationShipField(engineCtx, field);
            if (field.getName() == null || column == null) continue;
            NodeBusinessPm pm = HeTaskCustomOption.getNodeBusinessPm(field.getPropertyName(), column);
            pm.setParameterType(ParameterType.values);
            pm.setOperatorType(OperatorType.EQ);
            singleTableDto.getPmList().add(pm);
        }
        HeEnginePushUtil.push(engineCtx, null, singleTableDto, 1);
    }

    private void pushTaskSelectList(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HETaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        HeBaseDataModel taskModel = useDataModelBase.getTask();
        HeDataModelBaseDTO taskDataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(taskModel.getId());
        SingleTableDto singleTableDto = new SingleTableDto();
        singleTableDto.setBusinessCode(backCtx.getParams().get("identity").toString());
        singleTableDto.setBusinessId(String.format("%s %s", "POST", FileUtil.posixPath((String[])new String[]{singleTableDto.getBusinessCode(), useDataModelBase.getModelPath() + File.separator + taskDataModelBaseDTO.getName(), "selectList"})));
        EngineMethodEnum engineMethod = EngineMethodEnum.SINGLE_TABLE_SELECT_LIST;
        singleTableDto.setMethodDesc(engineMethod.value.getDesc());
        singleTableDto.setMethodName(engineMethod.value.getName());
        singleTableDto.setPmList(new ArrayList());
        List<HeDataModelFieldDto> fields = taskDataModelBaseDTO.getFields();
        ArrayList<NodeBusinessPm> whereList = new ArrayList<NodeBusinessPm>();
        for (HeDataModelFieldDto field : fields) {
            MetadataColumn column = HeTaskCustomOption.getRelationShipField(engineCtx, field);
            if (field.getName() == null || column == null) continue;
            NodeBusinessPm pm = HeTaskCustomOption.getNodeBusinessPm(field.getPropertyName(), column);
            pm.setParameterType(ParameterType.column);
            pm.setOperatorType(OperatorType.EQ);
            singleTableDto.getPmList().add(pm);
            if (!"taskId".equals(field.getPropertyName())) continue;
            String parameterAlias = field.getPropertyName();
            NodeBusinessPm wherePm = HeTaskCustomOption.getNodeBusinessPm(parameterAlias, column);
            wherePm.setOperatorType(OperatorType.IN);
            wherePm.setMatchType(MatchTypeEnum.AND);
            whereList.add(wherePm);
        }
        singleTableDto.setWhere(whereList);
        HeEnginePushUtil.push(engineCtx, null, singleTableDto, 1);
    }

    private void pushTaskDelete(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HETaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        HeBaseDataModel taskModel = useDataModelBase.getTask();
        HeDataModelBaseDTO taskDataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(taskModel.getId());
        SingleTableDto singleTableDto = new SingleTableDto();
        singleTableDto.setBusinessCode(backCtx.getParams().get("identity").toString());
        singleTableDto.setBusinessId(String.format("%s %s", "POST", FileUtil.posixPath((String[])new String[]{singleTableDto.getBusinessCode(), useDataModelBase.getModelPath() + File.separator + taskDataModelBaseDTO.getName(), "delete"})));
        EngineMethodEnum engineMethod = EngineMethodEnum.SINGLE_TABLE_REMOVE;
        singleTableDto.setMethodDesc(engineMethod.value.getDesc());
        singleTableDto.setMethodName(engineMethod.value.getName());
        singleTableDto.setPmList(new ArrayList());
        List<HeDataModelFieldDto> fields = taskDataModelBaseDTO.getFields();
        ArrayList<NodeBusinessPm> whereList = new ArrayList<NodeBusinessPm>();
        for (HeDataModelFieldDto field : fields) {
            NodeBusinessPm wherePm;
            String parameterAlias;
            MetadataColumn column = HeTaskCustomOption.getRelationShipField(engineCtx, field);
            if (field.getName() == null || column == null) continue;
            NodeBusinessPm pm = HeTaskCustomOption.getNodeBusinessPm(field.getPropertyName(), column);
            singleTableDto.getPmList().add(pm);
            if ("taskId".equals(field.getPropertyName())) {
                parameterAlias = field.getPropertyName();
                wherePm = HeTaskCustomOption.getNodeBusinessPm(parameterAlias, column);
                wherePm.setOperatorType(OperatorType.IN);
                wherePm.setMatchType(MatchTypeEnum.OR);
                whereList.add(wherePm);
                continue;
            }
            if (!"businessId".equals(field.getPropertyName())) continue;
            parameterAlias = field.getPropertyName();
            wherePm = HeTaskCustomOption.getNodeBusinessPm(parameterAlias, column);
            wherePm.setOperatorType(OperatorType.IN);
            wherePm.setMatchType(MatchTypeEnum.OR);
            whereList.add(wherePm);
        }
        singleTableDto.setWhere(whereList);
        HeEnginePushUtil.push(engineCtx, null, singleTableDto, 1);
    }

    private void pushTaskSaveOrUpdate(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HETaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        HeBaseDataModel taskModel = useDataModelBase.getTask();
        HeDataModelBaseDTO taskDataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(taskModel.getId());
        SingleTableDto singleTableDto = new SingleTableDto();
        singleTableDto.setBusinessCode(backCtx.getParams().get("identity").toString());
        singleTableDto.setBusinessId(String.format("%s %s", "POST", FileUtil.posixPath((String[])new String[]{singleTableDto.getBusinessCode(), useDataModelBase.getModelPath() + File.separator + taskDataModelBaseDTO.getName(), "saveOrUpdateBatch"})));
        EngineMethodEnum engineMethod = EngineMethodEnum.SINGLE_TABLE_SAVE_OR_UPDATE_BATCH;
        singleTableDto.setMethodDesc(engineMethod.value.getDesc());
        singleTableDto.setMethodName(engineMethod.value.getName());
        singleTableDto.setPmList(new ArrayList());
        List<HeDataModelFieldDto> fields = taskDataModelBaseDTO.getFields();
        for (HeDataModelFieldDto field : fields) {
            MetadataColumn column = HeTaskCustomOption.getRelationShipField(engineCtx, field);
            if (field.getName() == null || column == null) continue;
            NodeBusinessPm pm = HeTaskCustomOption.getNodeBusinessPm(field.getPropertyName(), column);
            pm.setParameterType(ParameterType.set);
            pm.setOperatorType(OperatorType.EQ);
            singleTableDto.getPmList().add(pm);
        }
        HeEnginePushUtil.push(engineCtx, null, singleTableDto, 1);
    }

    private static NodeBusinessPm getNodeBusinessPm(String parameterAlias, MetadataColumn column) {
        NodeBusinessPm pm = new NodeBusinessPm();
        pm.setColumnId(column.getColumnId());
        pm.setParameterAlias(parameterAlias);
        return pm;
    }

    private static MetadataColumn getRelationShipField(PushBackCtx ctx, HeDataModelFieldDto field) {
        String fieldName;
        Map columnMap = ctx.getColumnMap();
        MetadataColumn column = (MetadataColumn)columnMap.get(fieldName = field.getTableName() + "-" + field.getName());
        if (column != null) {
            return column;
        }
        logger.error("\u5217{}\u672a\u627e\u5230\u5f15\u64ce\u5143\u6570\u636e\u5bf9\u5e94\u5217", (Object)field.getName());
        return null;
    }
}

