/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableIndex;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.constant.StrategyType;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.RelationConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeModelFunction;
import com.jxdinfo.hussar.formdesign.engine.function.HeOperationVisitor;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationDTO;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeEditDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.index.HeDataModelIndex;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.result.HeCodeResult;
import com.jxdinfo.hussar.formdesign.engine.service.HeModelPublishService;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.entity.RelationshipOn;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HEDataModelUtil {
    private static Logger logger = LoggerFactory.getLogger(HEDataModelUtil.class);
    private static final HeModelPublishService LR_MODEL_PUBLISH_SERVICE = (HeModelPublishService)SpringUtil.getBean(HeModelPublishService.class);

    private HEDataModelUtil() {
    }

    public static void init(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws LcdpException {
        String modelId = dataModelBase.getId();
        HeModelFunction currentFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        HeDataModelBase currentModelBase = currentFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        HashMap<String, HeDataModelBaseDTO> useDtoMap = new HashMap<String, HeDataModelBaseDTO>();
        useDtoMap.put(modelId, LR_MODEL_PUBLISH_SERVICE.enclosure(currentModelBase));
        backCtx.setUseDataModelBase(currentModelBase);
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, PublishCtx<HeCodeResult> publishCtx) throws LcdpException, IOException {
        HEDataModelUtil.visit(backCtx);
        LR_MODEL_PUBLISH_SERVICE.mergeBack(LR_MODEL_PUBLISH_SERVICE.renderCode(backCtx, publishCtx), publishCtx);
    }

    public static void visit(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx) throws LcdpException, IOException {
        HeDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        HeDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PushBackCtx engineCtx = HeEnginePushUtil.getEngineCtx(useDataModelBase);
        useDataModelBase.initMasterSlave(backCtx);
        PageInfoNode pageInfoNode = null;
        if (backCtx.getUseDataModelBase().getIsPublishResource()) {
            pageInfoNode = DataModelUtil.getDataModelNode((String)useDataModelBase.getId());
        }
        for (HeDataModelOperation operation : useDataModelBase.getOperations()) {
            HeOperationVisitor<HeDataModelBase, HeDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().visitor(StrategyType.analyse(), backCtx.getModelFunctionTye(), ToolUtil.isNotEmpty((Object)operation.getFlowBusiness()) ? "" : operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            backCtx.getModelFunction().accept(visitor, backCtx, operation, engineCtx);
            if (!backCtx.getUseDataModelBase().getIsPublishResource()) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
        useDataModelBase.customOption(backCtx, engineCtx);
        if (HussarUtils.isNotEmpty((Object)engineCtx)) {
            HeEnginePushUtil.pushApi(engineCtx);
        }
    }

    public static HeDataModelBase transfer(DataModelBase dataModelBase) throws LcdpException {
        HeModelFunction modelFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        return modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)dataModelBase.getId()));
    }

    public static HeDataModelBase transfer(String jsonData) throws LcdpException {
        DataModelBase dataModel = (DataModelBase)JSON.parseObject((String)jsonData, DataModelBase.class);
        HeModelFunction modelFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        return modelFunction.parseDataModel(JSON.parseObject((String)jsonData));
    }

    public static ContrastVO<HeDataModelField> hcontrastWith(List<TableField> tableFields, List<HeDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<HeDataModelField> addFields = new ArrayList<HeDataModelField>();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        List<Object> delFields = new ArrayList();
        ArrayList<HeDataModelField> modifyFields = new ArrayList<HeDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot().intValue() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(modelFields.get(i));
            }
            if (flag) continue;
            addFields.add(modelFields.get(i));
        }
        delFields = HEDataModelUtil.htabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastIndexVO<HeDataModelIndex> contrastIndexWith(List<TableIndex> tableIndexs, List<HeDataModelIndex> modelIndexs, TableCorrespond modelFislds) {
        boolean flag;
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<HeDataModelIndex> addIndexs = new ArrayList<HeDataModelIndex>();
        ArrayList<HeDataModelIndex> delIndexs = new ArrayList<HeDataModelIndex>();
        if (!HussarUtils.isEmpty(tableIndexs)) {
            if (!HussarUtils.isEmpty(modelIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(modelIndexs.get(i));
                        addIndexs.add(HEDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                    }
                    if (flag) continue;
                    delIndexs.add(modelIndexs.get(i));
                }
                addIndexs.addAll(HEDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(HEDataModelUtil.tabTransmodelIndex(tableIndexs));
            }
        } else if (!HussarUtils.isEmpty(modelIndexs)) {
            delIndexs.addAll(modelIndexs);
        }
        if (HussarUtils.isNotEmpty((Object)modelFislds)) {
            List modifyFields;
            ArrayList fields = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)modelFislds.getAddFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getAddFields(), HeDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)modelFislds.getDelFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getDelFields(), HeDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)(modifyFields = JSONArray.parseArray((String)modelFislds.getModifyFields(), HeEditDataModelField.class)))) {
                fields.addAll(modifyFields.stream().map(HeEditDataModelField::getNewField).collect(Collectors.toList()));
            }
            flag = false;
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(delIndexs)) {
                Iterator iterator = delIndexs.iterator();
                while (iterator.hasNext()) {
                    HeDataModelIndex delIndex = (HeDataModelIndex)((Object)iterator.next());
                    for (HeDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(delIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(addIndexs)) {
                Iterator iterator = addIndexs.iterator();
                while (iterator.hasNext()) {
                    HeDataModelIndex addIndex = (HeDataModelIndex)((Object)iterator.next());
                    for (HeDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(addIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static ContrastIndexVO<HeDataModelIndex> hcontrastIndexWith(List<TableIndex> tableIndexs, List<HeDataModelIndex> modelIndexs) {
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<HeDataModelIndex> addIndexs = new ArrayList<HeDataModelIndex>();
        ArrayList<HeDataModelIndex> delIndexs = new ArrayList<HeDataModelIndex>();
        if (!HussarUtils.isEmpty(modelIndexs)) {
            if (!HussarUtils.isEmpty(tableIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    boolean flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(HEDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                        addIndexs.add(modelIndexs.get(i));
                    }
                    if (flag) continue;
                    addIndexs.add(modelIndexs.get(i));
                }
                delIndexs.addAll(HEDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(modelIndexs);
            }
        } else if (!HussarUtils.isEmpty(tableIndexs)) {
            delIndexs.addAll(HEDataModelUtil.tabTransmodelIndex(tableIndexs));
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static List<HeDataModelField> htabTransmodel(List<TableField> tableFields) {
        ArrayList<HeDataModelField> modelFields = new ArrayList<HeDataModelField>();
        tableFields.forEach(tab -> {
            HeDataModelField field = new HeDataModelField();
            field.setSourceFieldName(tab.getName());
            field.setId(UUID.randomUUID().toString());
            field.setDataIsEmpty(tab.getDataIsEmpty());
            field.setDataLength(tab.getDataLength());
            field.setDataDot(tab.getDataDot());
            field.setComment(tab.getComment());
            field.setSourceDataType(tab.getType().toUpperCase());
            if ("PRI".equals(tab.getPrimarys())) {
                field.setUsage("primary");
            }
            modelFields.add(field);
        });
        return modelFields;
    }

    public static HeDataModelField tabTransmodelOne(TableField tableFields, String id) {
        HeDataModelField field = new HeDataModelField();
        field.setId(id);
        field.setSourceFieldName(tableFields.getName());
        field.setDataIsEmpty(tableFields.getDataIsEmpty());
        field.setDataLength(tableFields.getDataLength());
        field.setDataDot(tableFields.getDataDot());
        field.setComment(tableFields.getComment());
        if ("PRI".equals(tableFields.getPrimarys())) {
            field.setUsage("primary");
        }
        field.setSourceDataType(tableFields.getType().toUpperCase());
        return field;
    }

    public static ContrastVO<HeDataModelField> contrastWith(List<TableField> tableFields, List<HeDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<HeDataModelField> delFields = new ArrayList<HeDataModelField>();
        ArrayList<HeDataModelField> modifyFields = new ArrayList<HeDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot().intValue() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(HEDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<HeDataModelField> addFields = HEDataModelUtil.htabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<HeDataModelField> pushContrastWith(List<TableField> tableFields, List<HeDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<HeDataModelField> delFields = new ArrayList<HeDataModelField>();
        ArrayList<HeDataModelField> modifyFields = new ArrayList<HeDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(HEDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<HeDataModelField> addFields = HEDataModelUtil.htabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<HeDataModelField> contrastWithIgnoreCase(List<TableField> tableFields, List<HeDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<HeDataModelField> delFields = new ArrayList<HeDataModelField>();
        ArrayList<HeDataModelField> modifyFields = new ArrayList<HeDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && HussarUtils.equals((Object)modelFields.get(i).getDataDot(), (Object)tableFields.get(j).getDataDot())) break;
                modifyFields.add(HEDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<HeDataModelField> addFields = HEDataModelUtil.htabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static HeRelationDTO slaveRelationSync(ModelPublishDTO masterTableInfo, HeDataModelBase masterTable, List<HeDataModelBase> slaveTables, List<HeRelationshipBase> relationships, String functionType) {
        ArrayList<ModelPublishDTO> slaveList = new ArrayList<ModelPublishDTO>();
        for (HeDataModelBase slaveTable : slaveTables) {
            slaveList.add(HEOperationUtil.ModelToEngine(slaveTable));
        }
        for (ModelPublishDTO mbdto : slaveList) {
            Iterator<HeDataModelBase> relationship = relationships.stream().filter(relation -> mbdto.getTfmodelId().equals(relation.getSlaveTableId())).findFirst();
            mbdto.setType(TypeConversionEnum.getValueByKey(functionType).getValue());
            ((Optional)((Object)relationship)).ifPresent(relation -> mbdto.setRelation(RelationConversionEnum.getValueByKey(relation.getRelateModelType())));
            mbdto.setParentPath(masterTableInfo.getParentPath() + "," + masterTableInfo.getRelatedId());
            Optional<HeDataModelBase> slaveOp = slaveTables.stream().filter(x -> x.getId().equals(mbdto.getTfmodelId())).findFirst();
            if (!slaveOp.isPresent()) continue;
            HeDataModelBase slave = slaveOp.get();
            mbdto.setParamName(slave.getName());
        }
        HashMap<String, String> modelIdNameMap = new HashMap<String, String>();
        List<HeDataModelField> masterFieldsList = masterTable.getFields();
        for (HeDataModelField heDataModelField : masterFieldsList) {
            modelIdNameMap.put(heDataModelField.getId(), heDataModelField.getSourceFieldName());
        }
        for (HeDataModelBase slave : slaveTables) {
            List<HeDataModelField> slaveFieldsList = slave.getFields();
            for (HeDataModelField heDataModelField : slaveFieldsList) {
                modelIdNameMap.put(heDataModelField.getId(), heDataModelField.getSourceFieldName());
            }
        }
        TableInfoDto metaMasterTableInfo = HeExternalApiUtil.getTableByTableId(masterTable.getTableId(), false);
        HashMap<String, Long> masterMetaNameIdMap = new HashMap<String, Long>();
        for (MetadataColumn column : metaMasterTableInfo.getColumnList()) {
            masterMetaNameIdMap.put(column.getColumnName(), column.getColumnId());
        }
        for (HeDataModelBase slave : slaveTables) {
            String slaveId = slave.getId();
            Optional<HeRelationshipBase> theRelationOp = relationships.stream().filter(x -> x.getSlaveTableId().equals(slaveId)).findFirst();
            if (!theRelationOp.isPresent()) continue;
            HeRelationshipBase relationship = theRelationOp.get();
            TableInfoDto slaveTableInfo = HeExternalApiUtil.getTableByTableId(slave.getTableId(), false);
            HashMap<String, Long> slaveMetaNameIdMap = new HashMap<String, Long>();
            for (MetadataColumn column : slaveTableInfo.getColumnList()) {
                slaveMetaNameIdMap.put(column.getColumnName(), column.getColumnId());
            }
            ArrayList<RelationshipOn> ons = new ArrayList<RelationshipOn>();
            Optional<ModelPublishDTO> mbdtoSlaveOp = slaveList.stream().filter(x -> x.getTfmodelId().equals(slave.getId())).findFirst();
            if (!mbdtoSlaveOp.isPresent()) continue;
            ModelPublishDTO mpdtoSlave = mbdtoSlaveOp.get();
            for (HeRelationshipFieldBase fieldRelationShip : relationship.getRelationships()) {
                RelationshipOn relationshipOn = new RelationshipOn();
                String masterFieldId = fieldRelationShip.getMasterTableFieldId();
                String masterFieldName = (String)modelIdNameMap.get(masterFieldId);
                Long leftColumnId = (Long)masterMetaNameIdMap.get(masterFieldName);
                String slaveFieldId = fieldRelationShip.getSlaveTableFieldId();
                String slaverFieldName = (String)modelIdNameMap.get(slaveFieldId);
                Long rightColumnId = (Long)slaveMetaNameIdMap.get(slaverFieldName);
                relationshipOn.setLeftColumnId(leftColumnId);
                relationshipOn.setRightColumnId(rightColumnId);
                relationshipOn.setOperatorType(OperatorType.EQ);
                ons.add(relationshipOn);
            }
            mpdtoSlave.setOns(ons);
        }
        return new HeRelationDTO.HeRelationDTOBuilder().withMasterPublishDTO(masterTableInfo).withSlavePublishDTO(slaveList).build();
    }

    public static HeRelationDTO slaveRelationSyncById(ModelPublishDTO masterTableInfo, HeDataModelBase masterTable, List<HeDataModelBase> slaveTables, List<HeRelationshipBase> relationships, String functionType) {
        ArrayList<ModelPublishDTO> slaveList = new ArrayList<ModelPublishDTO>();
        for (HeDataModelBase slaveTable : slaveTables) {
            slaveList.add(HEOperationUtil.ModelToEngineById(slaveTable));
        }
        for (ModelPublishDTO mbdto : slaveList) {
            Iterator<HeDataModelBase> relationship = relationships.stream().filter(relation -> mbdto.getTfmodelId().equals(relation.getSlaveTableId())).findFirst();
            mbdto.setType(TypeConversionEnum.getValueByKey(functionType).getValue());
            ((Optional)((Object)relationship)).ifPresent(relation -> mbdto.setRelation(RelationConversionEnum.getValueByKey(relation.getRelateModelType())));
            mbdto.setParentPath(masterTableInfo.getParentPath() + "," + masterTableInfo.getRelatedId());
            Optional<HeDataModelBase> slaveOp = slaveTables.stream().filter(x -> x.getId().equals(mbdto.getTfmodelId())).findFirst();
            if (!slaveOp.isPresent()) continue;
            HeDataModelBase slave = slaveOp.get();
            mbdto.setParamName(slave.getName());
        }
        HashMap<String, String> modelIdNameMap = new HashMap<String, String>();
        List<HeDataModelField> masterFieldsList = masterTable.getFields();
        for (HeDataModelField heDataModelField : masterFieldsList) {
            modelIdNameMap.put(heDataModelField.getId(), heDataModelField.getSourceFieldName());
        }
        for (HeDataModelBase slave : slaveTables) {
            List<HeDataModelField> slaveFieldsList = slave.getFields();
            for (HeDataModelField heDataModelField : slaveFieldsList) {
                modelIdNameMap.put(heDataModelField.getId(), heDataModelField.getSourceFieldName());
            }
        }
        TableInfoDto metaMasterTableInfo = HeExternalApiUtil.getTableByTableId(masterTable.getTableId(), false);
        HashMap<String, Long> masterMetaNameIdMap = new HashMap<String, Long>();
        for (MetadataColumn column : metaMasterTableInfo.getColumnList()) {
            masterMetaNameIdMap.put(column.getColumnName(), column.getColumnId());
        }
        for (HeDataModelBase slave : slaveTables) {
            String slaveId = slave.getId();
            Optional<HeRelationshipBase> theRelationOp = relationships.stream().filter(x -> x.getSlaveTableId().equals(slaveId)).findFirst();
            if (!theRelationOp.isPresent()) continue;
            HeRelationshipBase relationship = theRelationOp.get();
            TableInfoDto slaveTableInfo = HeExternalApiUtil.getTableByTableId(slave.getTableId(), false);
            HashMap<String, Long> slaveMetaNameIdMap = new HashMap<String, Long>();
            for (MetadataColumn column : slaveTableInfo.getColumnList()) {
                slaveMetaNameIdMap.put(column.getColumnName(), column.getColumnId());
            }
            ArrayList<RelationshipOn> ons = new ArrayList<RelationshipOn>();
            Optional<ModelPublishDTO> mbdtoSlaveOp = slaveList.stream().filter(x -> x.getTfmodelId().equals(slave.getId())).findFirst();
            if (!mbdtoSlaveOp.isPresent()) continue;
            ModelPublishDTO mpdtoSlave = mbdtoSlaveOp.get();
            for (HeRelationshipFieldBase fieldRelationShip : relationship.getRelationships()) {
                RelationshipOn relationshipOn = new RelationshipOn();
                String masterFieldId = fieldRelationShip.getMasterTableFieldId();
                String masterFieldName = (String)modelIdNameMap.get(masterFieldId);
                Long leftColumnId = (Long)masterMetaNameIdMap.get(masterFieldName);
                String slaveFieldId = fieldRelationShip.getSlaveTableFieldId();
                String slaverFieldName = (String)modelIdNameMap.get(slaveFieldId);
                Long rightColumnId = (Long)slaveMetaNameIdMap.get(slaverFieldName);
                relationshipOn.setLeftColumnId(leftColumnId);
                relationshipOn.setRightColumnId(rightColumnId);
                relationshipOn.setOperatorType(OperatorType.EQ);
                ons.add(relationshipOn);
            }
            mpdtoSlave.setOns(ons);
        }
        return new HeRelationDTO.HeRelationDTOBuilder().withMasterPublishDTO(masterTableInfo).withSlavePublishDTO(slaveList).build();
    }

    public static List<HeDataModelIndex> tabTransmodelIndex(List<TableIndex> tableIndexs) {
        ArrayList<HeDataModelIndex> modelIndexs = new ArrayList<HeDataModelIndex>();
        if (tableIndexs != null) {
            tableIndexs.forEach(tab -> {
                HeDataModelIndex index = new HeDataModelIndex();
                index.setIndexName(tab.getIndexName().toUpperCase());
                index.setChkUnique(tab.getIsNonUnique() == 0);
                index.setTableSchema(tab.getTableSchema());
                index.setColumnName(tab.getColumnName().toUpperCase());
                index.setIndexType(tab.getIndexType());
                index.setTableName(tab.getTableName().toUpperCase());
                modelIndexs.add(index);
            });
        }
        return modelIndexs;
    }

    public static HeDataModelIndex tabTransmodelIndexOne(TableIndex tableIndex, String indexName) {
        HeDataModelIndex index = new HeDataModelIndex();
        index.setIndexName(indexName.toUpperCase());
        index.setChkUnique(tableIndex.getIsNonUnique() == 0);
        index.setTableSchema(tableIndex.getTableSchema());
        index.setColumnName(tableIndex.getColumnName().toUpperCase());
        index.setIndexType(tableIndex.getIndexType());
        index.setTableName(tableIndex.getTableName().toUpperCase());
        return index;
    }
}

