/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.service.impl;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.service.impl.DataModelInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.engine.function.HeModelFunction;
import com.jxdinfo.hussar.formdesign.engine.function.element.base.HeBaseDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.flow.HeFlowDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.flow.HeFlowMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.HeMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEOperationUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelSyncDto;
import com.jxdinfo.hussar.support.engine.api.service.ModelSyncService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModelSyncServiceImpl
implements ModelSyncService {
    @Autowired
    protected DataModelInfoServiceImpl dataModelInfoService;

    public List<ModelSyncDto> getModelsByPath(List<String> paths) {
        ArrayList<ModelSyncDto> resultList = new ArrayList<ModelSyncDto>();
        for (String path : paths) {
            try {
                HeDataModelBase bussinessTable;
                HeFlowDataModel heFlowDataModel;
                String realPath = HEOperationUtil.getRealPath(path);
                DataModelBase dataModelBase = this.dataModelInfoService.getDataModelBaseByModelPath(realPath);
                HeModelFunction modelFunction = HEModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
                HeDataModelBase heDataModelBase = modelFunction.parseDataModel(this.dataModelInfoService.getDataModelJsonByModelPath(realPath));
                if (heDataModelBase instanceof HeBaseDataModel) {
                    resultList.add(HEOperationUtil.conversionFunction(heDataModelBase, path, heDataModelBase.getFunctionType()));
                    continue;
                }
                if (heDataModelBase instanceof HeMSDataModel) {
                    HeMSDataModel heMSDataModel = (HeMSDataModel)heDataModelBase;
                    HeDataModelBase masterTable = heMSDataModel.getMasterTable();
                    List<HeDataModelBase> slaveTables = heMSDataModel.getSlaveTables();
                    resultList.add(HEOperationUtil.conversionFunction(masterTable, path, heDataModelBase.getFunctionType()));
                    for (HeDataModelBase slave : slaveTables) {
                        resultList.add(HEOperationUtil.conversionFunction(slave, path, heDataModelBase.getFunctionType()));
                    }
                    continue;
                }
                if (heDataModelBase instanceof HeFlowMSDataModel) {
                    heFlowDataModel = (HeFlowDataModel)heDataModelBase;
                    bussinessTable = heFlowDataModel.getBusinessTable();
                    HeMSDataModel heMSDataModel = (HeMSDataModel)bussinessTable;
                    HeDataModelBase masterTable = heMSDataModel.getMasterTable();
                    List<HeDataModelBase> slaveTables = heMSDataModel.getSlaveTables();
                    HeFlowMSDataModel heFlowMSDataModel = (HeFlowMSDataModel)heDataModelBase;
                    String functionType = heFlowMSDataModel.getRealFunctionType();
                    resultList.add(HEOperationUtil.conversionFunction(masterTable, path, functionType));
                    for (HeDataModelBase slave : slaveTables) {
                        resultList.add(HEOperationUtil.conversionFunction(slave, path, functionType));
                    }
                    continue;
                }
                if (!(heDataModelBase instanceof HeFlowDataModel)) continue;
                heFlowDataModel = (HeFlowDataModel)heDataModelBase;
                bussinessTable = heFlowDataModel.getBusinessTable();
                resultList.add(HEOperationUtil.conversionFunction(bussinessTable, path, heDataModelBase.getFunctionType()));
            }
            catch (LcdpException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return resultList;
    }
}

