/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.visitor.task;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.engine.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeOperationVisitor;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.HeMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.task.HETaskDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.util.HeBackRenderUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.enums.EngineMethodEnum;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HUSSAR_ENGINETASKFlowTableFlagDeleteBatch")
public class HeTaskTableFlagDeleteBatchVisitor
implements HeOperationVisitor<HETaskDataModel, HeDataModelBaseDTO> {
    private static final Logger logger = LoggerFactory.getLogger(HeTaskTableFlagDeleteBatchVisitor.class);
    public static final String OPERATION_NAME = "HUSSAR_ENGINETASKFlowTableFlagDeleteBatch";

    @Override
    public void visit(HeBackCtx<HETaskDataModel, HeDataModelBaseDTO> backCtx, HeDataModelOperation dataModelOperation, PushBackCtx engineCtx) throws LcdpException, IOException {
        logger.debug("{}\u65b9\u6cd5\u5f00\u59cb", (Object)OPERATION_NAME);
        HETaskDataModel taskDataModel = backCtx.getUseDataModelBase();
        String currentModelId = taskDataModel.getId();
        HeDataModelBaseDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        logger.debug("\u63a8\u9001\u89e3\u6790\u5f15\u64ce");
        HeDataModelBase businessModel = backCtx.getUseDataModelBase().getBusinessTable();
        HeDataModelBaseDTO businessDto = dataModelBaseDTO;
        if ("MASTER_SLAVE".equals(businessModel.getFunctionType())) {
            businessDto = backCtx.getUseDataModelDtoMap().get(((HeMSDataModel)businessModel).getMasterTable().getId());
            businessDto.setTablePath(dataModelBaseDTO.getTablePath());
        }
        boolean isLogicallyDelete = businessModel.isLogicallyDelete();
        EngineMethodEnum engineMethodEnum = engineCtx.isMs ? EngineMethodEnum.MULTI_BPM_FLOW_FLAG_DELETE_BATCH : EngineMethodEnum.SINGLE_BPM_FLOW_FLAG_DELETE_BATCH;
        HeEnginePushUtil.pushFlagDeleteIds(dataModelOperation.getName(), engineCtx, businessDto, engineMethodEnum.value.getName(), engineMethodEnum.value.getDesc(), new ArrayList<String>());
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6d41\u7a0b\u8868\u683c\u6279\u91cf\u5220\u9664");
        backCtx.addApi(currentModelId, HeBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

