/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.base;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.function.element.base.HeBaseDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class HeBaseConnector {
    public static TableInfoDto tableInfoInEdit(SysDataSource sysDataSource, HeDataModelBase dataModel) {
        TableInfoDto tableDto = new TableInfoDto();
        tableDto.setTableName(dataModel.getSourceDataModelName());
        tableDto.setDatasourceId(sysDataSource.getId());
        tableDto.setPollName(dataModel.getDataSourceName());
        tableDto.setTableAlias(dataModel.getName());
        tableDto.setColumnList(HeBaseConnector.transfer(dataModel.getFields()));
        return tableDto;
    }

    public static TableInfoDto tableInfoInCreate(SysDataSource sysDataSource, HeDataModelBase dataModel) {
        TableInfoDto tableDto = HeBaseConnector.tableInfoInEdit(sysDataSource, dataModel);
        tableDto.setTableDec(dataModel.getTableDesc());
        return tableDto;
    }

    private static List<MetadataColumn> transfer(List<HeDataModelField> fields) {
        ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
        for (HeDataModelField x : fields) {
            MetadataColumn metadataColumn = HeBaseConnector.getMetadataColumn(x);
            columns.add(metadataColumn);
        }
        return columns;
    }

    public static List<ColumnInfoDto> transferColumn(List<HeDataModelField> fields, String updateType) {
        ArrayList<ColumnInfoDto> columns = new ArrayList<ColumnInfoDto>();
        for (HeDataModelField x : fields) {
            MetadataColumn metadataColumn = HeBaseConnector.getMetadataColumn(x);
            ColumnInfoDto columnInfoDto = (ColumnInfoDto)BeanUtil.copyProperties((Object)metadataColumn, ColumnInfoDto.class);
            String isPk = "primary".equals(x.getUsage()) ? "1" : "0";
            String isRequired = x.getDataIsEmpty() ? "1" : "0";
            columnInfoDto.setPk(isPk);
            columnInfoDto.setIncrease("0");
            columnInfoDto.setRequired(isRequired);
            if (ToolUtil.isNotEmpty((Object)updateType)) {
                columnInfoDto.setOperation(updateType);
            }
            columns.add(columnInfoDto);
        }
        return columns;
    }

    private static MetadataColumn getMetadataColumn(HeDataModelField modelField) {
        Optional engineColumnType;
        String fieldSourceDataType = modelField.getSourceDataType();
        int preIndex = fieldSourceDataType.indexOf("(");
        String dataType = preIndex > -1 ? fieldSourceDataType.substring(0, preIndex) : modelField.getSourceDataType();
        MetadataColumn metadataColumn = new MetadataColumn();
        metadataColumn.setColumnAlias(modelField.getName());
        metadataColumn.setColumnName(modelField.getSourceFieldName());
        metadataColumn.setColumnComment(modelField.getComment());
        metadataColumn.setDataType(dataType);
        metadataColumn.setDataDot(modelField.getDataDot());
        metadataColumn.setDataLength(Long.valueOf(modelField.getDataLength()));
        metadataColumn.setDataIsEmpty(Integer.valueOf(modelField.getDataIsEmpty() ? 1 : 0));
        if (ToolUtil.isNotEmpty((Object)modelField.getUsage())) {
            if ("primary".equals(modelField.getUsage())) {
                metadataColumn.setPrimarys("1");
            }
            metadataColumn.setPurpose(modelField.getUsage());
        }
        if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)modelField.getDataType())).isPresent()) {
            metadataColumn.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
            metadataColumn.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        }
        return metadataColumn;
    }

    public static MetadataParam dealInfo(HeBaseDataModel dataModel) throws IOException {
        MetadataParam param = new MetadataParam();
        TableInfoDto tableInfo = new TableInfoDto();
        tableInfo.setTableName(dataModel.getSourceDataModelName());
        tableInfo.setTableAlias(dataModel.getName());
        tableInfo.setTableDec(dataModel.getTableDesc());
        tableInfo.setPollName(dataModel.getDataSourceName());
        tableInfo.setDatasourceId(DataModelUtil.getDataSourceConfigByName((String)dataModel.getDataSourceName()).getId());
        param.setTableInfo(tableInfo);
        ArrayList<ColumnInfoDto> columnInfo = new ArrayList<ColumnInfoDto>();
        HeBaseConnector.dealColumn(columnInfo, dataModel.getFields());
        param.setColumnInfo(columnInfo);
        param.setTfModelId(dataModel.getId());
        return param;
    }

    private static void dealColumn(List<ColumnInfoDto> columnInfo, List<HeDataModelField> fields) {
        if (HussarUtils.isEmpty(fields)) {
            return;
        }
        for (HeDataModelField field : fields) {
            Optional engineColumnType;
            ColumnInfoDto column = new ColumnInfoDto();
            column.setColumnName(field.getSourceFieldName());
            column.setColumnAlias(field.getName());
            column.setColumnComment(field.getComment());
            column.setDataType(field.getSourceDataType());
            column.setDataDot(field.getDataDot());
            column.setDataLength(Long.valueOf(field.getDataLength()));
            column.setDataIsEmpty(Integer.valueOf(field.getDataIsEmpty() ? 1 : 0));
            column.setTfModelColumnId(field.getId());
            if (ToolUtil.isNotEmpty((Object)field.getUsage())) {
                if ("primary".equals(field.getUsage())) {
                    column.setPrimarys("1");
                }
                column.setPurpose(field.getUsage());
            }
            if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType())).isPresent()) {
                column.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                column.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
            }
            columnInfo.add(column);
        }
    }
}

