/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.view;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.CheckTable;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.function.element.base.HeBaseConnector;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeEditDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryObject;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortCondition;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HeViewDataModel
extends HeDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(HeViewDataModel.class);
    public static final String FUNCTION_TYPE = "VIEW";
    private List<HeQueryCondition> queryConditions;
    private List<HeQueryObject> queryObject;
    private List<HeSortCondition> sortCondition;
    private String sourceDataModelName;

    public List<HeQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<HeQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<HeQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<HeQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    public List<HeSortCondition> getSortCondition() {
        return this.sortCondition;
    }

    public void setSortCondition(List<HeSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HE.VIEW", HeViewDataModel.class);
    }

    @Override
    public HeViewDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HeViewDataModel dataModel;
        try {
            dataModel = (HeViewDataModel)JSONObject.parseObject((String)jsonObject.toString(), HeViewDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return dataModel;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    @Override
    public HeQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (HeQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new HeQueryCondition();
    }

    @Override
    public HeSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (HeSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new HeSortCondition();
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        boolean findCurrentTable;
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return false;
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        datasourceLr.setDbName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (int x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                break;
            }
        }
        if (!(findCurrentTable = info.getTableName() != null && ToolUtil.isNotEmpty((Object)info.getTableName()) ? DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)info.getTableName()).isPresent() : DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)this.sourceDataModelName.toUpperCase()).isPresent())) {
            this.creatTabs(datasourceLr);
            return true;
        }
        this.editTabs(datasourceLr, (TableCorrespond<HeDataModelField>)info);
        return true;
    }

    public void creatTabs(SysDataSource datasourceLr) throws Exception {
        MetadataParam metadataParam = new MetadataParam();
        TableInfoDto tableInfoDto = HeBaseConnector.tableInfoInEdit(datasourceLr, this);
        metadataParam.setTableInfo(tableInfoDto);
        metadataParam.setColumnInfo(HeBaseConnector.transferColumn(this.getFields(), ""));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.createTable(metadataParam);
    }

    public void editTabs(SysDataSource datasourceLr, TableCorrespond<HeDataModelField> info) throws Exception {
        MetadataParam paramData = new MetadataParam();
        TableInfoDto tableInfoDto = HeBaseConnector.tableInfoInEdit(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSONArray.parseArray((String)info.getDelFields(), HeDataModelField.class);
        for (int y = 0; y < delFields.size(); ++y) {
            ColumnInfoDto del = new ColumnInfoDto();
            del.setColumnName(((HeDataModelField)((Object)delFields.get(y))).getSourceFieldName());
            deletedCols.add(del);
        }
        paramData.setDeletedCols(deletedCols);
        List addFields = JSONArray.parseArray((String)info.getAddFields(), HeDataModelField.class);
        List editFields = JSONArray.parseArray((String)info.getModifyFields(), HeEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)info.getOldTableName().toUpperCase());
        if (!infoOptional.isPresent()) {
            return;
        }
        TableInfo table = (TableInfo)infoOptional.get();
        List<ColumnInfoDto> oldColumn = this.transform(HEDataModelUtil.htabTransmodel(table.getFields()));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.editTable(paramData, oldColumn, info.getOldTableName());
    }

    public List<ColumnInfoDto> transformEdit(List<HeEditDataModelField> getFields, String state) throws Exception {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (int i = 0; i < getFields.size(); ++i) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(getFields.get(i).getNewField().getSourceFieldName());
            columnInfo.setColumnComment(getFields.get(i).getNewField().getComment());
            columnInfo.setRequired("0");
            if ("primary".equals(getFields.get(i).getNewField().getUsage())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
            } else {
                columnInfo.setPk("0");
            }
            if (getFields.get(i).getNewField().getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataType(getFields.get(i).getNewField().getSourceDataType());
            columnInfo.setDataLength(Long.valueOf(getFields.get(i).getNewField().getDataLength()));
            columnInfo.setDataDot(getFields.get(i).getNewField().getDataDot());
            columnInfo.setOldColumnName(getFields.get(i).getOldField().getSourceFieldName());
            if (!"all".equals(state)) {
                columnInfo.setOperation(state);
            }
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transformDto(List<HeDataModelField> getFields, String state) throws Exception {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (int i = 0; i < getFields.size(); ++i) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
            columnInfo.setColumnComment(getFields.get(i).getComment());
            columnInfo.setRequired("0");
            if ("primary".equals(getFields.get(i).getUsage())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
            } else {
                columnInfo.setPk("0");
            }
            if (getFields.get(i).getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setColumnComment(getFields.get(i).getComment());
            columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
            columnInfo.setDataDot(getFields.get(i).getDataDot());
            columnInfo.setDataType(getFields.get(i).getSourceDataType());
            if (!"all".equals(state)) {
                columnInfo.setOperation(state);
            }
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transform(List<HeDataModelField> getFields) throws Exception {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        for (int i = 0; i < getFields.size(); ++i) {
            ColumnInfoDto columnInfo = new ColumnInfoDto();
            columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
            columnInfo.setColumnComment(getFields.get(i).getComment());
            columnInfo.setRequired("0");
            if ("primary".equals(getFields.get(i).getUsage())) {
                columnInfo.setPk("1");
                columnInfo.setRequired("1");
            } else {
                columnInfo.setPk("0");
            }
            if (getFields.get(i).getDataIsEmpty()) {
                columnInfo.setRequired("1");
            }
            columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
            columnInfo.setDataDot(getFields.get(i).getDataDot());
            columnInfo.setDataType(getFields.get(i).getSourceDataType());
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    public Optional<TableInfo> findTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional infoOptional;
        TableInfo table = null;
        boolean findCurrentTable = false;
        List tableCorresponds = fieldsContrastParam.getTableCorresponds();
        if (tableCorresponds != null) {
            for (TableCorrespond tableCorrespond : tableCorresponds) {
                if (!this.getId().equals(tableCorrespond.getModelId())) continue;
                String changeName = tableCorrespond.getTableName().toUpperCase();
                Optional infoOptional2 = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)changeName);
                findCurrentTable = infoOptional2.isPresent();
                if (!findCurrentTable) break;
                table = (TableInfo)infoOptional2.get();
                break;
            }
        }
        if (!findCurrentTable && (findCurrentTable = (infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)this.sourceDataModelName.toUpperCase())).isPresent())) {
            table = (TableInfo)infoOptional.get();
        }
        return Optional.ofNullable(table);
    }

    @Override
    public List<ContrastVO<HeDataModelField>> tableContrastModel(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<HeDataModelField> contrast = new ContrastVO<HeDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = HEDataModelUtil.contrastWithIgnoreCase(table.getFields(), this.getFields());
            contrast.setTableFields(HEDataModelUtil.htabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<HeDataModelField>> contrastVOS = new ArrayList<ContrastVO<HeDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<HeDataModelField>> findTableContrast() throws IOException, LcdpException {
        ArrayList<ContrastVO<HeDataModelField>> contrastVOS = new ArrayList<ContrastVO<HeDataModelField>>();
        ContrastVO contrast = new ContrastVO();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)this.sourceDataModelName.toUpperCase());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        contrast.setModelId(this.getId());
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO contrastVOS = new PublishCheckVO();
        contrastVOS.setModelId(modelId);
        ArrayList<CheckTable> contrast = new ArrayList<CheckTable>();
        CheckTable info = new CheckTable();
        long start = System.currentTimeMillis();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)FUNCTION_TYPE, (String)this.sourceDataModelName.toUpperCase());
        if (!infoOptional.isPresent()) {
            return contrastVOS;
        }
        TableInfo table = (TableInfo)infoOptional.get();
        LOGGER.info("\u53d1\u5e03\u65f6\u6821\u9a8c\u67e5\u8be2\u5355\u8868{}\u8017\u65f6\uff1a{}", (Object)this.sourceDataModelName.toUpperCase(), (Object)ToolUtil.logTime((long)start));
        if (ToolUtil.isNotEmpty((Object)table)) {
            ContrastVO<HeDataModelField> model = HEDataModelUtil.contrastWithIgnoreCase(table.getFields(), this.getFields());
            if (model.getAddFields().size() == 0 && model.getDelFields().size() == 0 && model.getModifyFields().size() == 0) {
                info.setState(Integer.valueOf(2));
            } else {
                info.setState(Integer.valueOf(1));
            }
        } else {
            info.setState(Integer.valueOf(0));
        }
        info.setModelId(this.getId());
        contrast.add(info);
        contrastVOS.setDetails(contrast);
        return contrastVOS;
    }

    @Override
    public void sync() throws IOException, LcdpException {
        this.metaDataSync();
        this.syncModel("BASE");
    }

    @Override
    public void syncById() throws IOException, LcdpException {
        this.metaDataSyncById();
        this.syncModelById("BASE");
    }

    @Override
    public void syncModel(String functionType) throws IOException, LcdpException {
        ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        ModelPublishDTO mpdto = HEOperationUtil.ModelToEngine(this);
        mpdto.setType(TypeConversionEnum.getValueByKey(functionType).getValue());
        resultList.add(mpdto);
        modelRelateService.save(resultList);
    }

    @Override
    public void syncModelById(String functionType) throws IOException, LcdpException {
        ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        ModelPublishDTO mpdto = HEOperationUtil.ModelToEngineById(this);
        mpdto.setType(TypeConversionEnum.getValueByKey(functionType).getValue());
        resultList.add(mpdto);
        modelRelateService.save(resultList);
    }

    @Override
    public void metaDataSync() throws IOException, LcdpException {
        SysDataSource datasource = HeExternalApiUtil.getDataSourceName(this.getDataSourceName());
        TableInfoDto tableInfoDto = HeBaseConnector.tableInfoInCreate(datasource, this);
        MetadataParam metadataParam = new MetadataParam();
        metadataParam.setTableInfo(tableInfoDto);
        metadataParam.setColumnInfo(HeBaseConnector.transferColumn(this.getFields(), ""));
        HussarMetadataService metaService = (HussarMetadataService)SpringUtil.getBean(HussarMetadataService.class);
        TableInfoDto tableInfoByTableName = metaService.getTableInfoByName(tableInfoDto.getTableName());
        if (tableInfoByTableName == null) {
            metaService.insertTableInfo(metadataParam);
        } else {
            Long tableId = tableInfoByTableName.getTableId();
            tableInfoDto.setTableId(tableId);
            metaService.updateTableInfo(metadataParam);
        }
    }

    @Override
    public void metaDataSyncById() throws IOException, LcdpException {
        SysDataSource datasource = HeExternalApiUtil.getDataSourceName(this.getDataSourceName());
        TableInfoDto tableInfoDto = HeBaseConnector.tableInfoInCreate(datasource, this);
        MetadataParam metadataParam = new MetadataParam();
        metadataParam.setTableInfo(tableInfoDto);
        metadataParam.setColumnInfo(HeBaseConnector.transferColumn(this.getFields(), ""));
        HussarMetadataService metaService = (HussarMetadataService)SpringUtil.getBean(HussarMetadataService.class);
        TableInfoDto tableInfo = HeExternalApiUtil.getTableInfoById(this.getId(), false);
        if (tableInfo == null) {
            metaService.insertTableInfo(metadataParam);
        } else {
            Long tableId = tableInfo.getTableId();
            tableInfoDto.setTableId(tableId);
            metaService.updateTableInfo(metadataParam);
        }
        this.setTableId(metadataParam.getTableInfo().getTableId());
    }

    @Override
    public void delete(String modelId) {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(modelId);
    }

    @Override
    public void delete() {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(this.getId());
    }

    public ModelTableMappingDTO getRelationById(String id) {
        return ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(ToolUtil.isNotEmpty((Object)id) ? id : this.getId());
    }

    @Override
    public List<String> getSourceDataModelNames() {
        return Collections.singletonList(this.sourceDataModelName);
    }

    @Override
    public List<Long> getTableIds() {
        return Collections.singletonList(this.getTableId());
    }

    @Override
    public List<String> getIds() {
        return Collections.singletonList(this.getId());
    }

    @Override
    public Map<String, MetadataColumn> getColumnMap() {
        ModelTableMappingDTO tableInfo = this.getRelationById("");
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        if (HussarUtils.isNotEmpty((Object)tableInfo)) {
            for (MetadataColumn column : tableInfo.getColumns()) {
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    @Override
    public Map<String, MetadataColumn> getColumnMapById() {
        ModelTableMappingDTO tableInfo = this.getRelationById("");
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        if (HussarUtils.isNotEmpty((Object)tableInfo)) {
            for (MetadataColumn column : tableInfo.getColumns()) {
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    @Override
    public PushBackCtx getPushBackCtx() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ctx.setModelId(this.getRelationById("").getRelatedId());
        ctx.setModelName(modelName);
        ctx.setColumnMap(this.getColumnMap());
        ctx.build();
        return ctx;
    }

    @Override
    public PushBackCtx getPushBackCtxById() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ctx.setModelId(this.getRelationById("").getRelatedId());
        ctx.setModelName(modelName);
        ctx.setColumnMap(this.getColumnMapById());
        ctx.build();
        return ctx;
    }

    @Override
    public String strategy() {
        return "HUSSAR_ENGINE";
    }
}

