/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.masterslave;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationDTO;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryCondition;
import com.jxdinfo.hussar.formdesign.engine.function.model.querycondition.HeQueryObject;
import com.jxdinfo.hussar.formdesign.engine.function.model.sortcondition.HeSortCondition;
import com.jxdinfo.hussar.formdesign.engine.service.HeModelPublishService;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HeMSDataModel
extends HeDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(HeMSDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String[] UPDATE_STRATEGY = new String[]{"update"};
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<HeQueryCondition> queryConditions;
    private List<HeQueryObject> queryObject;
    private List<HeSortCondition> sortCondition;
    private HeDataModelBase masterTable;
    private List<HeDataModelBase> slaveTables;
    private List<HeRelationshipBase> relationships;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"HE.MASTER_SLAVE", HeMSDataModel.class);
    }

    @Override
    public HeMSDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HeMSDataModel dataModel;
        try {
            dataModel = (HeMSDataModel)JSON.parseObject((String)jsonObject.toString(), HeMSDataModel.class);
            ArrayList<HeDataModelField> fieldList = new ArrayList<HeDataModelField>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                HeDataModelBase masterTableModel = HEDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                dataModel.setMasterTable(masterTableModel);
                fieldList.addAll(masterTableModel.getFields());
            }
            ArrayList<HeDataModelBase> slaveTableList = new ArrayList<HeDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaveJson : JSON.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    HeDataModelBase slaveTable = HEDataModelUtil.transfer(slaveJson.toString());
                    slaveTableList.add(slaveTable);
                }
                for (HeRelationshipBase relationship : dataModel.getRelationships()) {
                    Optional<HeDataModelBase> slaveOpt;
                    if (HussarUtils.isEmpty((Object)relationship.getSlaveTableId()) || !(slaveOpt = slaveTableList.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst()).isPresent()) continue;
                    HeDataModelBase slaveModelBase = slaveOpt.get();
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(slaveModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    HeDataModelField dataModelField = new HeDataModelField();
                    dataModelField.setId(UUID.randomUUID().toString());
                    dataModelField.setName(slaveModelBase.getName());
                    dataModelField.setComment(slaveModelBase.getTableDesc());
                    dataModelField.setSourceDataModelId(slaveModelBase.getId());
                    dataModelField.setDataType("array");
                    fieldList.add(dataModelField);
                }
                dataModel.setSlaveTables(slaveTableList);
            }
            dataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return dataModel;
    }

    public HeDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(HeDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<HeDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<HeDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<HeRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<HeRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<HeQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<HeQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<HeQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<HeQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    public List<HeSortCondition> getSortCondition() {
        return this.sortCondition;
    }

    public void setSortCondition(List<HeSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public String getSourceDataModelName() {
        return null;
    }

    @Override
    public HeQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (HeQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public HeSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (HeSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<HeDataModelField>> findTableContrast() throws IOException, LcdpException {
        List tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<HeDataModelField>> tableContrastModel(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<HeDataModelField>> modelContrastTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        PublishCheckVO publishCheckVO = this.masterTable.checkTableContrast(modelId);
        if (publishCheckVO != null && ToolUtil.isNotEmpty((Object)publishCheckVO.getDetails())) {
            details.add(publishCheckVO.getDetails().get(0));
        }
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            PublishCheckVO slavePublishCheck = this.slaveTables.get(i).checkTableContrast(modelId);
            if (slavePublishCheck == null || !ToolUtil.isNotEmpty((Object)slavePublishCheck.getDetails())) continue;
            details.add(slavePublishCheck.getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (HeDataModelBase slaveTable : this.slaveTables) {
            slaveTable.updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public void sync() throws IOException, LcdpException {
        this.metaDataSync();
        this.syncModel(this.getFunctionType());
    }

    @Override
    public void syncById() throws IOException, LcdpException {
        this.metaDataSyncById();
        this.syncModelById(this.getFunctionType());
    }

    @Override
    public void syncModel(String functionType) {
        ModelPublishDTO masterTableInfo = HEOperationUtil.ModelToEngine(this.masterTable);
        masterTableInfo.setType(TypeConversionEnum.getValueByKey(functionType).getValue());
        HeRelationDTO relationDTO = HEDataModelUtil.slaveRelationSync(masterTableInfo, this.masterTable, this.slaveTables, this.relationships, functionType);
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        resultList.add(relationDTO.getMasterPublishDTO());
        resultList.addAll(relationDTO.getSlavePublishDTO());
        ((ModelRelateService)SpringUtil.getBean(ModelRelateService.class)).save(resultList);
    }

    @Override
    public void syncModelById(String functionType) {
    }

    @Override
    public void metaDataSync() throws IOException, LcdpException {
        this.masterTable.metaDataSync();
        for (HeDataModelBase slaveTable : this.slaveTables) {
            slaveTable.metaDataSync();
        }
    }

    @Override
    public void metaDataSyncById() throws IOException, LcdpException {
        this.masterTable.metaDataSyncById();
        for (HeDataModelBase slaveTable : this.slaveTables) {
            slaveTable.metaDataSyncById();
        }
    }

    @Override
    public void delete(String modelId) throws LcdpException {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        JSONObject modelJson = DataModelUtil.getDataModelJson((String)modelId);
        HeMSDataModel heMSDataModel = this.parseDataModel(modelJson);
        modelId = heMSDataModel.getMasterTable().getId();
        modelRelateService.delete(modelId);
    }

    @Override
    public void delete() {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        String modelId = this.getMasterTable().getId();
        modelRelateService.delete(modelId);
    }

    @Override
    public String copyTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        String sql = this.masterTable.copyTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            sql = sql + this.slaveTables.get(i).copyTable(fieldsContrastParam);
        }
        return sql;
    }

    public ModelTableMappingDTO getRelationById(String id) {
        return ((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(ToolUtil.isNotEmpty((Object)id) ? id : this.getMasterTable().getId());
    }

    @Override
    public List<String> getSourceDataModelNames() {
        ArrayList<String> tableName = new ArrayList<String>();
        List slaveTableNames = this.getSlaveTables().stream().map(HeDataModelBase::getSourceDataModelName).collect(Collectors.toList());
        tableName.add(this.getMasterTable().getSourceDataModelName());
        tableName.addAll(slaveTableNames);
        return tableName;
    }

    @Override
    public List<Long> getTableIds() {
        ArrayList<Long> tableIds = new ArrayList<Long>();
        List slaveTableIds = this.getSlaveTables().stream().map(DataModelBase::getTableId).collect(Collectors.toList());
        tableIds.add(this.getMasterTable().getTableId());
        tableIds.addAll(slaveTableIds);
        return tableIds;
    }

    @Override
    public List<String> getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List slaveIds = this.getSlaveTables().stream().map(DataModelBase::getId).collect(Collectors.toList());
        ids.add(this.getMasterTable().getId());
        ids.addAll(slaveIds);
        return ids;
    }

    @Override
    public Map<String, MetadataColumn> getColumnMap() {
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        for (String name : this.getSourceDataModelNames()) {
            TableInfoDto tableInfo = HeExternalApiUtil.getTableByName(name, true);
            if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
            for (MetadataColumn column : tableInfo.getColumnList()) {
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    @Override
    public Map<String, MetadataColumn> getColumnMapById() {
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        for (String id : this.getIds()) {
            TableInfoDto tableInfo = HeExternalApiUtil.getTableInfoById(id, true);
            if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
            for (MetadataColumn column : tableInfo.getColumnList()) {
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    @Override
    public PushBackCtx getPushBackCtx() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ctx.setModelId(this.getRelationById("").getRelatedId());
        ctx.setModelName(modelName);
        ctx.setColumnMap(this.getColumnMap());
        ctx.isMs = true;
        ctx.build();
        return ctx;
    }

    @Override
    public PushBackCtx getPushBackCtxById() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ctx.setModelId(this.getRelationById("").getRelatedId());
        ctx.setModelName(modelName);
        ctx.setColumnMap(this.getColumnMapById());
        ctx.isMs = true;
        ctx.build();
        return ctx;
    }

    @Override
    public String strategy() {
        return "HUSSAR_ENGINE";
    }

    @Override
    public void initMasterSlave(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx) {
        HeModelPublishService publishService = (HeModelPublishService)SpringUtil.getBean(HeModelPublishService.class);
        HeDataModelBase masterTable = this.getMasterTable();
        List<HeDataModelBase> slaveTables = this.getSlaveTables();
        HashMap<String, HeDataModelBase> baseMap = new HashMap<String, HeDataModelBase>(slaveTables.size() + 2);
        HashMap<String, HeDataModelBaseDTO> dtoMap = new HashMap<String, HeDataModelBaseDTO>(slaveTables.size() + 2);
        HeDataModelBaseDTO useDataModelBaseDto = publishService.enclosure(this);
        useDataModelBaseDto.getFields().clear();
        baseMap.put(this.getId(), this);
        dtoMap.put(this.getId(), useDataModelBaseDto);
        masterTable.setModelPath(this.getModelPath());
        baseMap.put(masterTable.getId(), masterTable);
        HeDataModelBaseDTO masterTableDto = publishService.enclosure(masterTable);
        useDataModelBaseDto.getFields().addAll(masterTableDto.getFields());
        dtoMap.put(masterTable.getId(), masterTableDto);
        for (HeDataModelBase slaveTable : slaveTables) {
            baseMap.put(slaveTable.getId(), slaveTable);
            HeDataModelBaseDTO slaveTableDto = publishService.enclosure(slaveTable);
            dtoMap.put(slaveTable.getId(), slaveTableDto);
            useDataModelBaseDto.getFields().addAll(slaveTableDto.getFields());
        }
        backCtx.setDataModelBaseMap(baseMap);
        backCtx.setUseDataModelDtoMap(dtoMap);
    }

    @Override
    public String getFormId() {
        return this.masterTable.getFormId();
    }
}

