/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.visitor.taskms;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.engine.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.HeOperationVisitor;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.HeMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.task.HeTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.operation.HeDataModelOperation;
import com.jxdinfo.hussar.formdesign.engine.util.HeBackRenderUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeEnginePushUtil;
import com.jxdinfo.hussar.formdesign.external.require.engine.enums.EngineMethodEnum;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HUSSAR_ENGINETASK_MASTER_SLAVEFlowTableFlagDelete")
public class HeTaskMsTableFlagDeleteVisitor
implements HeOperationVisitor<HeTaskMsDataModel, HeDataModelBaseDTO> {
    private static final Logger logger = LoggerFactory.getLogger(HeTaskMsTableFlagDeleteVisitor.class);
    public static final String OPERATION_NAME = "HUSSAR_ENGINETASK_MASTER_SLAVEFlowTableFlagDelete";

    @Override
    public void visit(HeBackCtx<HeTaskMsDataModel, HeDataModelBaseDTO> backCtx, HeDataModelOperation dataModelOperation, PushBackCtx engineCtx) throws LcdpException, IOException {
        logger.debug("{}\u65b9\u6cd5\u5f00\u59cb", (Object)OPERATION_NAME);
        HeTaskMsDataModel taskDataModel = backCtx.getUseDataModelBase();
        String currentModelId = taskDataModel.getId();
        HeDataModelBaseDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        logger.debug("\u63a8\u9001\u89e3\u6790\u5f15\u64ce");
        HeDataModelBase businessModel = backCtx.getUseDataModelBase().getBusinessTable();
        HeDataModelBaseDTO businessDto = dataModelBaseDTO;
        if ("MASTER_SLAVE".equals(businessModel.getFunctionType())) {
            businessDto = backCtx.getUseDataModelDtoMap().get(((HeMSDataModel)businessModel).getMasterTable().getId());
            businessDto.setTablePath(dataModelBaseDTO.getTablePath());
        }
        boolean isLogicallyDelete = businessModel.isLogicallyDelete();
        EngineMethodEnum engineMethodEnum = engineCtx.isMs ? EngineMethodEnum.MULTI_BPM_FLOW_FLAG_DELETE : EngineMethodEnum.SINGLE_BPM_FLOW_FLAG_DELETE;
        HeEnginePushUtil.pushFlagDeleteId(dataModelOperation.getName(), engineCtx, businessDto, engineMethodEnum.value.getName(), engineMethodEnum.value.getDesc(), new ArrayList<String>());
        engineMethodEnum = engineCtx.isMs ? EngineMethodEnum.MULTI_BPM_FLOW_FLAG_DELETE_UNSTART : EngineMethodEnum.SINGLE_BPM_FLOW_FLAG_DELETE_UNSTART;
        HeEnginePushUtil.pushFlagDeleteId(dataModelOperation.getName() + "UnStart", engineCtx, businessDto, engineMethodEnum.value.getName(), engineMethodEnum.value.getDesc(), new ArrayList<String>());
        logger.debug("api\u751f\u6210");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6d41\u7a0b\u8868\u683c\u5220\u9664");
        backCtx.addApi(currentModelId, HeBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName() + "UnStart", "data", "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName() + "UnStart", "\u6d41\u7a0b\u8868\u683c\u5220\u9664(\u4ec5\u5220\u9664\u672a\u542f\u52a8\u6d41\u7a0b\u548c\u8282\u70b9\u5904\u4e8e\u7b2c\u4e00\u8282\u70b9\u7684\u6d41\u7a0b)");
        backCtx.addApi(currentModelId, HeBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

