/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.engine.function.element.task;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.constant.FormDesignEngineExceptionEnum;
import com.jxdinfo.hussar.formdesign.engine.constant.TypeConversionEnum;
import com.jxdinfo.hussar.formdesign.engine.ctx.HeBackCtx;
import com.jxdinfo.hussar.formdesign.engine.function.element.base.HeBaseDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.HeMSDataModel;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationDTO;
import com.jxdinfo.hussar.formdesign.engine.function.element.masterslave.relationship.HeRelationshipBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBase;
import com.jxdinfo.hussar.formdesign.engine.function.model.HeDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.engine.function.model.field.HeDataModelField;
import com.jxdinfo.hussar.formdesign.engine.service.HeModelPublishService;
import com.jxdinfo.hussar.formdesign.engine.util.HEDataModelUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEModelBeanUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HEOperationUtil;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.engine.api.dto.ModelPublishDTO;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class HeTaskMsDataModel
extends HeMSDataModel {
    public static final String FUNCTION_TYPE = "TASK_MASTER_SLAVE";
    public static final String FUNCTION_TYPE_KEY = "functionType";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private HeBaseDataModel task;
    private HeDataModelBase businessTable;

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)String.format("%s%s", "HE.", FUNCTION_TYPE), HeTaskMsDataModel.class);
    }

    @Override
    public HeTaskMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        HeTaskMsDataModel dataModel;
        try {
            dataModel = (HeTaskMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), HeTaskMsDataModel.class);
            ArrayList<HeDataModelField> fieldList = new ArrayList<HeDataModelField>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                HeDataModelBase masterTableModel = HEDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                dataModel.setMasterTable(masterTableModel);
                fieldList.addAll(masterTableModel.getFields());
                HeMSDataModel businessModel = new HeMSDataModel().parseDataModel(jsonObject);
                dataModel.setFields(businessModel.getFields());
                businessModel.setModelPath(dataModel.getModelPath());
                businessModel.setFunctionType("MASTER_SLAVE");
                dataModel.setBusinessTable(businessModel);
            }
            ArrayList<HeDataModelBase> slaveTableList = new ArrayList<HeDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaveJson : JSONObject.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    HeDataModelBase slaveTable = HEDataModelUtil.transfer(slaveJson.toString());
                    slaveTableList.add(slaveTable);
                }
                for (HeRelationshipBase relationship : dataModel.getRelationships()) {
                    Optional<HeDataModelBase> slaveOpt;
                    if (HussarUtils.isEmpty((Object)relationship.getSlaveTableId()) || !(slaveOpt = slaveTableList.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst()).isPresent()) continue;
                    HeDataModelBase slaveModelBase = slaveOpt.get();
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(slaveModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    HeDataModelField dataModelField = new HeDataModelField();
                    dataModelField.setId(UUID.randomUUID().toString());
                    dataModelField.setName(slaveModelBase.getName());
                    dataModelField.setComment(slaveModelBase.getTableDesc());
                    dataModelField.setSourceDataModelId(slaveModelBase.getId());
                    dataModelField.setDataType("array");
                    fieldList.add(dataModelField);
                }
                dataModel.setSlaveTables(slaveTableList);
            }
            dataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, FormDesignEngineExceptionEnum.PARSING_OBJECT_FAILED.getMessage());
        }
        return dataModel;
    }

    public HeDataModelBase getBusinessTable() {
        return this.businessTable;
    }

    public void setBusinessTable(HeDataModelBase businessTable) {
        this.businessTable = businessTable;
    }

    public HeBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(HeBaseDataModel task) {
        this.task = task;
    }

    @Override
    public List<ContrastVO<HeDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public List<ContrastVO<HeDataModelField>> tableContrastModel(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel(fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<HeDataModelField>> modelContrastTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTable(fieldsContrastParam);
    }

    @Override
    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModelIndex(fieldsContrastParam);
    }

    @Override
    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTableIndex(fieldsContrastParam);
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return super.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        return super.updateTable(fieldsContrastParam);
    }

    @Override
    public void sync() throws IOException, LcdpException {
        this.taskMetaDataSync();
        this.metaDataSync();
        this.syncModel(FUNCTION_TYPE);
    }

    @Override
    public void syncModel(String functionType) {
        ModelPublishDTO taskMasterDTO = HEOperationUtil.ModelToEngine(this.task);
        taskMasterDTO.setType(TypeConversionEnum.getValueByKey(functionType).getValue());
        HeRelationDTO taskRelation = HEDataModelUtil.slaveRelationSync(taskMasterDTO, this.task, Collections.singletonList(this.getMasterTable()), this.getRelationships(), functionType);
        ModelPublishDTO businessMasterDTO = taskRelation.getSlavePublishDTO().get(0);
        HeRelationDTO businessMsRelation = HEDataModelUtil.slaveRelationSync(businessMasterDTO, this.getMasterTable(), this.getSlaveTables(), this.getRelationships(), functionType);
        ArrayList<ModelPublishDTO> resultList = new ArrayList<ModelPublishDTO>();
        resultList.add(taskRelation.getMasterPublishDTO());
        resultList.addAll(businessMsRelation.getSlavePublishDTO());
        resultList.add(businessMsRelation.getMasterPublishDTO());
        ((ModelRelateService)SpringUtil.getBean(ModelRelateService.class)).save(resultList);
    }

    @Override
    public void metaDataSync() throws IOException, LcdpException {
        this.businessTable.metaDataSync();
    }

    @Override
    public void delete(String modelId) throws LcdpException {
        super.delete(modelId);
    }

    @Override
    public void delete() {
        ModelRelateService modelRelateService = (ModelRelateService)SpringUtil.getBean(ModelRelateService.class);
        modelRelateService.delete(this.task.getId());
        super.delete();
    }

    @Override
    public String copyTable(FieldsContrastParam<HeDataModelField> fieldsContrastParam) throws Exception {
        return super.copyTable(fieldsContrastParam);
    }

    @Override
    public PushBackCtx getPushBackCtx() {
        return super.getPushBackCtx();
    }

    public Map<String, MetadataColumn> getTaskColumnMap() {
        ArrayList<String> tableName = new ArrayList<String>();
        tableName.add(this.getMasterTable().getSourceDataModelName());
        List slaveTableNames = this.getSlaveTables().stream().map(HeDataModelBase::getSourceDataModelName).collect(Collectors.toList());
        tableName.addAll(slaveTableNames);
        tableName.add(this.task.getSourceDataModelName());
        HashMap<String, MetadataColumn> columnMap = new HashMap<String, MetadataColumn>();
        for (String name : tableName) {
            TableInfoDto tableInfo = HeExternalApiUtil.getTableByName(name, true);
            if (!HussarUtils.isNotEmpty((Object)tableInfo)) continue;
            for (MetadataColumn column : tableInfo.getColumnList()) {
                if (ToolUtil.isNotEmpty((Object)name) && name.equals(this.task.getSourceDataModelName())) {
                    column = this.handleTaskColumnUsage(column);
                }
                columnMap.putIfAbsent(column.getTableName() + "-" + column.getColumnName(), column);
            }
        }
        return columnMap;
    }

    private MetadataColumn handleTaskColumnUsage(MetadataColumn column) {
        if (ToolUtil.isNotEmpty((Object)column) && ToolUtil.isNotEmpty((Object)column.getColumnAlias())) {
            switch (column.getColumnAlias()) {
                case "assignee": {
                    column.setPurpose("assignee");
                    break;
                }
                case "taskId": {
                    column.setPurpose("taskId");
                    break;
                }
                case "taskCreateTime": {
                    column.setPurpose("taskCreateTime");
                    break;
                }
                case "endTime": {
                    column.setPurpose("endTime");
                    break;
                }
                case "taskType": {
                    column.setPurpose("taskType");
                    break;
                }
                case "taskState": {
                    column.setPurpose("taskState");
                    break;
                }
                case "taskDefKey": {
                    column.setPurpose("taskDefinitionKey");
                    break;
                }
                case "taskDefName": {
                    column.setPurpose("taskDefinitionName");
                    break;
                }
                case "formKey": {
                    column.setPurpose("formKey");
                    break;
                }
                case "formDetailKey": {
                    column.setPurpose("formDetailKey");
                    break;
                }
                case "dueTime": {
                    column.setPurpose("dueTime");
                    break;
                }
                default: {
                    return column;
                }
            }
        }
        return column;
    }

    public PushBackCtx getTaskPushBackCtx() {
        String modelName = this.getName();
        PushBackCtx ctx = new PushBackCtx();
        ctx.setModelName(modelName);
        ctx.setModelId(((ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelTableMapping(this.task.getId()).getRelatedId());
        ctx.setColumnMap(this.getTaskColumnMap());
        ctx.isMs = true;
        ctx.build();
        return ctx;
    }

    @Override
    public String strategy() {
        return "HUSSAR_ENGINE";
    }

    @Override
    public void initMasterSlave(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx) {
        super.initMasterSlave(backCtx);
        HeModelPublishService publishService = (HeModelPublishService)SpringUtil.getBean(HeModelPublishService.class);
        HeDataModelBaseDTO taskMasterDto = publishService.enclosure(this.task);
        backCtx.getDataModelBaseMap().put(this.task.getId(), this.task);
        backCtx.getUseDataModelDtoMap().put(this.task.getId(), taskMasterDto);
        HeDataModelBaseDTO msDto = publishService.enclosure(this);
        HeDataModelBaseDTO masterDto = publishService.enclosure(this.getMasterTable());
        msDto.getFields().clear();
        msDto.setFields(masterDto.getFields());
        msDto.getFields().addAll(taskMasterDto.getFields());
        HashMap<String, HeDataModelBaseDTO> dtoMap = new HashMap<String, HeDataModelBaseDTO>(1);
        dtoMap.put(this.getId(), msDto);
        backCtx.setTaskDtoMap(dtoMap);
    }

    public void taskMetaDataSync() throws IOException, LcdpException {
        MetadataParam param = HeTaskMsDataModel.dealInfo(this.task);
        TableInfoDto tableInfoByTableName = HeExternalApiUtil.getTableByName(this.task.getSourceDataModelName(), false);
        if (tableInfoByTableName == null) {
            HeExternalApiUtil.insertTableInfo(param);
        } else {
            Long tableId = tableInfoByTableName.getTableId();
            param.getTableInfo().setTableId(tableId);
            HeExternalApiUtil.updateTableInfo(param);
        }
    }

    public static MetadataParam dealInfo(HeBaseDataModel dataModel) {
        MetadataParam param = new MetadataParam();
        TableInfoDto tableInfo = new TableInfoDto();
        tableInfo.setTableName(dataModel.getSourceDataModelName());
        tableInfo.setTableAlias(dataModel.getName());
        tableInfo.setTableDec(dataModel.getTableDesc());
        tableInfo.setPollName(dataModel.getDataSourceName());
        SysDataSource datasource = HeExternalApiUtil.getDataSourceName(dataModel.getDataSourceName());
        tableInfo.setDatasourceId(datasource.getId());
        param.setTableInfo(tableInfo);
        ArrayList<ColumnInfoDto> columnInfo = new ArrayList<ColumnInfoDto>();
        HeTaskMsDataModel.dealColumn(columnInfo, dataModel.getFields());
        param.setColumnInfo(columnInfo);
        param.setTfModelId(dataModel.getId());
        return param;
    }

    private static void dealColumn(List<ColumnInfoDto> columnInfo, List<HeDataModelField> fields) {
        if (HussarUtils.isEmpty(fields)) {
            return;
        }
        for (HeDataModelField field : fields) {
            ColumnInfoDto column = new ColumnInfoDto();
            column.setColumnName(field.getSourceFieldName());
            column.setColumnAlias(field.getName());
            column.setColumnComment(field.getComment());
            column.setDataType(field.getSourceDataType());
            column.setDataDot(field.getDataDot());
            column.setDataLength(Long.valueOf(field.getDataLength()));
            column.setDataIsEmpty(Integer.valueOf(field.getDataIsEmpty() ? 1 : 0));
            column.setTfModelColumnId(field.getId());
            if (ToolUtil.isNotEmpty((Object)field.getUsage())) {
                if ("primary".equals(field.getUsage())) {
                    column.setPrimarys("1");
                }
                column.setPurpose(field.getUsage());
            } else {
                String s = HeTaskMsDataModel.taskUsageField(field);
                if (ToolUtil.isNotEmpty((Object)s)) {
                    column.setPurpose(s);
                }
            }
            Optional engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)field.getDataType());
            if (engineColumnType.isPresent()) {
                column.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                column.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
            }
            columnInfo.add(column);
        }
    }

    private static String taskUsageField(HeDataModelField field) {
        String name = field.getUsage();
        if (ToolUtil.isNotEmpty((Object)((Object)field)) && ToolUtil.isNotEmpty((Object)field.getName())) {
            switch (field.getName()) {
                case "assignee": 
                case "taskId": 
                case "endTime": 
                case "taskType": 
                case "taskState": 
                case "formKey": 
                case "formDetailKey": 
                case "dueTime": 
                case "taskCreateTime": {
                    name = field.getName();
                    break;
                }
                case "taskDefKey": {
                    name = "taskDefinitionKey";
                    break;
                }
                case "taskDefName": {
                    name = "taskDefinitionName";
                    break;
                }
            }
        }
        return name;
    }

    @Override
    public void customOption(HeBackCtx<HeDataModelBase, HeDataModelBaseDTO> backCtx, PushBackCtx engineCtx) throws LcdpException {
        HEModelBeanUtil.getCustomOperationBean("HUSSAR_ENGINE", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx, engineCtx);
    }
}

